/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.metastore.glue;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.trino.plugin.deltalake.DeltaLakeQueryRunner;
import io.trino.plugin.hive.BaseS3AndGlueMetastoreTest;
import io.trino.plugin.hive.metastore.glue.TestingGlueHiveMetastore;
import io.trino.testing.QueryRunner;
import io.trino.testing.SystemEnvironmentUtils;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;

public class TestDeltaS3AndGlueMetastoreTest
extends BaseS3AndGlueMetastoreTest {
    public TestDeltaS3AndGlueMetastoreTest() {
        super("partitioned_by", "location", SystemEnvironmentUtils.requireEnv((String)"S3_BUCKET"));
    }

    protected QueryRunner createQueryRunner() throws Exception {
        TestDeltaS3AndGlueMetastoreTest testDeltaS3AndGlueMetastoreTest = this;
        this.metastore = TestingGlueHiveMetastore.createTestingGlueHiveMetastore((URI)URI.create(this.schemaPath()), x$0 -> testDeltaS3AndGlueMetastoreTest.closeAfterClass((AutoCloseable)x$0));
        return DeltaLakeQueryRunner.builder(this.schemaName).setDeltaProperties((Map<String, String>)ImmutableMap.builder().put((Object)"hive.metastore", (Object)"glue").put((Object)"hive.metastore.glue.default-warehouse-dir", (Object)this.schemaPath()).put((Object)"fs.native-s3.enabled", (Object)"true").put((Object)"delta.enable-non-concurrent-writes", (Object)"true").buildOrThrow()).setSchemaLocation(this.schemaPath()).build();
    }

    protected void validateDataFiles(String partitionColumn, String tableName, String location) {
        this.getActiveFiles(tableName).forEach(dataFile -> {
            Object locationDirectory = location.endsWith("/") ? location : location + "/";
            Object partitionPart = partitionColumn.isEmpty() ? "" : partitionColumn + "=[a-z0-9]+/";
            Assertions.assertThat((String)dataFile).matches((CharSequence)("^" + Pattern.quote((String)locationDirectory) + (String)partitionPart + "[a-zA-Z0-9_-]+$"));
            this.verifyPathExist((String)dataFile);
        });
    }

    protected void validateMetadataFiles(String location) {
        Object locationDirectory = location.endsWith("/") ? location : location + "/";
        this.getAllMetadataDataFilesFromTableDirectory(location).forEach(arg_0 -> this.lambda$validateMetadataFiles$0((String)locationDirectory, arg_0));
        Assertions.assertThat((String)this.getExtendedStatisticsFileFromTableDirectory(location)).matches((CharSequence)("^" + Pattern.quote((String)locationDirectory) + "_delta_log/_trino_meta/extended_stats.json$"));
    }

    protected void validateFilesAfterDrop(String location) {
        Assertions.assertThat((List)this.getTableFiles(location)).isNotEmpty();
    }

    protected Set<String> getAllDataFilesFromTableDirectory(String tableLocation) {
        return this.getTableFiles(tableLocation).stream().filter(path -> !path.contains("_delta_log")).collect(Collectors.toUnmodifiableSet());
    }

    private Set<String> getAllMetadataDataFilesFromTableDirectory(String tableLocation) {
        return this.getTableFiles(tableLocation).stream().filter(path -> path.contains("/metadata")).collect(Collectors.toUnmodifiableSet());
    }

    private String getExtendedStatisticsFileFromTableDirectory(String tableLocation) {
        return (String)Iterables.getOnlyElement((Iterable)this.getTableFiles(tableLocation).stream().filter(path -> path.contains("/_trino_meta")).collect(Collectors.toUnmodifiableSet()));
    }

    private /* synthetic */ void lambda$validateMetadataFiles$0(String locationDirectory, String metadataFile) {
        Assertions.assertThat((String)metadataFile).matches((CharSequence)("^" + Pattern.quote(locationDirectory) + "_delta_log/[0-9]+.json$"));
        this.verifyPathExist(metadataFile);
    }
}

