/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.statistics;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.json.JsonCodecFactory;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.base.metrics.FileFormatDataSourceStats;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnType;
import io.trino.plugin.deltalake.DeltaLakeConfig;
import io.trino.plugin.deltalake.DeltaLakeSessionProperties;
import io.trino.plugin.deltalake.DeltaLakeTableHandle;
import io.trino.plugin.deltalake.DeltaTestingConnectorSession;
import io.trino.plugin.deltalake.statistics.CachingExtendedStatisticsAccess;
import io.trino.plugin.deltalake.statistics.DeltaLakeColumnStatistics;
import io.trino.plugin.deltalake.statistics.DeltaLakeTableStatisticsProvider;
import io.trino.plugin.deltalake.statistics.ExtendedStatistics;
import io.trino.plugin.deltalake.statistics.ExtendedStatisticsAccess;
import io.trino.plugin.deltalake.statistics.FileBasedTableStatisticsProvider;
import io.trino.plugin.deltalake.statistics.MetaDirStatisticsAccess;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import io.trino.plugin.deltalake.transactionlog.TableSnapshot;
import io.trino.plugin.deltalake.transactionlog.TransactionLogAccess;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointSchemaManager;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import io.trino.plugin.hive.parquet.ParquetWriterConfig;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.statistics.ColumnStatistics;
import io.trino.spi.statistics.DoubleRange;
import io.trino.spi.statistics.Estimate;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.testing.TestingConnectorContext;
import io.trino.testing.TestingConnectorSession;
import java.io.IOException;
import java.time.LocalDate;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.ExecutorService;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDeltaLakeFileBasedTableStatisticsProvider {
    private static final ColumnHandle COLUMN_HANDLE = new DeltaLakeColumnHandle("val", (Type)DoubleType.DOUBLE, OptionalInt.empty(), "val", (Type)DoubleType.DOUBLE, DeltaLakeColumnType.REGULAR, Optional.empty());
    private final TransactionLogAccess transactionLogAccess;
    private final CachingExtendedStatisticsAccess statistics;
    private final DeltaLakeTableStatisticsProvider tableStatisticsProvider;

    public TestDeltaLakeFileBasedTableStatisticsProvider() {
        TestingConnectorContext context = new TestingConnectorContext();
        TypeManager typeManager = context.getTypeManager();
        CheckpointSchemaManager checkpointSchemaManager = new CheckpointSchemaManager(typeManager);
        FileFormatDataSourceStats fileFormatDataSourceStats = new FileFormatDataSourceStats();
        this.transactionLogAccess = new TransactionLogAccess(typeManager, checkpointSchemaManager, new DeltaLakeConfig(), fileFormatDataSourceStats, (TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, new ParquetReaderConfig(), (ExecutorService)MoreExecutors.newDirectExecutorService());
        this.statistics = new CachingExtendedStatisticsAccess((ExtendedStatisticsAccess)new MetaDirStatisticsAccess((TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, new JsonCodecFactory().jsonCodec(ExtendedStatistics.class)));
        this.tableStatisticsProvider = new FileBasedTableStatisticsProvider(typeManager, this.transactionLogAccess, this.statistics);
    }

    private DeltaLakeTableHandle registerTable(String tableName) {
        return this.registerTable(tableName, tableName);
    }

    private DeltaLakeTableHandle registerTable(String tableName, String directoryName) {
        TableSnapshot tableSnapshot;
        String tableLocation = Resources.getResource((String)("statistics/" + directoryName)).toExternalForm();
        SchemaTableName schemaTableName = new SchemaTableName("db_name", tableName);
        try {
            tableSnapshot = this.transactionLogAccess.loadSnapshot(DeltaTestingConnectorSession.SESSION, schemaTableName, tableLocation, Optional.empty());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        MetadataEntry metadataEntry = this.transactionLogAccess.getMetadataEntry(DeltaTestingConnectorSession.SESSION, tableSnapshot);
        return new DeltaLakeTableHandle(schemaTableName.getSchemaName(), schemaTableName.getTableName(), false, tableLocation, metadataEntry, new ProtocolEntry(1, 2, Optional.empty(), Optional.empty()), TupleDomain.all(), TupleDomain.all(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), 0L, false);
    }

    @Test
    public void testStatisticsNaN() {
        DeltaLakeTableHandle tableHandle = this.registerTable("nan");
        TableStatistics stats = this.getTableStatistics(DeltaTestingConnectorSession.SESSION, tableHandle);
        Assertions.assertThat((Object)stats.getRowCount()).isEqualTo((Object)Estimate.of((double)1.0));
        Assertions.assertThat((Map)stats.getColumnStatistics()).hasSize(1);
        ColumnStatistics columnStatistics = (ColumnStatistics)stats.getColumnStatistics().get(COLUMN_HANDLE);
        Assertions.assertThat((Optional)columnStatistics.getRange()).isEqualTo(Optional.empty());
    }

    @Test
    public void testStatisticsInf() {
        DeltaLakeTableHandle tableHandle = this.registerTable("positive_infinity");
        TableStatistics stats = this.getTableStatistics(DeltaTestingConnectorSession.SESSION, tableHandle);
        ColumnStatistics columnStatistics = (ColumnStatistics)stats.getColumnStatistics().get(COLUMN_HANDLE);
        Assertions.assertThat((double)((DoubleRange)columnStatistics.getRange().get()).getMin()).isEqualTo(Double.POSITIVE_INFINITY);
        Assertions.assertThat((double)((DoubleRange)columnStatistics.getRange().get()).getMax()).isEqualTo(Double.POSITIVE_INFINITY);
    }

    @Test
    public void testStatisticsNegInf() {
        DeltaLakeTableHandle tableHandle = this.registerTable("negative_infinity");
        TableStatistics stats = this.getTableStatistics(DeltaTestingConnectorSession.SESSION, tableHandle);
        ColumnStatistics columnStatistics = (ColumnStatistics)stats.getColumnStatistics().get(COLUMN_HANDLE);
        Assertions.assertThat((double)((DoubleRange)columnStatistics.getRange().get()).getMin()).isEqualTo(Double.NEGATIVE_INFINITY);
        Assertions.assertThat((double)((DoubleRange)columnStatistics.getRange().get()).getMax()).isEqualTo(Double.NEGATIVE_INFINITY);
    }

    @Test
    public void testStatisticsNegZero() {
        DeltaLakeTableHandle tableHandle = this.registerTable("negative_zero");
        TableStatistics stats = this.getTableStatistics(DeltaTestingConnectorSession.SESSION, tableHandle);
        ColumnStatistics columnStatistics = (ColumnStatistics)stats.getColumnStatistics().get(COLUMN_HANDLE);
        Assertions.assertThat((double)((DoubleRange)columnStatistics.getRange().get()).getMin()).isEqualTo(-0.0);
        Assertions.assertThat((double)((DoubleRange)columnStatistics.getRange().get()).getMax()).isEqualTo(-0.0);
    }

    @Test
    public void testStatisticsInfinityAndNaN() {
        DeltaLakeTableHandle tableHandle = this.registerTable("infinity_nan");
        TableStatistics stats = this.getTableStatistics(DeltaTestingConnectorSession.SESSION, tableHandle);
        ColumnStatistics columnStatistics = (ColumnStatistics)stats.getColumnStatistics().get(COLUMN_HANDLE);
        Assertions.assertThat((double)((DoubleRange)columnStatistics.getRange().get()).getMin()).isEqualTo(Double.POSITIVE_INFINITY);
        Assertions.assertThat((double)((DoubleRange)columnStatistics.getRange().get()).getMax()).isEqualTo(Double.POSITIVE_INFINITY);
    }

    @Test
    public void testStatisticsNegativeInfinityAndNaN() {
        DeltaLakeTableHandle tableHandle = this.registerTable("negative_infinity_nan");
        TableStatistics stats = this.getTableStatistics(DeltaTestingConnectorSession.SESSION, tableHandle);
        ColumnStatistics columnStatistics = (ColumnStatistics)stats.getColumnStatistics().get(COLUMN_HANDLE);
        Assertions.assertThat((double)((DoubleRange)columnStatistics.getRange().get()).getMin()).isEqualTo(Double.NEGATIVE_INFINITY);
        Assertions.assertThat((double)((DoubleRange)columnStatistics.getRange().get()).getMax()).isEqualTo(Double.POSITIVE_INFINITY);
    }

    @Test
    public void testStatisticsZeroAndNaN() {
        DeltaLakeTableHandle tableHandle = this.registerTable("zero_nan");
        TableStatistics stats = this.getTableStatistics(DeltaTestingConnectorSession.SESSION, tableHandle);
        ColumnStatistics columnStatistics = (ColumnStatistics)stats.getColumnStatistics().get(COLUMN_HANDLE);
        Assertions.assertThat((double)((DoubleRange)columnStatistics.getRange().get()).getMin()).isEqualTo(0.0);
        Assertions.assertThat((double)((DoubleRange)columnStatistics.getRange().get()).getMax()).isEqualTo(Double.POSITIVE_INFINITY);
    }

    @Test
    public void testStatisticsZeroAndInfinity() {
        DeltaLakeTableHandle tableHandle = this.registerTable("zero_infinity");
        TableStatistics stats = this.getTableStatistics(DeltaTestingConnectorSession.SESSION, tableHandle);
        ColumnStatistics columnStatistics = (ColumnStatistics)stats.getColumnStatistics().get(COLUMN_HANDLE);
        Assertions.assertThat((double)((DoubleRange)columnStatistics.getRange().get()).getMin()).isEqualTo(0.0);
        Assertions.assertThat((double)((DoubleRange)columnStatistics.getRange().get()).getMax()).isEqualTo(Double.POSITIVE_INFINITY);
    }

    @Test
    public void testStatisticsZeroAndNegativeInfinity() {
        DeltaLakeTableHandle tableHandle = this.registerTable("zero_negative_infinity");
        TableStatistics stats = this.getTableStatistics(DeltaTestingConnectorSession.SESSION, tableHandle);
        ColumnStatistics columnStatistics = (ColumnStatistics)stats.getColumnStatistics().get(COLUMN_HANDLE);
        Assertions.assertThat((double)((DoubleRange)columnStatistics.getRange().get()).getMin()).isEqualTo(Double.NEGATIVE_INFINITY);
        Assertions.assertThat((double)((DoubleRange)columnStatistics.getRange().get()).getMax()).isEqualTo(0.0);
    }

    @Test
    public void testStatisticsNaNWithMultipleFiles() {
        DeltaLakeTableHandle tableHandle = this.registerTable("nan_multi_file");
        TableStatistics stats = this.getTableStatistics(DeltaTestingConnectorSession.SESSION, tableHandle);
        ColumnStatistics columnStatistics = (ColumnStatistics)stats.getColumnStatistics().get(COLUMN_HANDLE);
        Assertions.assertThat((Optional)columnStatistics.getRange()).isEqualTo(Optional.empty());
    }

    @Test
    public void testStatisticsMultipleFiles() {
        DeltaLakeTableHandle tableHandle = this.registerTable("basic_multi_file");
        TableStatistics stats = this.getTableStatistics(DeltaTestingConnectorSession.SESSION, tableHandle);
        ColumnStatistics columnStatistics = (ColumnStatistics)stats.getColumnStatistics().get(COLUMN_HANDLE);
        Assertions.assertThat((double)((DoubleRange)columnStatistics.getRange().get()).getMin()).isEqualTo(-42.0);
        Assertions.assertThat((double)((DoubleRange)columnStatistics.getRange().get()).getMax()).isEqualTo(42.0);
        DeltaLakeTableHandle tableHandleWithUnenforcedConstraint = new DeltaLakeTableHandle(tableHandle.getSchemaName(), tableHandle.getTableName(), tableHandle.isManaged(), tableHandle.getLocation(), tableHandle.getMetadataEntry(), tableHandle.getProtocolEntry(), TupleDomain.all(), TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)((DeltaLakeColumnHandle)COLUMN_HANDLE), (Object)Domain.singleValue((Type)DoubleType.DOUBLE, (Object)42.0))), tableHandle.getWriteType(), tableHandle.getProjectedColumns(), tableHandle.getUpdatedColumns(), tableHandle.getUpdateRowIdColumns(), tableHandle.getAnalyzeHandle(), 0L, tableHandle.isTimeTravel());
        stats = this.getTableStatistics(DeltaTestingConnectorSession.SESSION, tableHandleWithUnenforcedConstraint);
        columnStatistics = (ColumnStatistics)stats.getColumnStatistics().get(COLUMN_HANDLE);
        Assertions.assertThat((double)((DoubleRange)columnStatistics.getRange().get()).getMin()).isEqualTo(0.0);
        Assertions.assertThat((double)((DoubleRange)columnStatistics.getRange().get()).getMax()).isEqualTo(42.0);
    }

    @Test
    public void testStatisticsNoRecords() {
        DeltaLakeTableHandle tableHandle = this.registerTable("zero_record_count", "basic_multi_file");
        DeltaLakeTableHandle tableHandleWithNoneEnforcedConstraint = new DeltaLakeTableHandle(tableHandle.getSchemaName(), tableHandle.getTableName(), tableHandle.isManaged(), tableHandle.getLocation(), tableHandle.getMetadataEntry(), tableHandle.getProtocolEntry(), TupleDomain.none(), TupleDomain.all(), tableHandle.getWriteType(), tableHandle.getProjectedColumns(), tableHandle.getUpdatedColumns(), tableHandle.getUpdateRowIdColumns(), tableHandle.getAnalyzeHandle(), 0L, tableHandle.isTimeTravel());
        DeltaLakeTableHandle tableHandleWithNoneUnenforcedConstraint = new DeltaLakeTableHandle(tableHandle.getSchemaName(), tableHandle.getTableName(), tableHandle.isManaged(), tableHandle.getLocation(), tableHandle.getMetadataEntry(), tableHandle.getProtocolEntry(), TupleDomain.all(), TupleDomain.none(), tableHandle.getWriteType(), tableHandle.getProjectedColumns(), tableHandle.getUpdatedColumns(), tableHandle.getUpdateRowIdColumns(), tableHandle.getAnalyzeHandle(), 0L, tableHandle.isTimeTravel());
        this.assertEmptyStats(this.getTableStatistics(DeltaTestingConnectorSession.SESSION, tableHandleWithNoneEnforcedConstraint));
        this.assertEmptyStats(this.getTableStatistics(DeltaTestingConnectorSession.SESSION, tableHandleWithNoneUnenforcedConstraint));
    }

    private void assertEmptyStats(TableStatistics tableStatistics) {
        Assertions.assertThat((Object)tableStatistics.getRowCount()).isEqualTo((Object)Estimate.of((double)0.0));
        ColumnStatistics columnStatistics = (ColumnStatistics)tableStatistics.getColumnStatistics().get(COLUMN_HANDLE);
        Assertions.assertThat((Object)columnStatistics.getNullsFraction()).isEqualTo((Object)Estimate.of((double)0.0));
        Assertions.assertThat((Object)columnStatistics.getDistinctValuesCount()).isEqualTo((Object)Estimate.of((double)0.0));
    }

    @Test
    public void testStatisticsParquetParsedStatistics() {
        DeltaLakeTableHandle tableHandle = this.registerTable("parquet_struct_statistics");
        TestingConnectorSession activeDataFileCacheSession = TestingConnectorSession.builder().setPropertyMetadata(new DeltaLakeSessionProperties(new DeltaLakeConfig().setCheckpointFilteringEnabled(false), new ParquetReaderConfig(), new ParquetWriterConfig()).getSessionProperties()).build();
        TableStatistics stats = this.getTableStatistics((ConnectorSession)activeDataFileCacheSession, tableHandle);
        Assertions.assertThat((Object)stats.getRowCount()).isEqualTo((Object)Estimate.of((double)9.0));
        Map statisticsMap = stats.getColumnStatistics();
        ColumnStatistics columnStats = (ColumnStatistics)statisticsMap.get(new DeltaLakeColumnHandle("dec_short", (Type)DecimalType.createDecimalType((int)5, (int)1), OptionalInt.empty(), "dec_short", (Type)DecimalType.createDecimalType((int)5, (int)1), DeltaLakeColumnType.REGULAR, Optional.empty()));
        Assertions.assertThat((Object)columnStats.getNullsFraction()).isEqualTo((Object)Estimate.zero());
        Assertions.assertThat((double)((DoubleRange)columnStats.getRange().get()).getMin()).isEqualTo(-10.1);
        Assertions.assertThat((double)((DoubleRange)columnStats.getRange().get()).getMax()).isEqualTo(10.1);
        columnStats = (ColumnStatistics)statisticsMap.get(new DeltaLakeColumnHandle("dec_long", (Type)DecimalType.createDecimalType((int)25, (int)3), OptionalInt.empty(), "dec_long", (Type)DecimalType.createDecimalType((int)25, (int)3), DeltaLakeColumnType.REGULAR, Optional.empty()));
        Assertions.assertThat((Object)columnStats.getNullsFraction()).isEqualTo((Object)Estimate.zero());
        Assertions.assertThat((double)((DoubleRange)columnStats.getRange().get()).getMin()).isEqualTo(-9.99999999999123E11);
        Assertions.assertThat((double)((DoubleRange)columnStats.getRange().get()).getMax()).isEqualTo(9.99999999999123E11);
        columnStats = (ColumnStatistics)statisticsMap.get(new DeltaLakeColumnHandle("l", (Type)BigintType.BIGINT, OptionalInt.empty(), "l", (Type)BigintType.BIGINT, DeltaLakeColumnType.REGULAR, Optional.empty()));
        Assertions.assertThat((Object)columnStats.getNullsFraction()).isEqualTo((Object)Estimate.zero());
        Assertions.assertThat((double)((DoubleRange)columnStats.getRange().get()).getMin()).isEqualTo(-1.0E7);
        Assertions.assertThat((double)((DoubleRange)columnStats.getRange().get()).getMax()).isEqualTo(1.0E7);
        columnStats = (ColumnStatistics)statisticsMap.get(new DeltaLakeColumnHandle("in", (Type)IntegerType.INTEGER, OptionalInt.empty(), "in", (Type)IntegerType.INTEGER, DeltaLakeColumnType.REGULAR, Optional.empty()));
        Assertions.assertThat((Object)columnStats.getNullsFraction()).isEqualTo((Object)Estimate.zero());
        Assertions.assertThat((double)((DoubleRange)columnStats.getRange().get()).getMin()).isEqualTo(-2.0E7);
        Assertions.assertThat((double)((DoubleRange)columnStats.getRange().get()).getMax()).isEqualTo(2.0E7);
        columnStats = (ColumnStatistics)statisticsMap.get(new DeltaLakeColumnHandle("sh", (Type)SmallintType.SMALLINT, OptionalInt.empty(), "sh", (Type)SmallintType.SMALLINT, DeltaLakeColumnType.REGULAR, Optional.empty()));
        Assertions.assertThat((Object)columnStats.getNullsFraction()).isEqualTo((Object)Estimate.zero());
        Assertions.assertThat((double)((DoubleRange)columnStats.getRange().get()).getMin()).isEqualTo(-123.0);
        Assertions.assertThat((double)((DoubleRange)columnStats.getRange().get()).getMax()).isEqualTo(123.0);
        columnStats = (ColumnStatistics)statisticsMap.get(new DeltaLakeColumnHandle("byt", (Type)TinyintType.TINYINT, OptionalInt.empty(), "byt", (Type)TinyintType.TINYINT, DeltaLakeColumnType.REGULAR, Optional.empty()));
        Assertions.assertThat((Object)columnStats.getNullsFraction()).isEqualTo((Object)Estimate.zero());
        Assertions.assertThat((double)((DoubleRange)columnStats.getRange().get()).getMin()).isEqualTo(-42.0);
        Assertions.assertThat((double)((DoubleRange)columnStats.getRange().get()).getMax()).isEqualTo(42.0);
        columnStats = (ColumnStatistics)statisticsMap.get(new DeltaLakeColumnHandle("fl", (Type)RealType.REAL, OptionalInt.empty(), "fl", (Type)RealType.REAL, DeltaLakeColumnType.REGULAR, Optional.empty()));
        Assertions.assertThat((Object)columnStats.getNullsFraction()).isEqualTo((Object)Estimate.zero());
        Assertions.assertThat((float)((float)((DoubleRange)columnStats.getRange().get()).getMin())).isEqualTo(-0.123f);
        Assertions.assertThat((float)((float)((DoubleRange)columnStats.getRange().get()).getMax())).isEqualTo(0.123f);
        columnStats = (ColumnStatistics)statisticsMap.get(new DeltaLakeColumnHandle("dou", (Type)DoubleType.DOUBLE, OptionalInt.empty(), "dou", (Type)DoubleType.DOUBLE, DeltaLakeColumnType.REGULAR, Optional.empty()));
        Assertions.assertThat((Object)columnStats.getNullsFraction()).isEqualTo((Object)Estimate.zero());
        Assertions.assertThat((double)((DoubleRange)columnStats.getRange().get()).getMin()).isEqualTo(-0.321);
        Assertions.assertThat((double)((DoubleRange)columnStats.getRange().get()).getMax()).isEqualTo(0.321);
        columnStats = (ColumnStatistics)statisticsMap.get(new DeltaLakeColumnHandle("dat", (Type)DateType.DATE, OptionalInt.empty(), "dat", (Type)DateType.DATE, DeltaLakeColumnType.REGULAR, Optional.empty()));
        Assertions.assertThat((Object)columnStats.getNullsFraction()).isEqualTo((Object)Estimate.zero());
        Assertions.assertThat((double)((DoubleRange)columnStats.getRange().get()).getMin()).isEqualTo((double)LocalDate.parse("1900-01-01").toEpochDay());
        Assertions.assertThat((double)((DoubleRange)columnStats.getRange().get()).getMax()).isEqualTo((double)LocalDate.parse("5000-01-01").toEpochDay());
    }

    @Test
    public void testStatisticsParquetParsedStatisticsNaNValues() {
        DeltaLakeTableHandle tableHandle = this.registerTable("parquet_struct_statistics_nan");
        TableStatistics stats = this.getTableStatistics(DeltaTestingConnectorSession.SESSION, tableHandle);
        Assertions.assertThat((Object)stats.getRowCount()).isEqualTo((Object)Estimate.of((double)9.0));
        Map statisticsMap = stats.getColumnStatistics();
        ColumnStatistics columnStats = (ColumnStatistics)statisticsMap.get(new DeltaLakeColumnHandle("fl", (Type)RealType.REAL, OptionalInt.empty(), "fl", (Type)RealType.REAL, DeltaLakeColumnType.REGULAR, Optional.empty()));
        Assertions.assertThat((Object)columnStats.getNullsFraction()).isEqualTo((Object)Estimate.zero());
        Assertions.assertThat((Optional)columnStats.getRange()).isEmpty();
        columnStats = (ColumnStatistics)statisticsMap.get(new DeltaLakeColumnHandle("dou", (Type)DoubleType.DOUBLE, OptionalInt.empty(), "dou", (Type)DoubleType.DOUBLE, DeltaLakeColumnType.REGULAR, Optional.empty()));
        Assertions.assertThat((Object)columnStats.getNullsFraction()).isEqualTo((Object)Estimate.zero());
        Assertions.assertThat((Optional)columnStats.getRange()).isEmpty();
    }

    @Test
    public void testStatisticsParquetParsedStatisticsNullCount() {
        DeltaLakeTableHandle tableHandle = this.registerTable("parquet_struct_statistics_null_count");
        TableStatistics stats = this.getTableStatistics(DeltaTestingConnectorSession.SESSION, tableHandle);
        Assertions.assertThat((Object)stats.getRowCount()).isEqualTo((Object)Estimate.of((double)9.0));
        Map statisticsMap = stats.getColumnStatistics();
        ColumnStatistics columnStats = (ColumnStatistics)statisticsMap.get(new DeltaLakeColumnHandle("i", (Type)IntegerType.INTEGER, OptionalInt.empty(), "i", (Type)IntegerType.INTEGER, DeltaLakeColumnType.REGULAR, Optional.empty()));
        Assertions.assertThat((Object)columnStats.getNullsFraction()).isEqualTo((Object)Estimate.of((double)0.3333333333333333));
    }

    @Test
    public void testExtendedStatisticsWithoutDataSize() {
        Optional<ExtendedStatistics> extendedStatistics = this.readExtendedStatisticsFromTableResource("statistics/extended_stats_without_data_size");
        Assertions.assertThat(extendedStatistics).isNotEmpty();
        Map columnStatistics = extendedStatistics.get().getColumnStatistics();
        Assertions.assertThat((Map)columnStatistics).hasSize(3);
    }

    @Test
    public void testExtendedStatisticsWithDataSize() {
        Optional<ExtendedStatistics> extendedStatistics = this.readExtendedStatisticsFromTableResource("statistics/extended_stats_with_data_size");
        Assertions.assertThat(extendedStatistics).isNotEmpty();
        Map columnStatistics = extendedStatistics.get().getColumnStatistics();
        Assertions.assertThat((Map)columnStatistics).hasSize(3);
        Assertions.assertThat((OptionalLong)((DeltaLakeColumnStatistics)columnStatistics.get("regionkey")).getTotalSizeInBytes()).isEqualTo((Object)OptionalLong.empty());
        Assertions.assertThat((OptionalLong)((DeltaLakeColumnStatistics)columnStatistics.get("name")).getTotalSizeInBytes()).isEqualTo((Object)OptionalLong.of(34L));
        Assertions.assertThat((OptionalLong)((DeltaLakeColumnStatistics)columnStatistics.get("comment")).getTotalSizeInBytes()).isEqualTo((Object)OptionalLong.of(330L));
    }

    @Test
    public void testMergeExtendedStatisticsWithoutAndWithDataSize() {
        Optional<ExtendedStatistics> statisticsWithoutDataSize = this.readExtendedStatisticsFromTableResource("statistics/extended_stats_without_data_size");
        Optional<ExtendedStatistics> statisticsWithDataSize = this.readExtendedStatisticsFromTableResource("statistics/extended_stats_with_data_size");
        Assertions.assertThat(statisticsWithoutDataSize).isNotEmpty();
        Assertions.assertThat(statisticsWithDataSize).isNotEmpty();
        Map columnStatisticsWithoutDataSize = statisticsWithoutDataSize.get().getColumnStatistics();
        Map columnStatisticsWithDataSize = statisticsWithDataSize.get().getColumnStatistics();
        DeltaLakeColumnStatistics mergedRegionKey = ((DeltaLakeColumnStatistics)columnStatisticsWithoutDataSize.get("regionkey")).update((DeltaLakeColumnStatistics)columnStatisticsWithDataSize.get("regionkey"));
        Assertions.assertThat((OptionalLong)mergedRegionKey.getTotalSizeInBytes()).isEqualTo((Object)OptionalLong.empty());
        Assertions.assertThat((long)mergedRegionKey.getNdvSummary().cardinality()).isEqualTo(5L);
        DeltaLakeColumnStatistics mergedName = ((DeltaLakeColumnStatistics)columnStatisticsWithoutDataSize.get("name")).update((DeltaLakeColumnStatistics)columnStatisticsWithDataSize.get("name"));
        Assertions.assertThat((OptionalLong)mergedName.getTotalSizeInBytes()).isEqualTo((Object)OptionalLong.empty());
        Assertions.assertThat((long)mergedName.getNdvSummary().cardinality()).isEqualTo(5L);
        DeltaLakeColumnStatistics mergedComment = ((DeltaLakeColumnStatistics)columnStatisticsWithoutDataSize.get("comment")).update((DeltaLakeColumnStatistics)columnStatisticsWithDataSize.get("comment"));
        Assertions.assertThat((OptionalLong)mergedComment.getTotalSizeInBytes()).isEqualTo((Object)OptionalLong.empty());
        Assertions.assertThat((long)mergedComment.getNdvSummary().cardinality()).isEqualTo(5L);
    }

    private TableStatistics getTableStatistics(ConnectorSession session, DeltaLakeTableHandle tableHandle) {
        TableSnapshot tableSnapshot;
        try {
            tableSnapshot = this.transactionLogAccess.loadSnapshot(session, tableHandle.getSchemaTableName(), tableHandle.getLocation(), Optional.empty());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.tableStatisticsProvider.getTableStatistics(session, tableHandle, tableSnapshot);
    }

    private Optional<ExtendedStatistics> readExtendedStatisticsFromTableResource(String tableLocationResourceName) {
        SchemaTableName name = new SchemaTableName("some_ignored_schema", "some_ignored_name");
        String tableLocation = Resources.getResource((String)tableLocationResourceName).toExternalForm();
        return this.statistics.readExtendedStatistics(DeltaTestingConnectorSession.SESSION, name, tableLocation);
    }
}

