/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog;

import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeParquetStatisticsUtils;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDeltaLakeParquetStatisticsUtils {
    static final int JULIAN_EPOCH_OFFSET_DAYS = 2440588;

    @Test
    public void testIntegerStatistics() {
        String columnName = "t_integer";
        PrimitiveType intType = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT32, columnName);
        Statistics stats = Statistics.getBuilderForReading((PrimitiveType)intType).withMin(TestDeltaLakeParquetStatisticsUtils.getIntByteArray(-100)).withMax(TestDeltaLakeParquetStatisticsUtils.getIntByteArray(150)).withNumNulls(10L).build();
        Assertions.assertThat((Map)DeltaLakeParquetStatisticsUtils.jsonEncodeMin((Map)ImmutableMap.of((Object)columnName, Optional.of(stats)), (Map)ImmutableMap.of((Object)columnName, (Object)IntegerType.INTEGER))).isEqualTo((Object)ImmutableMap.of((Object)columnName, (Object)-100));
        Assertions.assertThat((Map)DeltaLakeParquetStatisticsUtils.jsonEncodeMax((Map)ImmutableMap.of((Object)columnName, Optional.of(stats)), (Map)ImmutableMap.of((Object)columnName, (Object)IntegerType.INTEGER))).isEqualTo((Object)ImmutableMap.of((Object)columnName, (Object)150));
    }

    @Test
    public void testStringStatistics() {
        String columnName = "t_string";
        PrimitiveType stringType = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, columnName);
        Statistics stats = Statistics.getBuilderForReading((PrimitiveType)stringType).withMin("abc".getBytes(StandardCharsets.UTF_8)).withMax("bac".getBytes(StandardCharsets.UTF_8)).withNumNulls(1L).build();
        Assertions.assertThat((Map)DeltaLakeParquetStatisticsUtils.jsonEncodeMin((Map)ImmutableMap.of((Object)columnName, Optional.of(stats)), (Map)ImmutableMap.of((Object)columnName, (Object)VarcharType.createUnboundedVarcharType()))).isEqualTo((Object)ImmutableMap.of((Object)columnName, (Object)"abc"));
        Assertions.assertThat((Map)DeltaLakeParquetStatisticsUtils.jsonEncodeMax((Map)ImmutableMap.of((Object)columnName, Optional.of(stats)), (Map)ImmutableMap.of((Object)columnName, (Object)VarcharType.createUnboundedVarcharType()))).isEqualTo((Object)ImmutableMap.of((Object)columnName, (Object)"bac"));
    }

    @Test
    public void testFloatStatistics() {
        String columnName = "t_float";
        PrimitiveType type = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.FLOAT, columnName);
        Statistics stats = Statistics.getBuilderForReading((PrimitiveType)type).withMin(TestDeltaLakeParquetStatisticsUtils.getFloatByteArray(100.0f)).withMax(TestDeltaLakeParquetStatisticsUtils.getFloatByteArray(1000.001f)).withNumNulls(2L).build();
        Assertions.assertThat((Map)DeltaLakeParquetStatisticsUtils.jsonEncodeMin((Map)ImmutableMap.of((Object)columnName, Optional.of(stats)), (Map)ImmutableMap.of((Object)columnName, (Object)RealType.REAL))).isEqualTo((Object)ImmutableMap.of((Object)columnName, (Object)Float.valueOf(100.0f)));
        Assertions.assertThat((Map)DeltaLakeParquetStatisticsUtils.jsonEncodeMax((Map)ImmutableMap.of((Object)columnName, Optional.of(stats)), (Map)ImmutableMap.of((Object)columnName, (Object)RealType.REAL))).isEqualTo((Object)ImmutableMap.of((Object)columnName, (Object)Float.valueOf(1000.001f)));
        columnName = "t_double";
        type = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.DOUBLE, columnName);
        stats = Statistics.getBuilderForReading((PrimitiveType)type).withMin(TestDeltaLakeParquetStatisticsUtils.getDoubleByteArray(100.0)).withMax(TestDeltaLakeParquetStatisticsUtils.getDoubleByteArray(1000.001)).withNumNulls(2L).build();
        Assertions.assertThat((Map)DeltaLakeParquetStatisticsUtils.jsonEncodeMin((Map)ImmutableMap.of((Object)columnName, Optional.of(stats)), (Map)ImmutableMap.of((Object)columnName, (Object)DoubleType.DOUBLE))).isEqualTo((Object)ImmutableMap.of((Object)columnName, (Object)100.0));
        Assertions.assertThat((Map)DeltaLakeParquetStatisticsUtils.jsonEncodeMax((Map)ImmutableMap.of((Object)columnName, Optional.of(stats)), (Map)ImmutableMap.of((Object)columnName, (Object)DoubleType.DOUBLE))).isEqualTo((Object)ImmutableMap.of((Object)columnName, (Object)1000.001));
    }

    @Test
    public void testDateStatistics() {
        String columnName = "t_date";
        PrimitiveType type = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT32, columnName);
        Statistics stats = Statistics.getBuilderForReading((PrimitiveType)type).withMin(TestDeltaLakeParquetStatisticsUtils.getIntByteArray((int)LocalDate.parse("2020-08-26").toEpochDay())).withMax(TestDeltaLakeParquetStatisticsUtils.getIntByteArray((int)LocalDate.parse("2020-09-17").toEpochDay())).withNumNulls(2L).build();
        Assertions.assertThat((Map)DeltaLakeParquetStatisticsUtils.jsonEncodeMin((Map)ImmutableMap.of((Object)columnName, Optional.of(stats)), (Map)ImmutableMap.of((Object)columnName, (Object)DateType.DATE))).isEqualTo((Object)ImmutableMap.of((Object)columnName, (Object)"2020-08-26"));
        Assertions.assertThat((Map)DeltaLakeParquetStatisticsUtils.jsonEncodeMax((Map)ImmutableMap.of((Object)columnName, Optional.of(stats)), (Map)ImmutableMap.of((Object)columnName, (Object)DateType.DATE))).isEqualTo((Object)ImmutableMap.of((Object)columnName, (Object)"2020-09-17"));
    }

    @Test
    public void testTimestampJsonValueToTrinoValue() {
        Assertions.assertThat((Object)DeltaLakeParquetStatisticsUtils.jsonValueToTrinoValue((Type)TimestampType.TIMESTAMP_MICROS, (Object)"2020-08-26T01:02:03.123Z")).isEqualTo((Object)(Instant.parse("2020-08-26T01:02:03.123Z").toEpochMilli() * 1000L));
        Assertions.assertThat((Object)DeltaLakeParquetStatisticsUtils.jsonValueToTrinoValue((Type)TimestampType.TIMESTAMP_MICROS, (Object)"2020-08-26T01:02:03.123111Z")).isEqualTo((Object)(Instant.parse("2020-08-26T01:02:03Z").getEpochSecond() * 1000000L + 123111L));
        Assertions.assertThat((Object)DeltaLakeParquetStatisticsUtils.jsonValueToTrinoValue((Type)TimestampType.TIMESTAMP_MICROS, (Object)"2020-08-26T01:02:03.123999Z")).isEqualTo((Object)(Instant.parse("2020-08-26T01:02:03Z").getEpochSecond() * 1000000L + 123999L));
    }

    @Test
    public void testTimestampStatisticsMillisPrecision() {
        String columnName = "t_timestamp";
        PrimitiveType type = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, columnName);
        Statistics stats = Statistics.getBuilderForReading((PrimitiveType)type).withMin(TestDeltaLakeParquetStatisticsUtils.timestampToBytes(LocalDateTime.parse("2020-08-26T01:02:03.123456"))).withMax(TestDeltaLakeParquetStatisticsUtils.timestampToBytes(LocalDateTime.parse("2020-08-26T01:02:03.987654"))).withNumNulls(2L).build();
        Assertions.assertThat((Map)DeltaLakeParquetStatisticsUtils.jsonEncodeMin((Map)ImmutableMap.of((Object)columnName, Optional.of(stats)), (Map)ImmutableMap.of((Object)columnName, (Object)TimestampType.TIMESTAMP_MICROS))).isEqualTo((Object)ImmutableMap.of((Object)columnName, (Object)"2020-08-26T01:02:03.123Z"));
        Assertions.assertThat((Map)DeltaLakeParquetStatisticsUtils.jsonEncodeMax((Map)ImmutableMap.of((Object)columnName, Optional.of(stats)), (Map)ImmutableMap.of((Object)columnName, (Object)TimestampType.TIMESTAMP_MICROS))).isEqualTo((Object)ImmutableMap.of((Object)columnName, (Object)"2020-08-26T01:02:03.988Z"));
    }

    private static byte[] timestampToBytes(LocalDateTime localDateTime) {
        long epochMicros = localDateTime.toEpochSecond(ZoneOffset.UTC) * 1000000L + (long)(localDateTime.getNano() / 1000);
        Slice slice = Slices.allocate((int)8);
        slice.setLong(0, epochMicros);
        return slice.byteArray();
    }

    @Test
    public void testTimestampStatisticsHighPrecision() {
        String columnName = "t_timestamp";
        PrimitiveType type = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT96, columnName);
        Statistics stats = Statistics.getBuilderForReading((PrimitiveType)type).withMin(TestDeltaLakeParquetStatisticsUtils.toParquetEncoding(LocalDateTime.parse("2020-08-26T01:02:03.123456789"))).withMax(TestDeltaLakeParquetStatisticsUtils.toParquetEncoding(LocalDateTime.parse("2020-08-26T01:02:03.123987654"))).withNumNulls(2L).build();
        Assertions.assertThat((Map)DeltaLakeParquetStatisticsUtils.jsonEncodeMin((Map)ImmutableMap.of((Object)columnName, Optional.of(stats)), (Map)ImmutableMap.of((Object)columnName, (Object)TimestampType.TIMESTAMP_MICROS))).isEqualTo((Object)ImmutableMap.of((Object)columnName, (Object)"2020-08-26T01:02:03.123Z"));
        Assertions.assertThat((Map)DeltaLakeParquetStatisticsUtils.jsonEncodeMax((Map)ImmutableMap.of((Object)columnName, Optional.of(stats)), (Map)ImmutableMap.of((Object)columnName, (Object)TimestampType.TIMESTAMP_MICROS))).isEqualTo((Object)ImmutableMap.of((Object)columnName, (Object)"2020-08-26T01:02:03.124Z"));
    }

    @Test
    public void testTimestampWithTimeZoneStatisticsHighPrecision() {
        String columnName = "t_timestamp";
        PrimitiveType type = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT96, columnName);
        Statistics stats = Statistics.getBuilderForReading((PrimitiveType)type).withMin(TestDeltaLakeParquetStatisticsUtils.toParquetEncoding(LocalDateTime.parse("2020-08-26T01:02:03.123456789"))).withMax(TestDeltaLakeParquetStatisticsUtils.toParquetEncoding(LocalDateTime.parse("2020-08-26T01:02:03.123987654"))).withNumNulls(2L).build();
        Assertions.assertThat((Map)DeltaLakeParquetStatisticsUtils.jsonEncodeMin((Map)ImmutableMap.of((Object)columnName, Optional.of(stats)), (Map)ImmutableMap.of((Object)columnName, (Object)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS))).isEqualTo((Object)ImmutableMap.of((Object)columnName, (Object)"2020-08-26T01:02:03.123Z"));
        Assertions.assertThat((Map)DeltaLakeParquetStatisticsUtils.jsonEncodeMax((Map)ImmutableMap.of((Object)columnName, Optional.of(stats)), (Map)ImmutableMap.of((Object)columnName, (Object)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS))).isEqualTo((Object)ImmutableMap.of((Object)columnName, (Object)"2020-08-26T01:02:03.124Z"));
    }

    @Test
    public void testTimestampWithTimeZoneStatisticsMillisPrecision() {
        String columnName = "t_timestamp";
        PrimitiveType type = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT96, columnName);
        Statistics stats = Statistics.getBuilderForReading((PrimitiveType)type).withMin(TestDeltaLakeParquetStatisticsUtils.toParquetEncoding(LocalDateTime.parse("2020-08-26T01:02:03.123"))).withMax(TestDeltaLakeParquetStatisticsUtils.toParquetEncoding(LocalDateTime.parse("2020-08-26T01:02:03.123"))).withNumNulls(2L).build();
        Assertions.assertThat((Map)DeltaLakeParquetStatisticsUtils.jsonEncodeMin((Map)ImmutableMap.of((Object)columnName, Optional.of(stats)), (Map)ImmutableMap.of((Object)columnName, (Object)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS))).isEqualTo((Object)ImmutableMap.of((Object)columnName, (Object)"2020-08-26T01:02:03.123Z"));
        Assertions.assertThat((Map)DeltaLakeParquetStatisticsUtils.jsonEncodeMax((Map)ImmutableMap.of((Object)columnName, Optional.of(stats)), (Map)ImmutableMap.of((Object)columnName, (Object)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS))).isEqualTo((Object)ImmutableMap.of((Object)columnName, (Object)"2020-08-26T01:02:03.123Z"));
    }

    private static byte[] toParquetEncoding(LocalDateTime time) {
        long timeOfDayNanos = (long)time.getNano() + (time.toEpochSecond(ZoneOffset.UTC) - time.toLocalDate().atStartOfDay().toEpochSecond(ZoneOffset.UTC)) * 1000000000L;
        Slice slice = Slices.allocate((int)12);
        slice.setLong(0, timeOfDayNanos);
        slice.setInt(8, TestDeltaLakeParquetStatisticsUtils.millisToJulianDay(time.toInstant(ZoneOffset.UTC).toEpochMilli()));
        return slice.byteArray();
    }

    private static int millisToJulianDay(long timestamp) {
        return Math.toIntExact(TimeUnit.MILLISECONDS.toDays(timestamp) + 2440588L);
    }

    static byte[] getIntByteArray(int i) {
        return ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(i).array();
    }

    static byte[] getFloatByteArray(float f) {
        return ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putFloat(f).array();
    }

    static byte[] getDoubleByteArray(double d) {
        return ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putDouble(d).array();
    }
}

