/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnMetadata;
import io.trino.plugin.deltalake.DeltaLakeColumnType;
import io.trino.plugin.deltalake.DeltaLakeTable;
import io.trino.plugin.deltalake.TestingComplexTypeManager;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeSchemaSupport;
import io.trino.plugin.deltalake.transactionlog.statistics.DeltaLakeFileStatistics;
import io.trino.plugin.deltalake.transactionlog.statistics.DeltaLakeJsonFileStatistics;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.type.IntervalDayTimeType;
import io.trino.type.IntervalYearMonthType;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDeltaLakeSchemaSupport {
    private static final TestingComplexTypeManager typeManager = new TestingComplexTypeManager();

    @Test
    public void testSinglePrimitiveFieldSchema() {
        this.testSinglePrimitiveFieldSchema("{\"type\":\"struct\",\"fields\":[{\"name\":\"a\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}}]}", ColumnMetadata.builder().setName("a").setType((Type)VarcharType.VARCHAR).setNullable(true).build());
        this.testSinglePrimitiveFieldSchema("{\"type\":\"struct\",\"fields\":[{\"name\":\"a\",\"type\":\"integer\",\"nullable\":true,\"metadata\":{}}]}", ColumnMetadata.builder().setName("a").setType((Type)IntegerType.INTEGER).setNullable(true).build());
        this.testSinglePrimitiveFieldSchema("{\"type\":\"struct\",\"fields\":[{\"name\":\"a\",\"type\":\"short\",\"nullable\":true,\"metadata\":{}}]}", ColumnMetadata.builder().setName("a").setType((Type)SmallintType.SMALLINT).setNullable(true).build());
        this.testSinglePrimitiveFieldSchema("{\"type\":\"struct\",\"fields\":[{\"name\":\"a\",\"type\":\"byte\",\"nullable\":true,\"metadata\":{}}]}", ColumnMetadata.builder().setName("a").setType((Type)TinyintType.TINYINT).setNullable(true).build());
        this.testSinglePrimitiveFieldSchema("{\"type\":\"struct\",\"fields\":[{\"name\":\"a\",\"type\":\"float\",\"nullable\":true,\"metadata\":{}}]}", ColumnMetadata.builder().setName("a").setType((Type)RealType.REAL).setNullable(true).build());
        this.testSinglePrimitiveFieldSchema("{\"type\":\"struct\",\"fields\":[{\"name\":\"a\",\"type\":\"double\",\"nullable\":true,\"metadata\":{}}]}", ColumnMetadata.builder().setName("a").setType((Type)DoubleType.DOUBLE).setNullable(true).build());
        this.testSinglePrimitiveFieldSchema("{\"type\":\"struct\",\"fields\":[{\"name\":\"a\",\"type\":\"boolean\",\"nullable\":true,\"metadata\":{}}]}", ColumnMetadata.builder().setName("a").setType((Type)BooleanType.BOOLEAN).setNullable(true).build());
        this.testSinglePrimitiveFieldSchema("{\"type\":\"struct\",\"fields\":[{\"name\":\"a\",\"type\":\"binary\",\"nullable\":true,\"metadata\":{}}]}", ColumnMetadata.builder().setName("a").setType((Type)VarbinaryType.VARBINARY).setNullable(true).build());
        this.testSinglePrimitiveFieldSchema("{\"type\":\"struct\",\"fields\":[{\"name\":\"a\",\"type\":\"date\",\"nullable\":true,\"metadata\":{}}]}", ColumnMetadata.builder().setName("a").setType((Type)DateType.DATE).setNullable(true).build());
        this.testSinglePrimitiveFieldSchema("{\"type\":\"struct\",\"fields\":[{\"name\":\"a\",\"type\":\"timestamp\",\"nullable\":true,\"metadata\":{}}]}", ColumnMetadata.builder().setName("a").setType((Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS).setNullable(true).build());
    }

    private void testSinglePrimitiveFieldSchema(String json, ColumnMetadata metadata) {
        List schema = (List)DeltaLakeSchemaSupport.getColumnMetadata((String)json, (TypeManager)typeManager, (DeltaLakeSchemaSupport.ColumnMappingMode)DeltaLakeSchemaSupport.ColumnMappingMode.NONE, List.of()).stream().map(DeltaLakeColumnMetadata::columnMetadata).collect(ImmutableList.toImmutableList());
        Assertions.assertThat((List)schema).hasSize(1);
        Assertions.assertThat((Object)((ColumnMetadata)schema.get(0))).isEqualTo((Object)metadata);
    }

    @Test
    public void testComplexSchema() throws IOException, URISyntaxException {
        URL expected = Resources.getResource((String)"io/trino/plugin/deltalake/transactionlog/schema/complex_schema.json");
        String json = Files.readString(Path.of(expected.toURI()));
        List schema = (List)DeltaLakeSchemaSupport.getColumnMetadata((String)json, (TypeManager)typeManager, (DeltaLakeSchemaSupport.ColumnMappingMode)DeltaLakeSchemaSupport.ColumnMappingMode.NONE, List.of()).stream().map(DeltaLakeColumnMetadata::columnMetadata).collect(ImmutableList.toImmutableList());
        Assertions.assertThat((List)schema).hasSize(5);
        Assertions.assertThat((String)((ColumnMetadata)schema.get(0)).toString()).isEqualTo("ColumnMetadata{name='a', type=integer, nullable}");
        Assertions.assertThat((String)((ColumnMetadata)schema.get(1)).toString()).isEqualTo("ColumnMetadata{name='b', type=row(b1 integer, b2 row(b21 varchar, b22 boolean)), nullable}");
        Assertions.assertThat((String)((ColumnMetadata)schema.get(2)).toString()).isEqualTo("ColumnMetadata{name='c', type=array(integer), nullable}");
        Assertions.assertThat((String)((ColumnMetadata)schema.get(3)).toString()).isEqualTo("ColumnMetadata{name='d', type=array(row(d1 integer)), nullable}");
        Assertions.assertThat((String)((ColumnMetadata)schema.get(4)).toString()).isEqualTo("ColumnMetadata{name='e', type=map(varchar, row(e1 date, e2 timestamp(3) with time zone)), nullable}");
    }

    @Test
    public void testSerializeStatisticsAsJson() throws JsonProcessingException {
        Assertions.assertThat((String)DeltaLakeSchemaSupport.serializeStatsAsJson((DeltaLakeFileStatistics)new DeltaLakeJsonFileStatistics(Optional.of(100L), Optional.of(ImmutableMap.of((Object)"c", (Object)42)), Optional.of(ImmutableMap.of((Object)"c", (Object)51)), Optional.of(ImmutableMap.of((Object)"c", (Object)1L))))).isEqualTo("{\"numRecords\":100,\"minValues\":{\"c\":42},\"maxValues\":{\"c\":51},\"nullCount\":{\"c\":1}}");
    }

    @Test
    public void testSerializeStatisticsWithNullValuesAsJson() throws JsonProcessingException {
        HashMap<String, Integer> minValues = new HashMap<String, Integer>();
        HashMap<String, Integer> maxValues = new HashMap<String, Integer>();
        minValues.put("c1", null);
        maxValues.put("c1", null);
        minValues.put("c2", 10);
        maxValues.put("c2", 26);
        Assertions.assertThat((String)DeltaLakeSchemaSupport.serializeStatsAsJson((DeltaLakeFileStatistics)new DeltaLakeJsonFileStatistics(Optional.of(1L), Optional.of(minValues), Optional.of(maxValues), Optional.of(ImmutableMap.of((Object)"c1", (Object)1L, (Object)"c2", (Object)0L))))).isEqualTo("{\"numRecords\":1,\"minValues\":{\"c2\":10},\"maxValues\":{\"c2\":26},\"nullCount\":{\"c1\":1,\"c2\":0}}");
    }

    @Test
    public void testSerializeSchemaAsJson() throws Exception {
        DeltaLakeColumnHandle arrayColumn = new DeltaLakeColumnHandle("arr", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)), OptionalInt.empty(), "arr", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)), DeltaLakeColumnType.REGULAR, Optional.empty());
        DeltaLakeColumnHandle structColumn = new DeltaLakeColumnHandle("str", (Type)RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("s1"), (Type)VarcharType.createUnboundedVarcharType()), (Object)new RowType.Field(Optional.of("s2"), (Type)RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("i1"), (Type)IntegerType.INTEGER), (Object)new RowType.Field(Optional.of("d2"), (Type)DecimalType.createDecimalType((int)38, (int)0))))))), OptionalInt.empty(), "str", (Type)RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("s1"), (Type)VarcharType.createUnboundedVarcharType()), (Object)new RowType.Field(Optional.of("s2"), (Type)RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("i1"), (Type)IntegerType.INTEGER), (Object)new RowType.Field(Optional.of("d2"), (Type)DecimalType.createDecimalType((int)38, (int)0))))))), DeltaLakeColumnType.REGULAR, Optional.empty());
        TypeOperators typeOperators = new TypeOperators();
        DeltaLakeColumnHandle mapColumn = new DeltaLakeColumnHandle("m", (Type)new MapType((Type)IntegerType.INTEGER, (Type)new MapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER, typeOperators), typeOperators), OptionalInt.empty(), "m", (Type)new MapType((Type)IntegerType.INTEGER, (Type)new MapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER, typeOperators), typeOperators), DeltaLakeColumnType.REGULAR, Optional.empty());
        URL expected = Resources.getResource((String)"io/trino/plugin/deltalake/transactionlog/schema/nested_schema.json");
        ObjectMapper objectMapper = new ObjectMapper();
        ImmutableList columnHandles = ImmutableList.of((Object)arrayColumn, (Object)structColumn, (Object)mapColumn);
        DeltaLakeTable.Builder deltaTable = DeltaLakeTable.builder();
        for (DeltaLakeColumnHandle column : columnHandles) {
            deltaTable.addColumn(column.columnName(), DeltaLakeSchemaSupport.serializeColumnType((DeltaLakeSchemaSupport.ColumnMappingMode)DeltaLakeSchemaSupport.ColumnMappingMode.NONE, (AtomicInteger)new AtomicInteger(), (Type)column.baseType()), true, null, (Map)ImmutableMap.of());
        }
        String jsonEncoding = DeltaLakeSchemaSupport.serializeSchemaAsJson((DeltaLakeTable)deltaTable.build());
        Assertions.assertThat((Iterable)objectMapper.readTree(jsonEncoding)).isEqualTo((Object)objectMapper.readTree(expected));
    }

    @Test
    public void testRoundTripComplexSchema() throws IOException, URISyntaxException {
        URL expected = Resources.getResource((String)"io/trino/plugin/deltalake/transactionlog/schema/complex_schema.json");
        String json = Files.readString(Path.of(expected.toURI()));
        List schema = (List)DeltaLakeSchemaSupport.getColumnMetadata((String)json, (TypeManager)typeManager, (DeltaLakeSchemaSupport.ColumnMappingMode)DeltaLakeSchemaSupport.ColumnMappingMode.NONE, List.of()).stream().map(DeltaLakeColumnMetadata::columnMetadata).collect(ImmutableList.toImmutableList());
        DeltaLakeTable.Builder deltaTable = DeltaLakeTable.builder();
        for (ColumnMetadata column : schema) {
            deltaTable.addColumn(column.getName(), DeltaLakeSchemaSupport.serializeColumnType((DeltaLakeSchemaSupport.ColumnMappingMode)DeltaLakeSchemaSupport.ColumnMappingMode.NONE, (AtomicInteger)new AtomicInteger(), (Type)column.getType()), true, null, (Map)ImmutableMap.of());
        }
        ObjectMapper objectMapper = new ObjectMapper();
        String jsonEncoding = DeltaLakeSchemaSupport.serializeSchemaAsJson((DeltaLakeTable)deltaTable.build());
        Assertions.assertThat((Iterable)objectMapper.readTree(jsonEncoding)).isEqualTo((Object)objectMapper.readTree(expected));
    }

    @Test
    public void testValidPrimitiveTypes() {
        Assertions.assertThatCode(() -> DeltaLakeSchemaSupport.validateType((Type)BigintType.BIGINT)).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> DeltaLakeSchemaSupport.validateType((Type)IntegerType.INTEGER)).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> DeltaLakeSchemaSupport.validateType((Type)SmallintType.SMALLINT)).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> DeltaLakeSchemaSupport.validateType((Type)TinyintType.TINYINT)).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> DeltaLakeSchemaSupport.validateType((Type)RealType.REAL)).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> DeltaLakeSchemaSupport.validateType((Type)DoubleType.DOUBLE)).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> DeltaLakeSchemaSupport.validateType((Type)BooleanType.BOOLEAN)).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> DeltaLakeSchemaSupport.validateType((Type)VarbinaryType.VARBINARY)).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> DeltaLakeSchemaSupport.validateType((Type)DateType.DATE)).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> DeltaLakeSchemaSupport.validateType((Type)VarcharType.VARCHAR)).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> DeltaLakeSchemaSupport.validateType((Type)DecimalType.createDecimalType((int)3))).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> DeltaLakeSchemaSupport.validateType((Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS)).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> DeltaLakeSchemaSupport.validateType((Type)new MapType((Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, new TypeOperators()))).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> DeltaLakeSchemaSupport.validateType((Type)RowType.anonymous((List)ImmutableList.of((Object)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS)))).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> DeltaLakeSchemaSupport.validateType((Type)new ArrayType((Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS))).doesNotThrowAnyException();
    }

    @Test
    public void testValidateTypeFailsOnUnsupportedPrimitiveType() {
        Assertions.assertThatCode(() -> DeltaLakeSchemaSupport.validateType((Type)CharType.createCharType((int)3))).hasMessage("Unsupported type: " + String.valueOf(CharType.createCharType((int)3)));
        Assertions.assertThatCode(() -> DeltaLakeSchemaSupport.validateType((Type)TimestampType.TIMESTAMP_MILLIS)).hasMessage("Unsupported type: " + String.valueOf(TimestampType.TIMESTAMP_MILLIS));
        Assertions.assertThatCode(() -> DeltaLakeSchemaSupport.validateType((Type)TimestampType.TIMESTAMP_SECONDS)).hasMessage("Unsupported type: " + String.valueOf(TimestampType.TIMESTAMP_SECONDS));
        Assertions.assertThatCode(() -> DeltaLakeSchemaSupport.validateType((Type)IntervalDayTimeType.INTERVAL_DAY_TIME)).hasMessage("Unsupported type: " + String.valueOf(IntervalDayTimeType.INTERVAL_DAY_TIME));
        Assertions.assertThatCode(() -> DeltaLakeSchemaSupport.validateType((Type)IntervalYearMonthType.INTERVAL_YEAR_MONTH)).hasMessage("Unsupported type: " + String.valueOf(IntervalYearMonthType.INTERVAL_YEAR_MONTH));
    }

    @Test
    public void testTimestampNestedInStructTypeIsNotSupported() {
        Assertions.assertThatCode(() -> DeltaLakeSchemaSupport.validateType((Type)new MapType((Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_SECONDS, (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_SECONDS, new TypeOperators()))).hasMessage("Unsupported type: timestamp(0) with time zone");
        Assertions.assertThatCode(() -> DeltaLakeSchemaSupport.validateType((Type)RowType.anonymous((List)ImmutableList.of((Object)TimestampWithTimeZoneType.TIMESTAMP_TZ_SECONDS)))).hasMessage("Unsupported type: timestamp(0) with time zone");
        Assertions.assertThatCode(() -> DeltaLakeSchemaSupport.validateType((Type)new ArrayType((Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_SECONDS))).hasMessage("Unsupported type: timestamp(0) with time zone");
    }
}

