/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog;

import com.google.common.collect.ImmutableSet;
import io.airlift.json.JsonCodec;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestProtocolEntry {
    private final JsonCodec<ProtocolEntry> codec = JsonCodec.jsonCodec(ProtocolEntry.class);

    @Test
    public void testProtocolEntryFromJson() {
        String json = "{\"minReaderVersion\":2,\"minWriterVersion\":5}";
        Assertions.assertThat((Object)((ProtocolEntry)this.codec.fromJson(json))).isEqualTo((Object)new ProtocolEntry(2, 5, Optional.empty(), Optional.empty()));
        String jsonWithFeatures = "{\"minReaderVersion\":3,\"minWriterVersion\":7,\"readerFeatures\":[\"deletionVectors\"],\"writerFeatures\":[\"timestampNTZ\"]}";
        Assertions.assertThat((Object)((ProtocolEntry)this.codec.fromJson(jsonWithFeatures))).isEqualTo((Object)new ProtocolEntry(3, 7, Optional.of(ImmutableSet.of((Object)"deletionVectors")), Optional.of(ImmutableSet.of((Object)"timestampNTZ"))));
    }

    @Test
    public void testInvalidProtocolEntryFromJson() {
        String invalidMinReaderVersion = "{\"minReaderVersion\":2,\"minWriterVersion\":7,\"readerFeatures\":[\"deletionVectors\"]}";
        Assertions.assertThatThrownBy(() -> this.codec.fromJson(invalidMinReaderVersion)).hasMessageContaining("Invalid JSON string").hasStackTraceContaining("readerFeatures must not exist when minReaderVersion is less than 3");
        String invalidMinWriterVersion = "{\"minReaderVersion\":3,\"minWriterVersion\":6,\"writerFeatures\":[\"timestampNTZ\"]}";
        Assertions.assertThatThrownBy(() -> this.codec.fromJson(invalidMinWriterVersion)).hasMessageContaining("Invalid JSON string").hasStackTraceContaining("writerFeatures must not exist when minWriterVersion is less than 7");
    }

    @Test
    public void testProtocolEntryToJson() {
        Assertions.assertThat((String)this.codec.toJson((Object)new ProtocolEntry(2, 5, Optional.empty(), Optional.empty()))).isEqualTo("{\n  \"minReaderVersion\" : 2,\n  \"minWriterVersion\" : 5\n}");
        Assertions.assertThat((String)this.codec.toJson((Object)new ProtocolEntry(3, 7, Optional.of(ImmutableSet.of((Object)"deletionVectors")), Optional.of(ImmutableSet.of((Object)"timestampNTZ"))))).isEqualTo("{\n  \"minReaderVersion\" : 3,\n  \"minWriterVersion\" : 7,\n  \"readerFeatures\" : [ \"deletionVectors\" ],\n  \"writerFeatures\" : [ \"timestampNTZ\" ]\n}");
    }
}

