/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog;

import com.google.common.base.Predicates;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.units.DataSize;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.hdfs.HdfsFileSystemFactory;
import io.trino.filesystem.tracing.FileSystemAttributes;
import io.trino.filesystem.tracing.TracingFileSystemFactory;
import io.trino.parquet.ParquetReaderOptions;
import io.trino.plugin.base.metrics.FileFormatDataSourceStats;
import io.trino.plugin.deltalake.DeltaLakeConfig;
import io.trino.plugin.deltalake.transactionlog.AddFileEntry;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeTransactionLogEntry;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import io.trino.plugin.deltalake.transactionlog.TableSnapshot;
import io.trino.plugin.deltalake.transactionlog.TransactionLogAccess;
import io.trino.plugin.deltalake.transactionlog.TransactionLogParser;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointEntryIterator;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointSchemaManager;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.TypeManager;
import io.trino.testing.MultisetAssertions;
import io.trino.testing.TestingConnectorContext;
import io.trino.testing.TestingConnectorSession;
import io.trino.testing.TestingTelemetry;
import io.trino.type.InternalTypeManager;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestTableSnapshot {
    private final ParquetReaderOptions parquetReaderOptions = ParquetReaderOptions.defaultOptions();
    private final int domainCompactionThreshold = 32;
    private CheckpointSchemaManager checkpointSchemaManager;
    private TracingFileSystemFactory tracingFileSystemFactory;
    private TestingTelemetry testingTelemetry = TestingTelemetry.create((String)"test-table-snapshot");
    private TrinoFileSystem trackingFileSystem;
    private String tableLocation;

    @BeforeEach
    public void setUp() throws URISyntaxException {
        this.checkpointSchemaManager = new CheckpointSchemaManager(InternalTypeManager.TESTING_TYPE_MANAGER);
        this.tableLocation = this.getClass().getClassLoader().getResource("databricks73/person").toURI().toString();
        this.tracingFileSystemFactory = new TracingFileSystemFactory(this.testingTelemetry.getTracer(), (TrinoFileSystemFactory)new HdfsFileSystemFactory(HiveTestUtils.HDFS_ENVIRONMENT, HiveTestUtils.HDFS_FILE_SYSTEM_STATS));
        this.trackingFileSystem = this.tracingFileSystemFactory.create(TestingConnectorSession.SESSION);
    }

    @Test
    public void testOnlyReadsTrailingJsonFiles() throws Exception {
        AtomicReference tableSnapshot = new AtomicReference();
        this.assertFileSystemAccesses(() -> {
            Optional lastCheckpoint = TransactionLogParser.readLastCheckpoint((TrinoFileSystem)this.trackingFileSystem, (String)this.tableLocation);
            tableSnapshot.set(TableSnapshot.load((SchemaTableName)new SchemaTableName("schema", "person"), (Optional)lastCheckpoint, (TrinoFileSystem)this.trackingFileSystem, (String)this.tableLocation, (ParquetReaderOptions)this.parquetReaderOptions, (boolean)true, (int)32, (DataSize)DeltaLakeConfig.DEFAULT_TRANSACTION_LOG_MAX_CACHED_SIZE, Optional.empty()));
        }, (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation("_last_checkpoint", "InputFile.newStream")).add((Object)new FileOperation("00000000000000000011.json", "InputFile.newStream")).add((Object)new FileOperation("00000000000000000012.json", "InputFile.newStream")).add((Object)new FileOperation("00000000000000000013.json", "InputFile.newStream")).add((Object)new FileOperation("00000000000000000011.json", "InputFile.length")).add((Object)new FileOperation("00000000000000000012.json", "InputFile.length")).add((Object)new FileOperation("00000000000000000013.json", "InputFile.length")).add((Object)new FileOperation("00000000000000000014.json", "InputFile.length")).build());
        this.assertFileSystemAccesses(() -> ((TableSnapshot)tableSnapshot.get()).getJsonTransactionLogEntries(this.trackingFileSystem).forEach(entry -> {}), (Multiset<FileOperation>)ImmutableMultiset.of());
    }

    @Test
    public void readsCheckpointFile() throws IOException {
        List entries;
        ListeningExecutorService executorService = MoreExecutors.newDirectExecutorService();
        Optional lastCheckpoint = TransactionLogParser.readLastCheckpoint((TrinoFileSystem)this.trackingFileSystem, (String)this.tableLocation);
        TableSnapshot tableSnapshot = TableSnapshot.load((SchemaTableName)new SchemaTableName("schema", "person"), (Optional)lastCheckpoint, (TrinoFileSystem)this.trackingFileSystem, (String)this.tableLocation, (ParquetReaderOptions)this.parquetReaderOptions, (boolean)true, (int)32, (DataSize)DeltaLakeConfig.DEFAULT_TRANSACTION_LOG_MAX_CACHED_SIZE, Optional.empty());
        TestingConnectorContext context = new TestingConnectorContext();
        TypeManager typeManager = context.getTypeManager();
        TransactionLogAccess transactionLogAccess = new TransactionLogAccess(typeManager, new CheckpointSchemaManager(typeManager), new DeltaLakeConfig(), new FileFormatDataSourceStats(), (TrinoFileSystemFactory)this.tracingFileSystemFactory, new ParquetReaderConfig(), (ExecutorService)executorService);
        MetadataEntry metadataEntry = transactionLogAccess.getMetadataEntry(TestingConnectorSession.SESSION, tableSnapshot);
        ProtocolEntry protocolEntry = transactionLogAccess.getProtocolEntry(TestingConnectorSession.SESSION, tableSnapshot);
        tableSnapshot.setCachedMetadata(Optional.of(metadataEntry));
        try (Stream stream = tableSnapshot.getCheckpointTransactionLogEntries(TestingConnectorSession.SESSION, (Set)ImmutableSet.of((Object)CheckpointEntryIterator.EntryType.ADD), this.checkpointSchemaManager, InternalTypeManager.TESTING_TYPE_MANAGER, this.trackingFileSystem, new FileFormatDataSourceStats(), Optional.of(new TableSnapshot.MetadataAndProtocolEntry(metadataEntry, protocolEntry)), TupleDomain.all(), Optional.of(Predicates.alwaysTrue()), (Executor)executorService);){
            entries = (List)stream.collect(ImmutableList.toImmutableList());
            Assertions.assertThat((List)entries).hasSize(9);
            ((ObjectAssert)Assertions.assertThat((List)entries).element(3)).extracting(DeltaLakeTransactionLogEntry::getAdd).isEqualTo((Object)new AddFileEntry("age=42/part-00003-0f53cae3-3e34-4876-b651-e1db9584dbc3.c000.snappy.parquet", Map.of("age", "42"), 2634L, 1579190165000L, false, Optional.of("{\"numRecords\":1,\"minValues\":{\"name\":\"Alice\",\"address\":{\"street\":\"100 Main St\",\"city\":\"Anytown\",\"state\":\"NY\",\"zip\":\"12345\"},\"income\":111000.0},\"maxValues\":{\"name\":\"Alice\",\"address\":{\"street\":\"100 Main St\",\"city\":\"Anytown\",\"state\":\"NY\",\"zip\":\"12345\"},\"income\":111000.0},\"nullCount\":{\"name\":0,\"married\":0,\"phones\":0,\"address\":{\"street\":0,\"city\":0,\"state\":0,\"zip\":0},\"income\":0}}"), Optional.empty(), null, Optional.empty()));
            ((ObjectAssert)Assertions.assertThat((List)entries).element(7)).extracting(DeltaLakeTransactionLogEntry::getAdd).isEqualTo((Object)new AddFileEntry("age=30/part-00002-5800be2e-2373-47d8-8b86-776a8ea9d69f.c000.snappy.parquet", Map.of("age", "30"), 2688L, 1579190165000L, false, Optional.of("{\"numRecords\":1,\"minValues\":{\"name\":\"Andy\",\"address\":{\"street\":\"101 Main St\",\"city\":\"Anytown\",\"state\":\"NY\",\"zip\":\"12345\"},\"income\":81000.0},\"maxValues\":{\"name\":\"Andy\",\"address\":{\"street\":\"101 Main St\",\"city\":\"Anytown\",\"state\":\"NY\",\"zip\":\"12345\"},\"income\":81000.0},\"nullCount\":{\"name\":0,\"married\":0,\"phones\":0,\"address\":{\"street\":0,\"city\":0,\"state\":0,\"zip\":0},\"income\":0}}"), Optional.empty(), null, Optional.empty()));
        }
        stream = tableSnapshot.getCheckpointTransactionLogEntries(TestingConnectorSession.SESSION, (Set)ImmutableSet.of((Object)CheckpointEntryIterator.EntryType.ADD, (Object)CheckpointEntryIterator.EntryType.PROTOCOL), this.checkpointSchemaManager, InternalTypeManager.TESTING_TYPE_MANAGER, this.trackingFileSystem, new FileFormatDataSourceStats(), Optional.of(new TableSnapshot.MetadataAndProtocolEntry(metadataEntry, protocolEntry)), TupleDomain.all(), Optional.of(Predicates.alwaysTrue()), (Executor)executorService);
        try {
            entries = (List)stream.collect(ImmutableList.toImmutableList());
            Assertions.assertThat((List)entries).hasSize(10);
            ((ObjectAssert)Assertions.assertThat((List)entries).element(3)).extracting(DeltaLakeTransactionLogEntry::getAdd).isEqualTo((Object)new AddFileEntry("age=42/part-00003-0f53cae3-3e34-4876-b651-e1db9584dbc3.c000.snappy.parquet", Map.of("age", "42"), 2634L, 1579190165000L, false, Optional.of("{\"numRecords\":1,\"minValues\":{\"name\":\"Alice\",\"address\":{\"street\":\"100 Main St\",\"city\":\"Anytown\",\"state\":\"NY\",\"zip\":\"12345\"},\"income\":111000.0},\"maxValues\":{\"name\":\"Alice\",\"address\":{\"street\":\"100 Main St\",\"city\":\"Anytown\",\"state\":\"NY\",\"zip\":\"12345\"},\"income\":111000.0},\"nullCount\":{\"name\":0,\"married\":0,\"phones\":0,\"address\":{\"street\":0,\"city\":0,\"state\":0,\"zip\":0},\"income\":0}}"), Optional.empty(), null, Optional.empty()));
            ((ObjectAssert)Assertions.assertThat((List)entries).element(6)).extracting(DeltaLakeTransactionLogEntry::getProtocol).isEqualTo((Object)new ProtocolEntry(1, 2, Optional.empty(), Optional.empty()));
            ((ObjectAssert)Assertions.assertThat((List)entries).element(8)).extracting(DeltaLakeTransactionLogEntry::getAdd).isEqualTo((Object)new AddFileEntry("age=30/part-00002-5800be2e-2373-47d8-8b86-776a8ea9d69f.c000.snappy.parquet", Map.of("age", "30"), 2688L, 1579190165000L, false, Optional.of("{\"numRecords\":1,\"minValues\":{\"name\":\"Andy\",\"address\":{\"street\":\"101 Main St\",\"city\":\"Anytown\",\"state\":\"NY\",\"zip\":\"12345\"},\"income\":81000.0},\"maxValues\":{\"name\":\"Andy\",\"address\":{\"street\":\"101 Main St\",\"city\":\"Anytown\",\"state\":\"NY\",\"zip\":\"12345\"},\"income\":81000.0},\"nullCount\":{\"name\":0,\"married\":0,\"phones\":0,\"address\":{\"street\":0,\"city\":0,\"state\":0,\"zip\":0},\"income\":0}}"), Optional.empty(), null, Optional.empty()));
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    @Test
    public void testMaxTransactionId() throws IOException {
        Optional lastCheckpoint = TransactionLogParser.readLastCheckpoint((TrinoFileSystem)this.trackingFileSystem, (String)this.tableLocation);
        TableSnapshot tableSnapshot = TableSnapshot.load((SchemaTableName)new SchemaTableName("schema", "person"), (Optional)lastCheckpoint, (TrinoFileSystem)this.trackingFileSystem, (String)this.tableLocation, (ParquetReaderOptions)this.parquetReaderOptions, (boolean)true, (int)32, (DataSize)DeltaLakeConfig.DEFAULT_TRANSACTION_LOG_MAX_CACHED_SIZE, Optional.empty());
        Assertions.assertThat((long)tableSnapshot.getVersion()).isEqualTo(13L);
    }

    private void assertFileSystemAccesses(TestingTelemetry.CheckedRunnable<?> callback, Multiset<FileOperation> expectedAccesses) throws Exception {
        MultisetAssertions.assertMultisetsEqual(this.getOperations(this.testingTelemetry.captureSpans(() -> callback.run())), expectedAccesses);
    }

    private Multiset<FileOperation> getOperations(List<SpanData> spans) {
        return (Multiset)spans.stream().filter(span -> span.getName().startsWith("InputFile.")).map(span -> new FileOperation(((String)span.getAttributes().get(FileSystemAttributes.FILE_LOCATION)).replaceFirst(".*/_delta_log/", ""), span.getName())).collect(Collectors.toCollection(HashMultiset::create));
    }

    private record FileOperation(String path, String operationType) {
        FileOperation {
            Objects.requireNonNull(path, "path is null");
            Objects.requireNonNull(operationType, "operationType is null");
        }
    }
}

