/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog;

import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.hdfs.HdfsFileSystemFactory;
import io.trino.plugin.deltalake.DeltaTestingConnectorSession;
import io.trino.plugin.deltalake.transactionlog.TransactionLogParser;
import io.trino.plugin.hive.HiveTestUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTransactionLogParser {
    @Test
    public void testGetCurrentVersion() throws Exception {
        TrinoFileSystem fileSystem = new HdfsFileSystemFactory(HiveTestUtils.HDFS_ENVIRONMENT, HiveTestUtils.HDFS_FILE_SYSTEM_STATS).create(DeltaTestingConnectorSession.SESSION);
        String basePath = this.getClass().getClassLoader().getResource("databricks73").toURI().toString();
        Assertions.assertThat((long)TransactionLogParser.getMandatoryCurrentVersion((TrinoFileSystem)fileSystem, (String)(basePath + "/simple_table_without_checkpoint"), (long)8L)).isEqualTo(9L);
        Assertions.assertThat((long)TransactionLogParser.getMandatoryCurrentVersion((TrinoFileSystem)fileSystem, (String)(basePath + "/simple_table_without_checkpoint"), (long)9L)).isEqualTo(9L);
        Assertions.assertThat((long)TransactionLogParser.getMandatoryCurrentVersion((TrinoFileSystem)fileSystem, (String)(basePath + "/simple_table_ending_on_checkpoint"), (long)10L)).isEqualTo(10L);
        Assertions.assertThat((long)TransactionLogParser.getMandatoryCurrentVersion((TrinoFileSystem)fileSystem, (String)(basePath + "/simple_table_past_checkpoint"), (long)10L)).isEqualTo(11L);
        Assertions.assertThat((long)TransactionLogParser.getMandatoryCurrentVersion((TrinoFileSystem)fileSystem, (String)(basePath + "/simple_table_past_checkpoint"), (long)11L)).isEqualTo(11L);
    }

    @Test
    void testReadPartitionTimestampWithZone() {
        Assertions.assertThat((Long)TransactionLogParser.readPartitionTimestampWithZone((String)"1970-01-01 00:00:00")).isEqualTo(0L);
        Assertions.assertThat((Long)TransactionLogParser.readPartitionTimestampWithZone((String)"1970-01-01 00:00:00.1")).isEqualTo(409600L);
        Assertions.assertThat((Long)TransactionLogParser.readPartitionTimestampWithZone((String)"1970-01-01 00:00:00.01")).isEqualTo(40960L);
        Assertions.assertThat((Long)TransactionLogParser.readPartitionTimestampWithZone((String)"1970-01-01 00:00:00.001")).isEqualTo(4096L);
        Assertions.assertThat((Long)TransactionLogParser.readPartitionTimestampWithZone((String)"1970-01-01 00:00:00.0001")).isEqualTo(0L);
        Assertions.assertThat((Long)TransactionLogParser.readPartitionTimestampWithZone((String)"1970-01-01 00:00:00.00001")).isEqualTo(0L);
        Assertions.assertThat((Long)TransactionLogParser.readPartitionTimestampWithZone((String)"1970-01-01 00:00:00.000001")).isEqualTo(0L);
    }

    @Test
    void testReadPartitionTimestampWithZoneIso8601() {
        Assertions.assertThat((Long)TransactionLogParser.readPartitionTimestampWithZone((String)"1970-01-01T00:00:00.000000Z")).isEqualTo(0L);
        Assertions.assertThat((Long)TransactionLogParser.readPartitionTimestampWithZone((String)"1970-01-01T01:00:00.000000+01:00")).isEqualTo(0L);
    }
}

