/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog.checkpoint;

import io.trino.plugin.deltalake.transactionlog.AddFileEntry;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeTransactionLogEntry;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import io.trino.plugin.deltalake.transactionlog.RemoveFileEntry;
import io.trino.plugin.deltalake.transactionlog.TransactionEntry;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointBuilder;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointEntries;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestCheckpointBuilder {
    @Test
    public void testCheckpointBuilder() {
        CheckpointBuilder builder = new CheckpointBuilder();
        MetadataEntry metadata1 = new MetadataEntry("1", "", "", new MetadataEntry.Format("", Map.of()), "", List.of(), Map.of(), 1L);
        MetadataEntry metadata2 = new MetadataEntry("2", "", "", new MetadataEntry.Format("", Map.of()), "", List.of(), Map.of(), 1L);
        builder.addLogEntry(DeltaLakeTransactionLogEntry.metadataEntry((MetadataEntry)metadata1));
        builder.addLogEntry(DeltaLakeTransactionLogEntry.metadataEntry((MetadataEntry)metadata2));
        ProtocolEntry protocol1 = new ProtocolEntry(1, 2, Optional.empty(), Optional.empty());
        ProtocolEntry protocol2 = new ProtocolEntry(3, 4, Optional.empty(), Optional.empty());
        builder.addLogEntry(DeltaLakeTransactionLogEntry.protocolEntry((ProtocolEntry)protocol1));
        builder.addLogEntry(DeltaLakeTransactionLogEntry.protocolEntry((ProtocolEntry)protocol2));
        TransactionEntry app1TransactionV1 = new TransactionEntry("app1", 1L, 1L);
        TransactionEntry app1TransactionV2 = new TransactionEntry("app1", 2L, 2L);
        TransactionEntry app1TransactionV3 = new TransactionEntry("app1", 3L, 3L);
        TransactionEntry app2TransactionV5 = new TransactionEntry("app2", 5L, 5L);
        builder.addLogEntry(DeltaLakeTransactionLogEntry.transactionEntry((TransactionEntry)app1TransactionV2));
        builder.addLogEntry(DeltaLakeTransactionLogEntry.transactionEntry((TransactionEntry)app1TransactionV3));
        builder.addLogEntry(DeltaLakeTransactionLogEntry.transactionEntry((TransactionEntry)app1TransactionV1));
        builder.addLogEntry(DeltaLakeTransactionLogEntry.transactionEntry((TransactionEntry)app2TransactionV5));
        AddFileEntry addA1 = new AddFileEntry("a", Map.of(), 1L, 1L, true, Optional.empty(), Optional.empty(), Map.of(), Optional.empty());
        RemoveFileEntry removeA1 = new RemoveFileEntry("a", Map.of(), 1L, true, Optional.empty());
        AddFileEntry addA2 = new AddFileEntry("a", Map.of(), 2L, 1L, true, Optional.empty(), Optional.empty(), Map.of(), Optional.empty());
        AddFileEntry addB = new AddFileEntry("b", Map.of(), 1L, 1L, true, Optional.empty(), Optional.empty(), Map.of(), Optional.empty());
        RemoveFileEntry removeB = new RemoveFileEntry("b", Map.of(), 1L, true, Optional.empty());
        RemoveFileEntry removeC = new RemoveFileEntry("c", Map.of(), 1L, true, Optional.empty());
        builder.addLogEntry(DeltaLakeTransactionLogEntry.addFileEntry((AddFileEntry)addA1));
        builder.addLogEntry(DeltaLakeTransactionLogEntry.removeFileEntry((RemoveFileEntry)removeA1));
        builder.addLogEntry(DeltaLakeTransactionLogEntry.addFileEntry((AddFileEntry)addA2));
        builder.addLogEntry(DeltaLakeTransactionLogEntry.addFileEntry((AddFileEntry)addB));
        builder.addLogEntry(DeltaLakeTransactionLogEntry.removeFileEntry((RemoveFileEntry)removeB));
        builder.addLogEntry(DeltaLakeTransactionLogEntry.removeFileEntry((RemoveFileEntry)removeC));
        CheckpointEntries expectedCheckpoint = new CheckpointEntries(metadata2, protocol2, Set.of(app1TransactionV3, app2TransactionV5), Set.of(addA2), Set.of(removeB, removeC));
        Assertions.assertThat((Object)expectedCheckpoint).isEqualTo((Object)builder.build());
    }
}

