/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog.checkpoint;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.io.Resources;
import com.google.common.math.LongMath;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoOutputFile;
import io.trino.filesystem.hdfs.HdfsFileSystemFactory;
import io.trino.parquet.ParquetReaderOptions;
import io.trino.parquet.writer.ParquetWriterOptions;
import io.trino.plugin.base.metrics.FileFormatDataSourceStats;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnType;
import io.trino.plugin.deltalake.DeltaLakeConfig;
import io.trino.plugin.deltalake.DeltaTestingConnectorSession;
import io.trino.plugin.deltalake.transactionlog.AddFileEntry;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeTransactionLogEntry;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import io.trino.plugin.deltalake.transactionlog.RemoveFileEntry;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointEntries;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointEntryIterator;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointSchemaManager;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointWriter;
import io.trino.plugin.deltalake.transactionlog.statistics.DeltaLakeParquetFileStatistics;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.type.InternalTypeManager;
import java.io.File;
import java.io.IOException;
import java.math.RoundingMode;
import java.net.URI;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestCheckpointEntryIterator {
    private static final String TEST_CHECKPOINT = "databricks73/person/_delta_log/00000000000000000010.checkpoint.parquet";
    private CheckpointSchemaManager checkpointSchemaManager;

    @BeforeAll
    public void setUp() {
        this.checkpointSchemaManager = new CheckpointSchemaManager(InternalTypeManager.TESTING_TYPE_MANAGER);
    }

    @AfterAll
    public void tearDown() {
        this.checkpointSchemaManager = null;
    }

    @Test
    public void testReadNoEntries() throws Exception {
        URI checkpointUri = Resources.getResource((String)TEST_CHECKPOINT).toURI();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.createCheckpointEntryIterator(checkpointUri, (Set<CheckpointEntryIterator.EntryType>)ImmutableSet.of(), Optional.empty(), Optional.empty(), (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.all(), Optional.empty())).isInstanceOf(IllegalArgumentException.class)).hasMessage("fields is empty");
    }

    @Test
    public void testReadMetadataEntry() throws Exception {
        URI checkpointUri = Resources.getResource((String)TEST_CHECKPOINT).toURI();
        Assertions.assertThat((Object)this.readMetadataEntry(checkpointUri)).isEqualTo((Object)new MetadataEntry("b6aeffad-da73-4dde-b68e-937e468b1fde", null, null, new MetadataEntry.Format("parquet", Map.of()), "{\"type\":\"struct\",\"fields\":[{\"name\":\"name\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}},{\"name\":\"age\",\"type\":\"integer\",\"nullable\":true,\"metadata\":{}},{\"name\":\"married\",\"type\":\"boolean\",\"nullable\":true,\"metadata\":{}},{\"name\":\"phones\",\"type\":{\"type\":\"array\",\"elementType\":{\"type\":\"struct\",\"fields\":[{\"name\":\"number\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}},{\"name\":\"label\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}}]},\"containsNull\":true},\"nullable\":true,\"metadata\":{}},{\"name\":\"address\",\"type\":{\"type\":\"struct\",\"fields\":[{\"name\":\"street\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}},{\"name\":\"city\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}},{\"name\":\"state\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}},{\"name\":\"zip\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}}]},\"nullable\":true,\"metadata\":{}},{\"name\":\"income\",\"type\":\"double\",\"nullable\":true,\"metadata\":{}}]}", List.of("age"), Map.of(), 1579190100722L));
    }

    @Test
    public void testReadProtocolEntries() throws Exception {
        URI checkpointUri = Resources.getResource((String)TEST_CHECKPOINT).toURI();
        CheckpointEntryIterator checkpointEntryIterator = this.createCheckpointEntryIterator(checkpointUri, (Set<CheckpointEntryIterator.EntryType>)ImmutableSet.of((Object)CheckpointEntryIterator.EntryType.PROTOCOL), Optional.empty(), Optional.empty(), (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.all(), Optional.empty());
        ImmutableList entries = ImmutableList.copyOf((Iterator)checkpointEntryIterator);
        Assertions.assertThat((List)entries).hasSize(1);
        ((ObjectAssert)Assertions.assertThat((List)entries).element(0)).extracting(DeltaLakeTransactionLogEntry::getProtocol).isEqualTo((Object)new ProtocolEntry(1, 2, Optional.empty(), Optional.empty()));
    }

    @Test
    public void testReadMetadataAndProtocolEntry() throws Exception {
        URI checkpointUri = Resources.getResource((String)TEST_CHECKPOINT).toURI();
        CheckpointEntryIterator checkpointEntryIterator = this.createCheckpointEntryIterator(checkpointUri, (Set<CheckpointEntryIterator.EntryType>)ImmutableSet.of((Object)CheckpointEntryIterator.EntryType.METADATA, (Object)CheckpointEntryIterator.EntryType.PROTOCOL), Optional.empty(), Optional.empty(), (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.all(), Optional.empty());
        ImmutableList entries = ImmutableList.copyOf((Iterator)checkpointEntryIterator);
        Assertions.assertThat((List)entries).hasSize(2);
        Assertions.assertThat((List)entries).containsExactlyInAnyOrder((Object[])new DeltaLakeTransactionLogEntry[]{DeltaLakeTransactionLogEntry.metadataEntry((MetadataEntry)new MetadataEntry("b6aeffad-da73-4dde-b68e-937e468b1fde", null, null, new MetadataEntry.Format("parquet", Map.of()), "{\"type\":\"struct\",\"fields\":[{\"name\":\"name\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}},{\"name\":\"age\",\"type\":\"integer\",\"nullable\":true,\"metadata\":{}},{\"name\":\"married\",\"type\":\"boolean\",\"nullable\":true,\"metadata\":{}},{\"name\":\"phones\",\"type\":{\"type\":\"array\",\"elementType\":{\"type\":\"struct\",\"fields\":[{\"name\":\"number\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}},{\"name\":\"label\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}}]},\"containsNull\":true},\"nullable\":true,\"metadata\":{}},{\"name\":\"address\",\"type\":{\"type\":\"struct\",\"fields\":[{\"name\":\"street\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}},{\"name\":\"city\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}},{\"name\":\"state\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}},{\"name\":\"zip\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}}]},\"nullable\":true,\"metadata\":{}},{\"name\":\"income\",\"type\":\"double\",\"nullable\":true,\"metadata\":{}}]}", List.of("age"), Map.of(), 1579190100722L)), DeltaLakeTransactionLogEntry.protocolEntry((ProtocolEntry)new ProtocolEntry(1, 2, Optional.empty(), Optional.empty()))});
    }

    @Test
    public void testReadAddEntries() throws Exception {
        URI checkpointUri = Resources.getResource((String)TEST_CHECKPOINT).toURI();
        CheckpointEntryIterator checkpointEntryIterator = this.createCheckpointEntryIterator(checkpointUri, (Set<CheckpointEntryIterator.EntryType>)ImmutableSet.of((Object)CheckpointEntryIterator.EntryType.ADD), Optional.of(this.readMetadataEntry(checkpointUri)), Optional.of(this.readProtocolEntry(checkpointUri)), (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.all(), Optional.of(Predicates.alwaysTrue()));
        ImmutableList entries = ImmutableList.copyOf((Iterator)checkpointEntryIterator);
        Assertions.assertThat((List)entries).hasSize(9);
        ((ObjectAssert)Assertions.assertThat((List)entries).element(3)).extracting(DeltaLakeTransactionLogEntry::getAdd).isEqualTo((Object)new AddFileEntry("age=42/part-00003-0f53cae3-3e34-4876-b651-e1db9584dbc3.c000.snappy.parquet", Map.of("age", "42"), 2634L, 1579190165000L, false, Optional.of("{\"numRecords\":1,\"minValues\":{\"name\":\"Alice\",\"address\":{\"street\":\"100 Main St\",\"city\":\"Anytown\",\"state\":\"NY\",\"zip\":\"12345\"},\"income\":111000.0},\"maxValues\":{\"name\":\"Alice\",\"address\":{\"street\":\"100 Main St\",\"city\":\"Anytown\",\"state\":\"NY\",\"zip\":\"12345\"},\"income\":111000.0},\"nullCount\":{\"name\":0,\"married\":0,\"phones\":0,\"address\":{\"street\":0,\"city\":0,\"state\":0,\"zip\":0},\"income\":0}}"), Optional.empty(), null, Optional.empty()));
        ((ObjectAssert)Assertions.assertThat((List)entries).element(7)).extracting(DeltaLakeTransactionLogEntry::getAdd).isEqualTo((Object)new AddFileEntry("age=30/part-00002-5800be2e-2373-47d8-8b86-776a8ea9d69f.c000.snappy.parquet", Map.of("age", "30"), 2688L, 1579190165000L, false, Optional.of("{\"numRecords\":1,\"minValues\":{\"name\":\"Andy\",\"address\":{\"street\":\"101 Main St\",\"city\":\"Anytown\",\"state\":\"NY\",\"zip\":\"12345\"},\"income\":81000.0},\"maxValues\":{\"name\":\"Andy\",\"address\":{\"street\":\"101 Main St\",\"city\":\"Anytown\",\"state\":\"NY\",\"zip\":\"12345\"},\"income\":81000.0},\"nullCount\":{\"name\":0,\"married\":0,\"phones\":0,\"address\":{\"street\":0,\"city\":0,\"state\":0,\"zip\":0},\"income\":0}}"), Optional.empty(), null, Optional.empty()));
    }

    @Test
    public void testReadAddEntriesPartitionPruning() throws Exception {
        String checkpoint = "deltalake/partition_values_parsed/_delta_log/00000000000000000003.checkpoint.parquet";
        URI checkpointUri = Resources.getResource((String)checkpoint).toURI();
        DeltaLakeColumnHandle stringPartField = new DeltaLakeColumnHandle("string_part", (Type)VarcharType.VARCHAR, OptionalInt.empty(), "string_part", (Type)VarcharType.VARCHAR, DeltaLakeColumnType.REGULAR, Optional.empty());
        DeltaLakeColumnHandle intPartField = new DeltaLakeColumnHandle("int_part", (Type)BigintType.BIGINT, OptionalInt.empty(), "int_part", (Type)BigintType.BIGINT, DeltaLakeColumnType.REGULAR, Optional.empty());
        CheckpointEntryIterator partitionsEntryIterator = this.createCheckpointEntryIterator(checkpointUri, (Set<CheckpointEntryIterator.EntryType>)ImmutableSet.of((Object)CheckpointEntryIterator.EntryType.ADD), Optional.of(this.readMetadataEntry(checkpointUri)), Optional.of(this.readProtocolEntry(checkpointUri)), (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)intPartField, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)10L), (Object)stringPartField, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"part1")))), Optional.of(Predicates.alwaysTrue()));
        ImmutableList partitionsEntries = ImmutableList.copyOf((Iterator)partitionsEntryIterator);
        Assertions.assertThat((long)partitionsEntryIterator.getCompletedPositions().orElseThrow()).isEqualTo(5L);
        ((ListAssert)Assertions.assertThat((List)partitionsEntries).hasSize(1)).extracting(entry -> entry.getAdd().getPath()).containsExactly((Object[])new String[]{"int_part=10/string_part=part1/part-00000-383afb1a-87de-4e70-86ab-c21ae44c7f3f.c000.snappy.parquet"});
        CheckpointEntryIterator partitionEntryIterator = this.createCheckpointEntryIterator(checkpointUri, (Set<CheckpointEntryIterator.EntryType>)ImmutableSet.of((Object)CheckpointEntryIterator.EntryType.ADD), Optional.of(this.readMetadataEntry(checkpointUri)), Optional.of(this.readProtocolEntry(checkpointUri)), (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)intPartField, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)10L))), Optional.of(Predicates.alwaysTrue()));
        ImmutableList partitionEntries = ImmutableList.copyOf((Iterator)partitionEntryIterator);
        Assertions.assertThat((long)partitionEntryIterator.getCompletedPositions().orElseThrow()).isEqualTo(5L);
        ((ListAssert)Assertions.assertThat((List)partitionEntries).hasSize(1)).extracting(entry -> entry.getAdd().getPath()).containsExactly((Object[])new String[]{"int_part=10/string_part=part1/part-00000-383afb1a-87de-4e70-86ab-c21ae44c7f3f.c000.snappy.parquet"});
        CheckpointEntryIterator emptyIterator = this.createCheckpointEntryIterator(checkpointUri, (Set<CheckpointEntryIterator.EntryType>)ImmutableSet.of((Object)CheckpointEntryIterator.EntryType.ADD), Optional.of(this.readMetadataEntry(checkpointUri)), Optional.of(this.readProtocolEntry(checkpointUri)), (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)intPartField, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)10L), (Object)stringPartField, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"unmatched partition condition")))), Optional.of(Predicates.alwaysTrue()));
        Assertions.assertThat((List)ImmutableList.copyOf((Iterator)emptyIterator)).isEmpty();
        CheckpointEntryIterator isNullIterator = this.createCheckpointEntryIterator(checkpointUri, (Set<CheckpointEntryIterator.EntryType>)ImmutableSet.of((Object)CheckpointEntryIterator.EntryType.ADD), Optional.of(this.readMetadataEntry(checkpointUri)), Optional.of(this.readProtocolEntry(checkpointUri)), (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)intPartField, (Object)Domain.onlyNull((Type)BigintType.BIGINT), (Object)stringPartField, (Object)Domain.onlyNull((Type)VarcharType.VARCHAR))), Optional.of(Predicates.alwaysTrue()));
        ((ListAssert)Assertions.assertThat((List)ImmutableList.copyOf((Iterator)isNullIterator)).hasSize(1)).extracting(entry -> entry.getAdd().getPath()).containsExactly((Object[])new String[]{"int_part=__HIVE_DEFAULT_PARTITION__/string_part=__HIVE_DEFAULT_PARTITION__/part-00000-dcb29d13-eeca-4fa6-a8bf-860da0131a5c.c000.snappy.parquet"});
        CheckpointEntryIterator isNotNullIterator = this.createCheckpointEntryIterator(checkpointUri, (Set<CheckpointEntryIterator.EntryType>)ImmutableSet.of((Object)CheckpointEntryIterator.EntryType.ADD), Optional.of(this.readMetadataEntry(checkpointUri)), Optional.of(this.readProtocolEntry(checkpointUri)), (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)intPartField, (Object)Domain.notNull((Type)BigintType.BIGINT), (Object)stringPartField, (Object)Domain.notNull((Type)VarcharType.VARCHAR))), Optional.of(Predicates.alwaysTrue()));
        ((ListAssert)Assertions.assertThat((List)ImmutableList.copyOf((Iterator)isNotNullIterator)).hasSize(2)).extracting(entry -> entry.getAdd().getPath()).containsExactly((Object[])new String[]{"int_part=10/string_part=part1/part-00000-383afb1a-87de-4e70-86ab-c21ae44c7f3f.c000.snappy.parquet", "int_part=20/string_part=part2/part-00000-e0b4887e-95f6-4ce1-b96c-32c5cf472476.c000.snappy.parquet"});
    }

    @Test
    public void testReadAddEntriesPartitionPruningAllTypes() throws Exception {
        String checkpoint = "deltalake/partition_values_parsed_all_types/_delta_log/00000000000000000003.checkpoint.parquet";
        URI checkpointUri = Resources.getResource((String)checkpoint).toURI();
        this.assertPartitionValuesParsedCondition(checkpointUri, "part_boolean", (Type)BooleanType.BOOLEAN, true);
        this.assertPartitionValuesParsedCondition(checkpointUri, "part_tinyint", (Type)TinyintType.TINYINT, 1L);
        this.assertPartitionValuesParsedCondition(checkpointUri, "part_smallint", (Type)SmallintType.SMALLINT, 10L);
        this.assertPartitionValuesParsedCondition(checkpointUri, "part_int", (Type)IntegerType.INTEGER, 100L);
        this.assertPartitionValuesParsedCondition(checkpointUri, "part_bigint", (Type)BigintType.BIGINT, 1000L);
        this.assertPartitionValuesParsedCondition(checkpointUri, "part_short_decimal", (Type)DecimalType.createDecimalType((int)5, (int)2), 12312L);
        this.assertPartitionValuesParsedCondition(checkpointUri, "part_long_decimal", (Type)DecimalType.createDecimalType((int)21, (int)3), Int128.valueOf((String)"123456789012345678123"));
        this.assertPartitionValuesParsedCondition(checkpointUri, "part_double", (Type)DoubleType.DOUBLE, 1.2);
        this.assertPartitionValuesParsedCondition(checkpointUri, "part_float", (Type)RealType.REAL, Float.floatToIntBits(3.4f));
        this.assertPartitionValuesParsedCondition(checkpointUri, "part_varchar", (Type)VarcharType.VARCHAR, Slices.utf8Slice((String)"a"));
        this.assertPartitionValuesParsedCondition(checkpointUri, "part_date", (Type)DateType.DATE, LocalDate.parse("2020-08-21").toEpochDay());
        ZonedDateTime zonedDateTime = LocalDateTime.parse("2020-10-21T01:00:00.123").atZone(ZoneOffset.UTC);
        long timestampValue = DateTimeEncoding.packDateTimeWithZone((long)zonedDateTime.toInstant().toEpochMilli(), (TimeZoneKey)TimeZoneKey.UTC_KEY);
        this.assertPartitionValuesParsedCondition(checkpointUri, "part_timestamp", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, timestampValue);
        LocalDateTime timestampNtz = LocalDateTime.parse("2023-01-02T01:02:03.456");
        long timestampNtzValue = timestampNtz.toEpochSecond(ZoneOffset.UTC) * 1000000L + LongMath.divide((long)timestampNtz.getNano(), (long)1000L, (RoundingMode)RoundingMode.UNNECESSARY);
        this.assertPartitionValuesParsedCondition(checkpointUri, "part_timestamp_ntz", (Type)TimestampType.TIMESTAMP_MICROS, timestampNtzValue);
    }

    private void assertPartitionValuesParsedCondition(URI checkpointUri, String columnName, Type type, Object value) throws IOException {
        DeltaLakeColumnHandle intPartField = new DeltaLakeColumnHandle(columnName, type, OptionalInt.empty(), columnName, type, DeltaLakeColumnType.REGULAR, Optional.empty());
        CheckpointEntryIterator partitionEntryIterator = this.createCheckpointEntryIterator(checkpointUri, (Set<CheckpointEntryIterator.EntryType>)ImmutableSet.of((Object)CheckpointEntryIterator.EntryType.ADD), Optional.of(this.readMetadataEntry(checkpointUri)), Optional.of(this.readProtocolEntry(checkpointUri)), (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)intPartField, (Object)Domain.singleValue((Type)type, (Object)value))), Optional.of(Predicates.alwaysTrue()));
        ImmutableList partitionEntries = ImmutableList.copyOf((Iterator)partitionEntryIterator);
        Assertions.assertThat((long)partitionEntryIterator.getCompletedPositions().orElseThrow()).isEqualTo(5L);
        Assertions.assertThat((List)partitionEntries).hasSize(1);
    }

    @Test
    public void testReadAddEntriesStatsProjection() throws Exception {
        int countIntegerColumns = 20;
        int countStringColumns = 20;
        String string = "{\"name\":\"intcol%s\",\"type\":\"integer\",\"nullable\":true,\"metadata\":{}}";
        string = "{\"name\":\"stringcol%s\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}}";
        MetadataEntry metadataEntry = new MetadataEntry("metadataId", "metadataName", "metadataDescription", new MetadataEntry.Format("metadataFormatProvider", (Map)ImmutableMap.of()), "{\"type\":\"struct\",\"fields\":[" + IntStream.rangeClosed(1, countIntegerColumns).boxed().map(arg_0 -> TestCheckpointEntryIterator.lambda$testReadAddEntriesStatsProjection$0("{\"name\":\"intcol%s\",\"type\":\"integer\",\"nullable\":true,\"metadata\":{}}", arg_0)).collect(Collectors.joining(",", "", ",")) + IntStream.rangeClosed(1, countStringColumns).boxed().map(arg_0 -> TestCheckpointEntryIterator.lambda$testReadAddEntriesStatsProjection$1("{\"name\":\"stringcol%s\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}}", arg_0)).collect(Collectors.joining(",")) + "]}", (List)ImmutableList.of(), (Map)ImmutableMap.of((Object)"delta.checkpoint.writeStatsAsJson", (Object)"false", (Object)"delta.checkpoint.writeStatsAsStruct", (Object)"true"), 1000L);
        ProtocolEntry protocolEntry = new ProtocolEntry(10, 20, Optional.empty(), Optional.empty());
        int countAddEntries = 30;
        Set addFileEntries = (Set)IntStream.rangeClosed(1, countAddEntries).mapToObj(fileIndex -> new AddFileEntry("addFilePathParquetStats" + fileIndex, (Map)ImmutableMap.of(), 1000L, 1001L, true, Optional.empty(), Optional.of(TestCheckpointEntryIterator.createDeltaLakeParquetFileStatistics(countIntegerColumns, countStringColumns)), (Map)ImmutableMap.of(), Optional.empty())).collect(ImmutableSet.toImmutableSet());
        CheckpointEntries entries = new CheckpointEntries(metadataEntry, protocolEntry, (Set)ImmutableSet.of(), addFileEntries, (Set)ImmutableSet.of());
        CheckpointWriter writer = new CheckpointWriter(InternalTypeManager.TESTING_TYPE_MANAGER, this.checkpointSchemaManager, "test", ParquetWriterOptions.builder().build());
        File targetFile = File.createTempFile("testAddStatsProjection-", ".checkpoint.parquet");
        targetFile.deleteOnExit();
        String targetPath = "file://" + targetFile.getAbsolutePath();
        targetFile.delete();
        writer.write(entries, TestCheckpointEntryIterator.createOutputFile(targetPath));
        MetadataEntry readMetadataEntry = this.readMetadataEntry(URI.create(targetPath));
        ProtocolEntry readProtocolEntry = this.readProtocolEntry(URI.create(targetPath));
        CheckpointEntryIterator checkpointEntryWithNameColumnStatsIterator = this.createCheckpointEntryIterator(URI.create(targetPath), (Set<CheckpointEntryIterator.EntryType>)ImmutableSet.of((Object)CheckpointEntryIterator.EntryType.ADD), Optional.of(readMetadataEntry), Optional.of(readProtocolEntry), (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.all(), Optional.of(columnName -> ImmutableList.of((Object)"intcol1", (Object)"stringcol1").contains(columnName)));
        ImmutableList checkpointEntryWithNameColumnStatsEntries = ImmutableList.copyOf((Iterator)checkpointEntryWithNameColumnStatsIterator);
        Assertions.assertThat((List)checkpointEntryWithNameColumnStatsEntries).hasSize(countAddEntries);
        CheckpointEntryIterator checkpointEntryWithAllColumnStatsIterator = this.createCheckpointEntryIterator(URI.create(targetPath), (Set<CheckpointEntryIterator.EntryType>)ImmutableSet.of((Object)CheckpointEntryIterator.EntryType.ADD), Optional.of(readMetadataEntry), Optional.of(readProtocolEntry), (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.all(), Optional.of(Predicates.alwaysTrue()));
        ImmutableList checkpointEntryWithAllStatsEntries = ImmutableList.copyOf((Iterator)checkpointEntryWithAllColumnStatsIterator);
        Assertions.assertThat((List)checkpointEntryWithAllStatsEntries).hasSize(countAddEntries);
        Assertions.assertThat((long)checkpointEntryWithNameColumnStatsIterator.getCompletedBytes()).isLessThan(checkpointEntryWithAllColumnStatsIterator.getCompletedBytes() * 9L / 10L);
    }

    private static DeltaLakeParquetFileStatistics createDeltaLakeParquetFileStatistics(int countIntegerColumns, int countStringColumns) {
        Random random = new Random();
        String string = "intcol%s";
        string = "stringcol%s";
        ImmutableMap minValues = ImmutableMap.builder().putAll((Map)IntStream.rangeClosed(1, countIntegerColumns).boxed().collect(ImmutableMap.toImmutableMap(arg_0 -> TestCheckpointEntryIterator.lambda$createDeltaLakeParquetFileStatistics$0("intcol%s", arg_0), columnIndex -> random.nextLong(0L, 1000L)))).putAll((Map)IntStream.rangeClosed(1, countStringColumns).boxed().collect(ImmutableMap.toImmutableMap(arg_0 -> TestCheckpointEntryIterator.lambda$createDeltaLakeParquetFileStatistics$2("stringcol%s", arg_0), columnIndex -> "A".repeat(random.nextInt(1, 10)) + String.valueOf(UUID.randomUUID())))).buildOrThrow();
        String string2 = "intcol%s";
        string2 = "stringcol%s";
        ImmutableMap maxValues = ImmutableMap.builder().putAll((Map)IntStream.rangeClosed(1, countIntegerColumns).boxed().collect(ImmutableMap.toImmutableMap(arg_0 -> TestCheckpointEntryIterator.lambda$createDeltaLakeParquetFileStatistics$4("intcol%s", arg_0), columnIndex -> 1000L + random.nextLong(0L, 1000L)))).putAll((Map)IntStream.rangeClosed(1, countStringColumns).boxed().collect(ImmutableMap.toImmutableMap(arg_0 -> TestCheckpointEntryIterator.lambda$createDeltaLakeParquetFileStatistics$6("stringcol%s", arg_0), columnIndex -> "Z".repeat(random.nextInt(1, 10)) + String.valueOf(UUID.randomUUID())))).buildOrThrow();
        String string3 = "intcol%s";
        string3 = "stringcol%s";
        ImmutableMap nullCount = ImmutableMap.builder().putAll((Map)IntStream.rangeClosed(1, countIntegerColumns).boxed().collect(ImmutableMap.toImmutableMap(arg_0 -> TestCheckpointEntryIterator.lambda$createDeltaLakeParquetFileStatistics$8("intcol%s", arg_0), columnIndex -> random.nextLong(0L, 1000L)))).putAll((Map)IntStream.rangeClosed(1, countStringColumns).boxed().collect(ImmutableMap.toImmutableMap(arg_0 -> TestCheckpointEntryIterator.lambda$createDeltaLakeParquetFileStatistics$10("stringcol%s", arg_0), columnIndex -> random.nextLong(0L, 1000L)))).buildOrThrow();
        return new DeltaLakeParquetFileStatistics(Optional.of(1000L), Optional.of(minValues), Optional.of(maxValues), Optional.of(nullCount));
    }

    @Test
    public void testReadAllEntries() throws Exception {
        URI checkpointUri = Resources.getResource((String)TEST_CHECKPOINT).toURI();
        MetadataEntry metadataEntry = this.readMetadataEntry(checkpointUri);
        CheckpointEntryIterator checkpointEntryIterator = this.createCheckpointEntryIterator(checkpointUri, (Set<CheckpointEntryIterator.EntryType>)ImmutableSet.of((Object)CheckpointEntryIterator.EntryType.METADATA, (Object)CheckpointEntryIterator.EntryType.PROTOCOL, (Object)CheckpointEntryIterator.EntryType.TRANSACTION, (Object)CheckpointEntryIterator.EntryType.ADD, (Object)CheckpointEntryIterator.EntryType.REMOVE), Optional.of(this.readMetadataEntry(checkpointUri)), Optional.of(this.readProtocolEntry(checkpointUri)), (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.all(), Optional.of(Predicates.alwaysTrue()));
        ImmutableList entries = ImmutableList.copyOf((Iterator)checkpointEntryIterator);
        Assertions.assertThat((List)entries).hasSize(17);
        ((ObjectAssert)Assertions.assertThat((List)entries).element(12)).extracting(DeltaLakeTransactionLogEntry::getMetaData).isEqualTo((Object)metadataEntry);
        ((ObjectAssert)Assertions.assertThat((List)entries).element(11)).extracting(DeltaLakeTransactionLogEntry::getProtocol).isEqualTo((Object)new ProtocolEntry(1, 2, Optional.empty(), Optional.empty()));
        ((AbstractListAssert)Assertions.assertThat((List)entries).map(DeltaLakeTransactionLogEntry::getTxn).filteredOn(Objects::nonNull)).isEmpty();
        ((ObjectAssert)Assertions.assertThat((List)entries).element(8)).extracting(DeltaLakeTransactionLogEntry::getAdd).isEqualTo((Object)new AddFileEntry("age=42/part-00003-0f53cae3-3e34-4876-b651-e1db9584dbc3.c000.snappy.parquet", Map.of("age", "42"), 2634L, 1579190165000L, false, Optional.of("{\"numRecords\":1,\"minValues\":{\"name\":\"Alice\",\"address\":{\"street\":\"100 Main St\",\"city\":\"Anytown\",\"state\":\"NY\",\"zip\":\"12345\"},\"income\":111000.0},\"maxValues\":{\"name\":\"Alice\",\"address\":{\"street\":\"100 Main St\",\"city\":\"Anytown\",\"state\":\"NY\",\"zip\":\"12345\"},\"income\":111000.0},\"nullCount\":{\"name\":0,\"married\":0,\"phones\":0,\"address\":{\"street\":0,\"city\":0,\"state\":0,\"zip\":0},\"income\":0}}"), Optional.empty(), null, Optional.empty()));
        ((ObjectAssert)Assertions.assertThat((List)entries).element(3)).extracting(DeltaLakeTransactionLogEntry::getRemove).isEqualTo((Object)new RemoveFileEntry("age=42/part-00000-951068bd-bcf4-4094-bb94-536f3c41d31f.c000.snappy.parquet", null, 1579190155406L, false, Optional.empty()));
    }

    @Test
    public void testSkipAddEntriesThroughPartitionPruning() throws IOException {
        MetadataEntry metadataEntry = new MetadataEntry("metadataId", "metadataName", "metadataDescription", new MetadataEntry.Format("metadataFormatProvider", (Map)ImmutableMap.of()), "{\"type\":\"struct\",\"fields\":[{\"name\":\"ts\",\"type\":\"timestamp\",\"nullable\":true,\"metadata\":{}},{\"name\":\"part_key\",\"type\":\"integer\",\"nullable\":true,\"metadata\":{}}]}", (List)ImmutableList.of((Object)"part_key"), (Map)ImmutableMap.of(), 1000L);
        ProtocolEntry protocolEntry = new ProtocolEntry(1, 1, Optional.empty(), Optional.empty());
        int numAddEntries = 100;
        Set addFileEntries = (Set)IntStream.rangeClosed(1, numAddEntries).mapToObj(value -> new AddFileEntry("addFilePath", (Map)ImmutableMap.of((Object)"part_key", (Object)Integer.toString(value)), 1000L, 1001L, true, Optional.of("{\"numRecords\":20,\"minValues\":{\"ts\":\"1990-10-31T01:00:00.000Z\"},\"maxValues\":{\"ts\":\"1990-10-31T02:00:00.000Z\"},\"nullCount\":{\"ts\":1}}"), Optional.empty(), (Map)ImmutableMap.of(), Optional.empty())).collect(ImmutableSet.toImmutableSet());
        CheckpointEntries entries = new CheckpointEntries(metadataEntry, protocolEntry, (Set)ImmutableSet.of(), addFileEntries, (Set)ImmutableSet.of());
        CheckpointWriter writer = new CheckpointWriter(InternalTypeManager.TESTING_TYPE_MANAGER, this.checkpointSchemaManager, "test", ParquetWriterOptions.builder().setMaxBlockSize(DataSize.ofBytes((long)64L)).setMaxPageSize(DataSize.ofBytes((long)64L)).build());
        File targetFile = File.createTempFile("testSkipAddEntries-", ".checkpoint.parquet");
        targetFile.deleteOnExit();
        String targetPath = "file://" + targetFile.getAbsolutePath();
        targetFile.delete();
        writer.write(entries, TestCheckpointEntryIterator.createOutputFile(targetPath));
        CheckpointEntryIterator metadataAndProtocolEntryIterator = this.createCheckpointEntryIterator(URI.create(targetPath), (Set<CheckpointEntryIterator.EntryType>)ImmutableSet.of((Object)CheckpointEntryIterator.EntryType.METADATA, (Object)CheckpointEntryIterator.EntryType.PROTOCOL), Optional.empty(), Optional.empty(), (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.all(), Optional.empty());
        DeltaLakeColumnHandle partitionKeyField = new DeltaLakeColumnHandle("part_key", (Type)IntegerType.INTEGER, OptionalInt.empty(), "part_key", (Type)IntegerType.INTEGER, DeltaLakeColumnType.REGULAR, Optional.empty());
        CheckpointEntryIterator addEntryIterator = this.createCheckpointEntryIterator(URI.create(targetPath), (Set<CheckpointEntryIterator.EntryType>)ImmutableSet.of((Object)CheckpointEntryIterator.EntryType.ADD), Optional.of(metadataEntry), Optional.of(protocolEntry), (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.all(), Optional.of(Predicates.alwaysTrue()));
        CheckpointEntryIterator addEntryIteratorWithEqualityPartitionFilter = this.createCheckpointEntryIterator(URI.create(targetPath), (Set<CheckpointEntryIterator.EntryType>)ImmutableSet.of((Object)CheckpointEntryIterator.EntryType.ADD), Optional.of(metadataEntry), Optional.of(protocolEntry), (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)partitionKeyField, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)10L))), Optional.of(Predicates.alwaysTrue()));
        CheckpointEntryIterator addEntryIteratorWithRangePartitionFilter = this.createCheckpointEntryIterator(URI.create(targetPath), (Set<CheckpointEntryIterator.EntryType>)ImmutableSet.of((Object)CheckpointEntryIterator.EntryType.ADD), Optional.of(metadataEntry), Optional.of(protocolEntry), (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)partitionKeyField, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)IntegerType.INTEGER, (Object)9L, (boolean)true, (Object)11L, (boolean)true), (Range[])new Range[0]), (boolean)false))), Optional.of(Predicates.alwaysTrue()));
        Assertions.assertThat((int)Iterators.size((Iterator)metadataAndProtocolEntryIterator)).isEqualTo(2);
        Assertions.assertThat((long)metadataAndProtocolEntryIterator.getCompletedPositions().orElseThrow()).isEqualTo(3L);
        Assertions.assertThat((int)Iterators.size((Iterator)addEntryIterator)).isEqualTo(numAddEntries);
        Assertions.assertThat((long)addEntryIterator.getCompletedPositions().orElseThrow()).isEqualTo(101L);
        Assertions.assertThat((int)Iterators.size((Iterator)addEntryIteratorWithEqualityPartitionFilter)).isEqualTo(1);
        Assertions.assertThat((long)addEntryIteratorWithEqualityPartitionFilter.getCompletedPositions().orElseThrow()).isEqualTo(1L);
        Assertions.assertThat((int)Iterators.size((Iterator)addEntryIteratorWithRangePartitionFilter)).isEqualTo(3);
        Assertions.assertThat((long)addEntryIteratorWithRangePartitionFilter.getCompletedPositions().orElseThrow()).isEqualTo(3L);
    }

    @Test
    public void testSkipAddEntriesThroughComposedPartitionPruning() throws IOException {
        MetadataEntry metadataEntry = new MetadataEntry("metadataId", "metadataName", "metadataDescription", new MetadataEntry.Format("metadataFormatProvider", (Map)ImmutableMap.of()), "{\"type\":\"struct\",\"fields\":[{\"name\":\"ts\",\"type\":\"timestamp\",\"nullable\":true,\"metadata\":{}},{\"name\":\"part_day\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}},{\"name\":\"part_hour\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}}]}", (List)ImmutableList.of((Object)"part_day", (Object)"part_hour"), (Map)ImmutableMap.of(), 1000L);
        ProtocolEntry protocolEntry = new ProtocolEntry(1, 1, Optional.empty(), Optional.empty());
        LocalDateTime date = LocalDateTime.of(2023, 12, 1, 0, 0);
        DateTimeFormatter dayFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        DateTimeFormatter hourFormatter = DateTimeFormatter.ofPattern("HH");
        int numAddEntries = 100;
        Set addFileEntries = (Set)IntStream.rangeClosed(1, numAddEntries).mapToObj(index -> new AddFileEntry("addFilePath", (Map)ImmutableMap.of((Object)"part_day", (Object)date.plusHours(index).format(dayFormatter), (Object)"part_hour", (Object)date.plusHours(index).format(hourFormatter)), 1000L, 1001L, true, Optional.of("{\"numRecords\":20,\"minValues\":{\"ts\":\"1990-10-31T01:00:00.000Z\"},\"maxValues\":{\"ts\":\"1990-10-31T02:00:00.000Z\"},\"nullCount\":{\"ts\":1}}"), Optional.empty(), (Map)ImmutableMap.of(), Optional.empty())).collect(ImmutableSet.toImmutableSet());
        CheckpointEntries entries = new CheckpointEntries(metadataEntry, protocolEntry, (Set)ImmutableSet.of(), addFileEntries, (Set)ImmutableSet.of());
        CheckpointWriter writer = new CheckpointWriter(InternalTypeManager.TESTING_TYPE_MANAGER, this.checkpointSchemaManager, "test", ParquetWriterOptions.builder().setMaxBlockSize(DataSize.ofBytes((long)128L)).setMaxPageSize(DataSize.ofBytes((long)128L)).build());
        File targetFile = File.createTempFile("testSkipAddEntries-", ".checkpoint.parquet");
        targetFile.deleteOnExit();
        String targetPath = "file://" + targetFile.getAbsolutePath();
        targetFile.delete();
        writer.write(entries, TestCheckpointEntryIterator.createOutputFile(targetPath));
        CheckpointEntryIterator metadataAndProtocolEntryIterator = this.createCheckpointEntryIterator(URI.create(targetPath), (Set<CheckpointEntryIterator.EntryType>)ImmutableSet.of((Object)CheckpointEntryIterator.EntryType.METADATA, (Object)CheckpointEntryIterator.EntryType.PROTOCOL), Optional.empty(), Optional.empty(), (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.all(), Optional.empty());
        DeltaLakeColumnHandle partitionDayField = new DeltaLakeColumnHandle("part_day", (Type)VarcharType.VARCHAR, OptionalInt.empty(), "part_day", (Type)VarcharType.VARCHAR, DeltaLakeColumnType.REGULAR, Optional.empty());
        DeltaLakeColumnHandle partitionHourField = new DeltaLakeColumnHandle("part_hour", (Type)VarcharType.VARCHAR, OptionalInt.empty(), "part_hour", (Type)VarcharType.VARCHAR, DeltaLakeColumnType.REGULAR, Optional.empty());
        CheckpointEntryIterator addEntryIterator = this.createCheckpointEntryIterator(URI.create(targetPath), (Set<CheckpointEntryIterator.EntryType>)ImmutableSet.of((Object)CheckpointEntryIterator.EntryType.ADD), Optional.of(metadataEntry), Optional.of(protocolEntry), (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.all(), Optional.of(Predicates.alwaysTrue()));
        CheckpointEntryIterator addEntryIteratorEqualityDayPartitionFilter = this.createCheckpointEntryIterator(URI.create(targetPath), (Set<CheckpointEntryIterator.EntryType>)ImmutableSet.of((Object)CheckpointEntryIterator.EntryType.ADD), Optional.of(metadataEntry), Optional.of(protocolEntry), (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)partitionDayField, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"20231202")))), Optional.of(Predicates.alwaysTrue()));
        CheckpointEntryIterator addEntryIteratorWithDayAndHourEqualityPartitionFilter = this.createCheckpointEntryIterator(URI.create(targetPath), (Set<CheckpointEntryIterator.EntryType>)ImmutableSet.of((Object)CheckpointEntryIterator.EntryType.ADD), Optional.of(metadataEntry), Optional.of(protocolEntry), (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)partitionDayField, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"20231202")), (Object)partitionHourField, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"10")))), Optional.of(Predicates.alwaysTrue()));
        Assertions.assertThat((int)Iterators.size((Iterator)metadataAndProtocolEntryIterator)).isEqualTo(2);
        Assertions.assertThat((long)metadataAndProtocolEntryIterator.getCompletedPositions().orElseThrow()).isEqualTo(3L);
        Assertions.assertThat((int)Iterators.size((Iterator)addEntryIterator)).isEqualTo(numAddEntries);
        Assertions.assertThat((long)addEntryIterator.getCompletedPositions().orElseThrow()).isEqualTo(101L);
        Assertions.assertThat((int)Iterators.size((Iterator)addEntryIteratorEqualityDayPartitionFilter)).isEqualTo(24);
        Assertions.assertThat((long)addEntryIteratorEqualityDayPartitionFilter.getCompletedPositions().orElseThrow()).isEqualTo(24L);
        Assertions.assertThat((int)Iterators.size((Iterator)addEntryIteratorWithDayAndHourEqualityPartitionFilter)).isEqualTo(1);
        Assertions.assertThat((long)addEntryIteratorWithDayAndHourEqualityPartitionFilter.getCompletedPositions().orElseThrow()).isEqualTo(1L);
    }

    @Test
    public void testSkipRemoveEntries() throws IOException {
        MetadataEntry metadataEntry = new MetadataEntry("metadataId", "metadataName", "metadataDescription", new MetadataEntry.Format("metadataFormatProvider", (Map)ImmutableMap.of()), "{\"type\":\"struct\",\"fields\":[{\"name\":\"ts\",\"type\":\"timestamp\",\"nullable\":true,\"metadata\":{}},{\"name\":\"part_key\",\"type\":\"timestamp\",\"nullable\":true,\"metadata\":{}}]}", (List)ImmutableList.of((Object)"part_key"), (Map)ImmutableMap.of(), 1000L);
        ProtocolEntry protocolEntry = new ProtocolEntry(10, 20, Optional.empty(), Optional.empty());
        AddFileEntry addFileEntryJsonStats = new AddFileEntry("addFilePathJson", (Map)ImmutableMap.of((Object)"part_key", (Object)"2023-01-01 00:00:00"), 1000L, 1001L, true, Optional.of("{\"numRecords\":20,\"minValues\":{\"ts\":\"2960-10-31T01:00:00.000Z\"},\"maxValues\":{\"ts\":\"2960-10-31T02:00:00.000Z\"},\"nullCount\":{\"ts\":1}}"), Optional.empty(), (Map)ImmutableMap.of(), Optional.empty());
        int numRemoveEntries = 100;
        Set removeEntries = (Set)IntStream.range(0, numRemoveEntries).mapToObj(x -> new RemoveFileEntry(UUID.randomUUID().toString(), (Map)ImmutableMap.of((Object)"part_key", (Object)"2023-01-01 00:00:00"), 1000L, true, Optional.empty())).collect(ImmutableSet.toImmutableSet());
        CheckpointEntries entries = new CheckpointEntries(metadataEntry, protocolEntry, (Set)ImmutableSet.of(), (Set)ImmutableSet.of((Object)addFileEntryJsonStats), removeEntries);
        CheckpointWriter writer = new CheckpointWriter(InternalTypeManager.TESTING_TYPE_MANAGER, this.checkpointSchemaManager, "test", ParquetWriterOptions.builder().setMaxBlockSize(DataSize.ofBytes((long)64L)).setMaxPageSize(DataSize.ofBytes((long)64L)).build());
        File targetFile = File.createTempFile("testSkipRemoveEntries-", ".checkpoint.parquet");
        targetFile.deleteOnExit();
        String targetPath = "file://" + targetFile.getAbsolutePath();
        targetFile.delete();
        writer.write(entries, TestCheckpointEntryIterator.createOutputFile(targetPath));
        CheckpointEntryIterator metadataAndProtocolEntryIterator = this.createCheckpointEntryIterator(URI.create(targetPath), (Set<CheckpointEntryIterator.EntryType>)ImmutableSet.of((Object)CheckpointEntryIterator.EntryType.METADATA, (Object)CheckpointEntryIterator.EntryType.PROTOCOL), Optional.empty(), Optional.empty(), (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.all(), Optional.empty());
        CheckpointEntryIterator addEntryIterator = this.createCheckpointEntryIterator(URI.create(targetPath), (Set<CheckpointEntryIterator.EntryType>)ImmutableSet.of((Object)CheckpointEntryIterator.EntryType.ADD), Optional.of(metadataEntry), Optional.of(protocolEntry), (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.all(), Optional.of(Predicates.alwaysTrue()));
        CheckpointEntryIterator removeEntryIterator = this.createCheckpointEntryIterator(URI.create(targetPath), (Set<CheckpointEntryIterator.EntryType>)ImmutableSet.of((Object)CheckpointEntryIterator.EntryType.REMOVE), Optional.empty(), Optional.empty(), (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.all(), Optional.empty());
        CheckpointEntryIterator txnEntryIterator = this.createCheckpointEntryIterator(URI.create(targetPath), (Set<CheckpointEntryIterator.EntryType>)ImmutableSet.of((Object)CheckpointEntryIterator.EntryType.TRANSACTION), Optional.empty(), Optional.empty(), (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.all(), Optional.empty());
        Assertions.assertThat((int)Iterators.size((Iterator)metadataAndProtocolEntryIterator)).isEqualTo(2);
        Assertions.assertThat((int)Iterators.size((Iterator)addEntryIterator)).isEqualTo(1);
        Assertions.assertThat((int)Iterators.size((Iterator)removeEntryIterator)).isEqualTo(numRemoveEntries);
        Assertions.assertThat((int)Iterators.size((Iterator)txnEntryIterator)).isEqualTo(0);
        Assertions.assertThat((long)metadataAndProtocolEntryIterator.getCompletedPositions().orElseThrow()).isEqualTo(3L);
        Assertions.assertThat((long)addEntryIterator.getCompletedPositions().orElseThrow()).isEqualTo(2L);
        Assertions.assertThat((long)removeEntryIterator.getCompletedPositions().orElseThrow()).isEqualTo(100L);
        Assertions.assertThat((long)txnEntryIterator.getCompletedPositions().orElseThrow()).isEqualTo(0L);
    }

    private MetadataEntry readMetadataEntry(URI checkpointUri) throws IOException {
        CheckpointEntryIterator checkpointEntryIterator = this.createCheckpointEntryIterator(checkpointUri, (Set<CheckpointEntryIterator.EntryType>)ImmutableSet.of((Object)CheckpointEntryIterator.EntryType.METADATA), Optional.empty(), Optional.empty(), (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.all(), Optional.empty());
        return ((DeltaLakeTransactionLogEntry)Iterators.getOnlyElement((Iterator)checkpointEntryIterator)).getMetaData();
    }

    private ProtocolEntry readProtocolEntry(URI checkpointUri) throws IOException {
        CheckpointEntryIterator checkpointEntryIterator = this.createCheckpointEntryIterator(checkpointUri, (Set<CheckpointEntryIterator.EntryType>)ImmutableSet.of((Object)CheckpointEntryIterator.EntryType.PROTOCOL), Optional.empty(), Optional.empty(), (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.all(), Optional.empty());
        return ((DeltaLakeTransactionLogEntry)Iterators.getOnlyElement((Iterator)checkpointEntryIterator)).getProtocol();
    }

    private CheckpointEntryIterator createCheckpointEntryIterator(URI checkpointUri, Set<CheckpointEntryIterator.EntryType> entryTypes, Optional<MetadataEntry> metadataEntry, Optional<ProtocolEntry> protocolEntry, TupleDomain<DeltaLakeColumnHandle> partitionConstraint, Optional<Predicate<String>> addStatsMinMaxColumnFilter) throws IOException {
        TrinoFileSystem fileSystem = new HdfsFileSystemFactory(HiveTestUtils.HDFS_ENVIRONMENT, HiveTestUtils.HDFS_FILE_SYSTEM_STATS).create(DeltaTestingConnectorSession.SESSION);
        TrinoInputFile checkpointFile = fileSystem.newInputFile(Location.of((String)checkpointUri.toString()));
        return new CheckpointEntryIterator(checkpointFile, DeltaTestingConnectorSession.SESSION, checkpointFile.length(), this.checkpointSchemaManager, InternalTypeManager.TESTING_TYPE_MANAGER, entryTypes, metadataEntry, protocolEntry, new FileFormatDataSourceStats(), ParquetReaderOptions.builder().withMaxBufferSize(DataSize.ofBytes((long)500L)).withSmallFileThreshold(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE)).build(), true, new DeltaLakeConfig().getDomainCompactionThreshold(), partitionConstraint, addStatsMinMaxColumnFilter);
    }

    private static TrinoOutputFile createOutputFile(String path) {
        return new HdfsFileSystemFactory(HiveTestUtils.HDFS_ENVIRONMENT, HiveTestUtils.HDFS_FILE_SYSTEM_STATS).create(DeltaTestingConnectorSession.SESSION).newOutputFile(Location.of((String)path));
    }

    private static /* synthetic */ String lambda$createDeltaLakeParquetFileStatistics$10(String rec$, Object xva$0) {
        return "stringcol%s".formatted(xva$0);
    }

    private static /* synthetic */ String lambda$createDeltaLakeParquetFileStatistics$8(String rec$, Object xva$0) {
        return "intcol%s".formatted(xva$0);
    }

    private static /* synthetic */ String lambda$createDeltaLakeParquetFileStatistics$6(String rec$, Object xva$0) {
        return "stringcol%s".formatted(xva$0);
    }

    private static /* synthetic */ String lambda$createDeltaLakeParquetFileStatistics$4(String rec$, Object xva$0) {
        return "intcol%s".formatted(xva$0);
    }

    private static /* synthetic */ String lambda$createDeltaLakeParquetFileStatistics$2(String rec$, Object xva$0) {
        return "stringcol%s".formatted(xva$0);
    }

    private static /* synthetic */ String lambda$createDeltaLakeParquetFileStatistics$0(String rec$, Object xva$0) {
        return "intcol%s".formatted(xva$0);
    }

    private static /* synthetic */ String lambda$testReadAddEntriesStatsProjection$1(String rec$, Object xva$0) {
        return "{\"name\":\"stringcol%s\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}}".formatted(xva$0);
    }

    private static /* synthetic */ String lambda$testReadAddEntriesStatsProjection$0(String rec$, Object xva$0) {
        return "{\"name\":\"intcol%s\",\"type\":\"integer\",\"nullable\":true,\"metadata\":{}}".formatted(xva$0);
    }
}

