/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog.checkpoint;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoOutputFile;
import io.trino.filesystem.hdfs.HdfsFileSystemFactory;
import io.trino.parquet.ParquetReaderOptions;
import io.trino.plugin.base.metrics.FileFormatDataSourceStats;
import io.trino.plugin.deltalake.DeltaLakeConfig;
import io.trino.plugin.deltalake.DeltaTestingConnectorSession;
import io.trino.plugin.deltalake.transactionlog.AddFileEntry;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeTransactionLogEntry;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import io.trino.plugin.deltalake.transactionlog.RemoveFileEntry;
import io.trino.plugin.deltalake.transactionlog.TransactionEntry;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointBuilder;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointEntries;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointEntryIterator;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointSchemaManager;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointWriter;
import io.trino.plugin.deltalake.transactionlog.statistics.DeltaLakeFileStatistics;
import io.trino.plugin.deltalake.transactionlog.statistics.DeltaLakeJsonFileStatistics;
import io.trino.plugin.deltalake.transactionlog.statistics.DeltaLakeParquetFileStatistics;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.spi.block.Block;
import io.trino.spi.block.SqlRow;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import io.trino.type.InternalTypeManager;
import io.trino.util.DateTimeUtils;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestCheckpointWriter {
    private final TypeManager typeManager = InternalTypeManager.TESTING_TYPE_MANAGER;
    private final CheckpointSchemaManager checkpointSchemaManager = new CheckpointSchemaManager(this.typeManager);

    @Test
    public void testCheckpointWriteReadJsonRoundtrip() throws IOException {
        MetadataEntry metadataEntry = new MetadataEntry("metadataId", "metadataName", "metadataDescription", new MetadataEntry.Format("metadataFormatProvider", (Map)ImmutableMap.of((Object)"formatOptionX", (Object)"blah", (Object)"fomatOptionY", (Object)"plah")), "{\"type\":\"struct\",\"fields\":[{\"name\":\"part_key\",\"type\":\"double\",\"nullable\":true,\"metadata\":{}},{\"name\":\"ts\",\"type\":\"timestamp\",\"nullable\":true,\"metadata\":{}},{\"name\":\"ts_ntz\",\"type\":\"timestamp_ntz\",\"nullable\":true,\"metadata\":{}},{\"name\":\"str\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}},{\"name\":\"dec_short\",\"type\":\"decimal(5,1)\",\"nullable\":true,\"metadata\":{}},{\"name\":\"dec_long\",\"type\":\"decimal(25,3)\",\"nullable\":true,\"metadata\":{}},{\"name\":\"l\",\"type\":\"long\",\"nullable\":true,\"metadata\":{}},{\"name\":\"in\",\"type\":\"integer\",\"nullable\":true,\"metadata\":{}},{\"name\":\"sh\",\"type\":\"short\",\"nullable\":true,\"metadata\":{}},{\"name\":\"byt\",\"type\":\"byte\",\"nullable\":true,\"metadata\":{}},{\"name\":\"fl\",\"type\":\"float\",\"nullable\":true,\"metadata\":{}},{\"name\":\"dou\",\"type\":\"double\",\"nullable\":true,\"metadata\":{}},{\"name\":\"bool\",\"type\":\"boolean\",\"nullable\":true,\"metadata\":{}},{\"name\":\"bin\",\"type\":\"binary\",\"nullable\":true,\"metadata\":{}},{\"name\":\"dat\",\"type\":\"date\",\"nullable\":true,\"metadata\":{}},{\"name\":\"arr\",\"type\":{\"type\":\"array\",\"elementType\":\"integer\",\"containsNull\":true},\"nullable\":true,\"metadata\":{}},{\"name\":\"m\",\"type\":{\"type\":\"map\",\"keyType\":\"integer\",\"valueType\":\"string\",\"valueContainsNull\":true},\"nullable\":true,\"metadata\":{}},{\"name\":\"row\",\"type\":{\"type\":\"struct\",\"fields\":[{\"name\":\"s1\",\"type\":\"integer\",\"nullable\":true,\"metadata\":{}},{\"name\":\"s2\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}}]},\"nullable\":true,\"metadata\":{}}]}", (List)ImmutableList.of((Object)"part_key"), (Map)ImmutableMap.of((Object)"delta.checkpoint.writeStatsAsStruct", (Object)"false", (Object)"configOption1", (Object)"blah", (Object)"configOption2", (Object)"plah"), 1000L);
        ProtocolEntry protocolEntry = new ProtocolEntry(10, 20, Optional.empty(), Optional.empty());
        TransactionEntry transactionEntry = new TransactionEntry("appId", 1L, 1001L);
        AddFileEntry addFileEntryJsonStats = new AddFileEntry("addFilePathJson", (Map)ImmutableMap.of((Object)"part_key", (Object)"7.0"), 1000L, 1001L, true, Optional.of("{\"numRecords\":20,\"minValues\":{\"ts\":\"2960-10-31T01:00:00.000Z\",\"ts_ntz\":\"2020-01-01T01:02:03.123\",\"str\":\"a\",\"dec_short\":10.1,\"dec_long\":111111111111.123,\"l\":1000000000,\"in\":100000,\"sh\":100,\"byt\":10,\"fl\":0.100,\"dou\":0.101,\"dat\":\"2000-01-01\",\"row\":{\"s1\":1,\"s2\":\"a\"}},\"maxValues\":{\"ts\":\"2960-10-31T02:00:00.000Z\",\"ts_ntz\":\"3000-01-01T01:02:03.123\",\"str\":\"z\",\"dec_short\":20.1,\"dec_long\":222222222222.123,\"l\":2000000000,\"in\":200000,\"sh\":200,\"byt\":20,\"fl\":0.200,\"dou\":0.202,\"dat\":\"3000-01-01\",\"row\":{\"s1\":1,\"s2\":\"a\"}},\"nullCount\":{\"ts\":1,\"str\":2,\"dec_short\":3,\"dec_long\":4,\"l\":5,\"in\":6,\"sh\":7,\"byt\":8,\"fl\":9,\"dou\":10,\"bool\":11,\"bin\":12,\"dat\":13,\"arr\":0,\"m\":14,\"row\":{\"s1\":0,\"s2\":15}}}"), Optional.empty(), (Map)ImmutableMap.of((Object)"someTag", (Object)"someValue", (Object)"otherTag", (Object)"otherValue"), Optional.empty());
        RemoveFileEntry removeFileEntry = new RemoveFileEntry("removeFilePath", (Map)ImmutableMap.of((Object)"part_key", (Object)"7.0"), 1000L, true, Optional.empty());
        CheckpointEntries entries = new CheckpointEntries(metadataEntry, protocolEntry, (Set)ImmutableSet.of((Object)transactionEntry), (Set)ImmutableSet.of((Object)addFileEntryJsonStats), (Set)ImmutableSet.of((Object)removeFileEntry));
        CheckpointWriter writer = new CheckpointWriter(this.typeManager, this.checkpointSchemaManager, "test");
        File targetFile = File.createTempFile("testCheckpointWriteReadRoundtrip-", ".checkpoint.parquet");
        targetFile.deleteOnExit();
        String targetPath = "file://" + targetFile.getAbsolutePath();
        targetFile.delete();
        writer.write(entries, TestCheckpointWriter.createOutputFile(targetPath));
        CheckpointEntries readEntries = this.readCheckpoint(targetPath, metadataEntry, protocolEntry, true);
        Assertions.assertThat((Collection)readEntries.transactionEntries()).isEqualTo((Object)entries.transactionEntries());
        Assertions.assertThat((Collection)readEntries.removeFileEntries()).isEqualTo((Object)entries.removeFileEntries());
        Assertions.assertThat((Object)readEntries.metadataEntry()).isEqualTo((Object)entries.metadataEntry());
        Assertions.assertThat((Object)readEntries.protocolEntry()).isEqualTo((Object)entries.protocolEntry());
        Assertions.assertThat((Collection)((Collection)readEntries.addFileEntries().stream().map(this::makeComparable).collect(ImmutableSet.toImmutableSet()))).isEqualTo(entries.addFileEntries().stream().map(this::makeComparable).collect(ImmutableSet.toImmutableSet()));
    }

    @Test
    public void testCheckpointWriteReadParquetStatisticsRoundtrip() throws IOException {
        MetadataEntry metadataEntry = new MetadataEntry("metadataId", "metadataName", "metadataDescription", new MetadataEntry.Format("metadataFormatProvider", (Map)ImmutableMap.of((Object)"formatOptionX", (Object)"blah", (Object)"fomatOptionY", (Object)"plah")), "{\"type\":\"struct\",\"fields\":[{\"name\":\"part_key\",\"type\":\"double\",\"nullable\":true,\"metadata\":{}},{\"name\":\"ts\",\"type\":\"timestamp\",\"nullable\":true,\"metadata\":{}},{\"name\":\"ts_ntz\",\"type\":\"timestamp_ntz\",\"nullable\":true,\"metadata\":{}},{\"name\":\"str\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}},{\"name\":\"dec_short\",\"type\":\"decimal(5,1)\",\"nullable\":true,\"metadata\":{}},{\"name\":\"dec_long\",\"type\":\"decimal(25,3)\",\"nullable\":true,\"metadata\":{}},{\"name\":\"l\",\"type\":\"long\",\"nullable\":true,\"metadata\":{}},{\"name\":\"in\",\"type\":\"integer\",\"nullable\":true,\"metadata\":{}},{\"name\":\"sh\",\"type\":\"short\",\"nullable\":true,\"metadata\":{}},{\"name\":\"byt\",\"type\":\"byte\",\"nullable\":true,\"metadata\":{}},{\"name\":\"fl\",\"type\":\"float\",\"nullable\":true,\"metadata\":{}},{\"name\":\"dou\",\"type\":\"double\",\"nullable\":true,\"metadata\":{}},{\"name\":\"bool\",\"type\":\"boolean\",\"nullable\":true,\"metadata\":{}},{\"name\":\"bin\",\"type\":\"binary\",\"nullable\":true,\"metadata\":{}},{\"name\":\"dat\",\"type\":\"date\",\"nullable\":true,\"metadata\":{}},{\"name\":\"arr\",\"type\":{\"type\":\"array\",\"elementType\":\"integer\",\"containsNull\":true},\"nullable\":true,\"metadata\":{}},{\"name\":\"m\",\"type\":{\"type\":\"map\",\"keyType\":\"integer\",\"valueType\":\"string\",\"valueContainsNull\":true},\"nullable\":true,\"metadata\":{}},{\"name\":\"row\",\"type\":{\"type\":\"struct\",\"fields\":[{\"name\":\"s1\",\"type\":\"integer\",\"nullable\":true,\"metadata\":{}},{\"name\":\"s2\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}}]},\"nullable\":true,\"metadata\":{}}]}", (List)ImmutableList.of((Object)"part_key"), (Map)ImmutableMap.of((Object)"configOption1", (Object)"blah", (Object)"configOption2", (Object)"plah"), 1000L);
        ProtocolEntry protocolEntry = new ProtocolEntry(10, 20, Optional.empty(), Optional.empty());
        TransactionEntry transactionEntry = new TransactionEntry("appId", 1L, 1001L);
        Block[] minMaxRowFieldBlocks = new Block[]{Utils.nativeValueToBlock((Type)IntegerType.INTEGER, (Object)1L), Utils.nativeValueToBlock((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"a"))};
        Block[] nullCountRowFieldBlocks = new Block[]{Utils.nativeValueToBlock((Type)BigintType.BIGINT, (Object)0L), Utils.nativeValueToBlock((Type)BigintType.BIGINT, (Object)15L)};
        AddFileEntry addFileEntryParquetStats = new AddFileEntry("addFilePathParquet", (Map)ImmutableMap.of((Object)"part_key", (Object)"7.0"), 1000L, 1001L, true, Optional.empty(), Optional.of(new DeltaLakeParquetFileStatistics(Optional.of(5L), Optional.of(ImmutableMap.builder().put((Object)"ts", (Object)DateTimeUtils.convertToTimestampWithTimeZone((TimeZoneKey)TimeZoneKey.UTC_KEY, (String)"2060-10-31 01:00:00")).put((Object)"ts_ntz", (Object)TestCheckpointWriter.convertToTimestamp("2060-10-31T01:00:00.123")).put((Object)"str", (Object)Slices.utf8Slice((String)"a")).put((Object)"dec_short", (Object)101L).put((Object)"dec_long", (Object)Int128.valueOf((long)111111111111123L)).put((Object)"l", (Object)1000000000L).put((Object)"in", (Object)100000L).put((Object)"sh", (Object)100L).put((Object)"byt", (Object)10L).put((Object)"fl", (Object)Float.floatToIntBits(0.1f)).put((Object)"dou", (Object)0.101).put((Object)"dat", (Object)DateTimeUtils.parseDate((String)"2000-01-01")).put((Object)"row", (Object)new SqlRow(0, minMaxRowFieldBlocks)).buildOrThrow()), Optional.of(ImmutableMap.builder().put((Object)"ts", (Object)DateTimeUtils.convertToTimestampWithTimeZone((TimeZoneKey)TimeZoneKey.UTC_KEY, (String)"2060-10-31 02:00:00")).put((Object)"ts_ntz", (Object)TestCheckpointWriter.convertToTimestamp("2060-10-31T02:00:00.123")).put((Object)"str", (Object)Slices.utf8Slice((String)"a")).put((Object)"dec_short", (Object)201L).put((Object)"dec_long", (Object)Int128.valueOf((long)222222222222123L)).put((Object)"l", (Object)2000000000L).put((Object)"in", (Object)200000L).put((Object)"sh", (Object)200L).put((Object)"byt", (Object)20L).put((Object)"fl", (Object)Float.floatToIntBits(0.2f)).put((Object)"dou", (Object)0.202).put((Object)"dat", (Object)DateTimeUtils.parseDate((String)"3000-01-01")).put((Object)"row", (Object)new SqlRow(0, minMaxRowFieldBlocks)).buildOrThrow()), Optional.of(ImmutableMap.builder().put((Object)"ts", (Object)1L).put((Object)"ts_ntz", (Object)16L).put((Object)"str", (Object)2L).put((Object)"dec_short", (Object)3L).put((Object)"dec_long", (Object)4L).put((Object)"l", (Object)5L).put((Object)"in", (Object)6L).put((Object)"sh", (Object)7L).put((Object)"byt", (Object)8L).put((Object)"fl", (Object)9L).put((Object)"dou", (Object)10L).put((Object)"bool", (Object)11L).put((Object)"bin", (Object)12L).put((Object)"dat", (Object)13L).put((Object)"arr", (Object)14L).put((Object)"row", (Object)new SqlRow(0, nullCountRowFieldBlocks)).buildOrThrow()))), (Map)ImmutableMap.of((Object)"someTag", (Object)"someValue", (Object)"otherTag", (Object)"otherValue"), Optional.empty());
        RemoveFileEntry removeFileEntry = new RemoveFileEntry("removeFilePath", (Map)ImmutableMap.of((Object)"part_key", (Object)"7.0"), 1000L, true, Optional.empty());
        CheckpointEntries entries = new CheckpointEntries(metadataEntry, protocolEntry, (Set)ImmutableSet.of((Object)transactionEntry), (Set)ImmutableSet.of((Object)addFileEntryParquetStats), (Set)ImmutableSet.of((Object)removeFileEntry));
        CheckpointWriter writer = new CheckpointWriter(this.typeManager, this.checkpointSchemaManager, "test");
        File targetFile = File.createTempFile("testCheckpointWriteReadRoundtrip-", ".checkpoint.parquet");
        targetFile.deleteOnExit();
        String targetPath = "file://" + targetFile.getAbsolutePath();
        targetFile.delete();
        writer.write(entries, TestCheckpointWriter.createOutputFile(targetPath));
        CheckpointEntries readEntries = this.readCheckpoint(targetPath, metadataEntry, protocolEntry, true);
        Assertions.assertThat((Collection)readEntries.transactionEntries()).isEqualTo((Object)entries.transactionEntries());
        Assertions.assertThat((Collection)readEntries.removeFileEntries()).isEqualTo((Object)entries.removeFileEntries());
        Assertions.assertThat((Object)readEntries.metadataEntry()).isEqualTo((Object)entries.metadataEntry());
        Assertions.assertThat((Object)readEntries.protocolEntry()).isEqualTo((Object)entries.protocolEntry());
        Assertions.assertThat((Collection)((Collection)readEntries.addFileEntries().stream().map(this::makeComparable).collect(ImmutableSet.toImmutableSet()))).isEqualTo(entries.addFileEntries().stream().map(this::makeComparable).collect(ImmutableSet.toImmutableSet()));
    }

    private static long convertToTimestamp(String value) {
        LocalDateTime localDateTime = LocalDateTime.parse(value);
        return localDateTime.toEpochSecond(ZoneOffset.UTC) * 1000000L + (long)(localDateTime.getNano() / 1000);
    }

    @Test
    public void testDisablingRowStatistics() throws IOException {
        MetadataEntry metadataEntry = new MetadataEntry("metadataId", "metadataName", "metadataDescription", new MetadataEntry.Format("metadataFormatProvider", (Map)ImmutableMap.of((Object)"formatOptionX", (Object)"blah", (Object)"fomatOptionY", (Object)"plah")), "{\"type\":\"struct\",\"fields\":[{\"name\":\"part_key\",\"type\":\"double\",\"nullable\":true,\"metadata\":{}},{\"name\":\"row\",\"type\":{\"type\":\"struct\",\"fields\":[{\"name\":\"s1\",\"type\":\"integer\",\"nullable\":true,\"metadata\":{}},{\"name\":\"s2\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}}]},\"nullable\":true,\"metadata\":{}}]}", (List)ImmutableList.of((Object)"part_key"), (Map)ImmutableMap.of(), 1000L);
        ProtocolEntry protocolEntry = new ProtocolEntry(10, 20, Optional.empty(), Optional.empty());
        Block[] minMaxRowFieldBlocks = new Block[]{Utils.nativeValueToBlock((Type)IntegerType.INTEGER, (Object)1L), Utils.nativeValueToBlock((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"a"))};
        Block[] nullCountRowFieldBlocks = new Block[]{Utils.nativeValueToBlock((Type)BigintType.BIGINT, (Object)0L), Utils.nativeValueToBlock((Type)BigintType.BIGINT, (Object)15L)};
        AddFileEntry addFileEntryParquetStats = new AddFileEntry("addFilePathParquet", (Map)ImmutableMap.of((Object)"part_key", (Object)"7.0"), 1000L, 1001L, true, Optional.empty(), Optional.of(new DeltaLakeParquetFileStatistics(Optional.of(5L), Optional.of(ImmutableMap.of((Object)"row", (Object)new SqlRow(0, minMaxRowFieldBlocks))), Optional.of(ImmutableMap.of((Object)"row", (Object)new SqlRow(0, minMaxRowFieldBlocks))), Optional.of(ImmutableMap.of((Object)"row", (Object)new SqlRow(0, nullCountRowFieldBlocks))))), (Map)ImmutableMap.of(), Optional.empty());
        CheckpointEntries entries = new CheckpointEntries(metadataEntry, protocolEntry, (Set)ImmutableSet.of(), (Set)ImmutableSet.of((Object)addFileEntryParquetStats), (Set)ImmutableSet.of());
        CheckpointWriter writer = new CheckpointWriter(this.typeManager, this.checkpointSchemaManager, "test");
        File targetFile = File.createTempFile("testCheckpointWriteReadRoundtrip-", ".checkpoint.parquet");
        targetFile.deleteOnExit();
        String targetPath = "file://" + targetFile.getAbsolutePath();
        targetFile.delete();
        writer.write(entries, TestCheckpointWriter.createOutputFile(targetPath));
        CheckpointEntries readEntries = this.readCheckpoint(targetPath, metadataEntry, protocolEntry, false);
        AddFileEntry addFileEntry = (AddFileEntry)Iterables.getOnlyElement((Iterable)readEntries.addFileEntries());
        Assertions.assertThat((Optional)addFileEntry.getStats()).isPresent();
        DeltaLakeParquetFileStatistics fileStatistics = (DeltaLakeParquetFileStatistics)addFileEntry.getStats().get();
        Assertions.assertThat((Map)((Map)fileStatistics.getMinValues().get())).isEmpty();
        Assertions.assertThat((Map)((Map)fileStatistics.getMaxValues().get())).isEmpty();
        Assertions.assertThat((Map)((Map)fileStatistics.getNullCount().get())).isEmpty();
    }

    private AddFileEntry makeComparable(AddFileEntry original) {
        return new AddFileEntry(original.getPath(), original.getPartitionValues(), original.getSize(), original.getModificationTime(), original.isDataChange(), original.getStatsString(), this.makeComparable(original.getStats()), original.getTags(), original.getDeletionVector());
    }

    private Optional<DeltaLakeParquetFileStatistics> makeComparable(Optional<? extends DeltaLakeFileStatistics> original) {
        if (original.isEmpty() || original.get() instanceof DeltaLakeJsonFileStatistics) {
            return Optional.empty();
        }
        DeltaLakeParquetFileStatistics originalStatistics = (DeltaLakeParquetFileStatistics)original.get();
        return Optional.of(new DeltaLakeParquetFileStatistics(originalStatistics.getNumRecords(), this.makeComparableStatistics(originalStatistics.getMinValues()), this.makeComparableStatistics(originalStatistics.getMaxValues()), this.makeComparableStatistics(originalStatistics.getNullCount())));
    }

    private Optional<Map<String, Object>> makeComparableStatistics(Optional<Map<String, Object>> original) {
        if (original.isEmpty()) {
            return Optional.empty();
        }
        Map<String, Object> stats = original.get();
        ImmutableMap.Builder comparableStats = ImmutableMap.builder();
        for (String key : stats.keySet()) {
            Object statsValue = stats.get(key);
            if (statsValue instanceof SqlRow) {
                SqlRow sqlRow = (SqlRow)statsValue;
                List logicalSizes = (List)sqlRow.getRawFieldBlocks().stream().map(block -> block.getUnderlyingValueBlock().getClass().getName()).collect(ImmutableList.toImmutableList());
                comparableStats.put((Object)key, (Object)logicalSizes);
                continue;
            }
            if (statsValue instanceof Slice) {
                Slice slice = (Slice)statsValue;
                comparableStats.put((Object)key, (Object)slice.toStringUtf8());
                continue;
            }
            comparableStats.put((Object)key, statsValue);
        }
        return Optional.of(comparableStats.buildOrThrow());
    }

    private CheckpointEntries readCheckpoint(String checkpointPath, MetadataEntry metadataEntry, ProtocolEntry protocolEntry, boolean rowStatisticsEnabled) throws IOException {
        TrinoFileSystem fileSystem = new HdfsFileSystemFactory(HiveTestUtils.HDFS_ENVIRONMENT, HiveTestUtils.HDFS_FILE_SYSTEM_STATS).create(DeltaTestingConnectorSession.SESSION);
        TrinoInputFile checkpointFile = fileSystem.newInputFile(Location.of((String)checkpointPath));
        CheckpointEntryIterator checkpointEntryIterator = new CheckpointEntryIterator(checkpointFile, DeltaTestingConnectorSession.SESSION, checkpointFile.length(), this.checkpointSchemaManager, this.typeManager, (Set)ImmutableSet.of((Object)CheckpointEntryIterator.EntryType.METADATA, (Object)CheckpointEntryIterator.EntryType.PROTOCOL, (Object)CheckpointEntryIterator.EntryType.TRANSACTION, (Object)CheckpointEntryIterator.EntryType.ADD, (Object)CheckpointEntryIterator.EntryType.REMOVE), Optional.of(metadataEntry), Optional.of(protocolEntry), new FileFormatDataSourceStats(), ParquetReaderOptions.defaultOptions(), rowStatisticsEnabled, new DeltaLakeConfig().getDomainCompactionThreshold(), TupleDomain.all(), Optional.of(Predicates.alwaysTrue()));
        CheckpointBuilder checkpointBuilder = new CheckpointBuilder();
        while (checkpointEntryIterator.hasNext()) {
            DeltaLakeTransactionLogEntry entry = (DeltaLakeTransactionLogEntry)checkpointEntryIterator.next();
            checkpointBuilder.addLogEntry(entry);
        }
        return checkpointBuilder.build();
    }

    private static TrinoOutputFile createOutputFile(String path) {
        return new HdfsFileSystemFactory(HiveTestUtils.HDFS_ENVIRONMENT, HiveTestUtils.HDFS_FILE_SYSTEM_STATS).create(DeltaTestingConnectorSession.SESSION).newOutputFile(Location.of((String)path));
    }
}

