/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog.checkpoint;

import io.airlift.units.DataSize;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.hdfs.HdfsFileSystemFactory;
import io.trino.plugin.deltalake.DeltaLakeConfig;
import io.trino.plugin.deltalake.DeltaTestingConnectorSession;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeTransactionLogEntry;
import io.trino.plugin.deltalake.transactionlog.checkpoint.TransactionLogTail;
import io.trino.plugin.hive.HiveTestUtils;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTransactionLogTail {
    @Test
    public void testTail() throws Exception {
        this.testTail("databricks73");
        this.testTail("deltalake");
    }

    private void testTail(String dataSource) throws Exception {
        String tableLocation = this.getClass().getClassLoader().getResource(String.format("%s/person", dataSource)).toURI().toString();
        Assertions.assertThat(this.readJsonTransactionLogTails(tableLocation)).hasSize(7);
        Assertions.assertThat(this.updateJsonTransactionLogTails(tableLocation)).hasSize(7);
    }

    private List<DeltaLakeTransactionLogEntry> updateJsonTransactionLogTails(String tableLocation) throws Exception {
        TrinoFileSystem fileSystem = new HdfsFileSystemFactory(HiveTestUtils.HDFS_ENVIRONMENT, HiveTestUtils.HDFS_FILE_SYSTEM_STATS).create(DeltaTestingConnectorSession.SESSION);
        TransactionLogTail transactionLogTail = TransactionLogTail.loadNewTail((TrinoFileSystem)fileSystem, (String)tableLocation, Optional.of(10L), Optional.of(12L), (DataSize)DeltaLakeConfig.DEFAULT_TRANSACTION_LOG_MAX_CACHED_SIZE);
        Optional updatedLogTail = transactionLogTail.getUpdatedTail(fileSystem, tableLocation, Optional.empty(), DeltaLakeConfig.DEFAULT_TRANSACTION_LOG_MAX_CACHED_SIZE);
        Assertions.assertThat((Optional)updatedLogTail).isPresent();
        return ((TransactionLogTail)updatedLogTail.get()).getFileEntries(fileSystem);
    }

    private List<DeltaLakeTransactionLogEntry> readJsonTransactionLogTails(String tableLocation) throws Exception {
        TrinoFileSystem fileSystem = new HdfsFileSystemFactory(HiveTestUtils.HDFS_ENVIRONMENT, HiveTestUtils.HDFS_FILE_SYSTEM_STATS).create(DeltaTestingConnectorSession.SESSION);
        TransactionLogTail transactionLogTail = TransactionLogTail.loadNewTail((TrinoFileSystem)fileSystem, (String)tableLocation, Optional.of(10L), Optional.empty(), (DataSize)DeltaLakeConfig.DEFAULT_TRANSACTION_LOG_MAX_CACHED_SIZE);
        return transactionLogTail.getFileEntries(fileSystem);
    }
}

