/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog.statistics;

import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnType;
import io.trino.plugin.deltalake.transactionlog.statistics.DeltaLakeFileStatistics;
import io.trino.plugin.deltalake.transactionlog.statistics.DeltaLakeJsonFileStatistics;
import io.trino.plugin.deltalake.transactionlog.statistics.DeltaLakeParquetFileStatistics;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.results.format.ResultFormatType;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Benchmark)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@Warmup(iterations=4)
@Fork(value=1)
@Measurement(iterations=10)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkExtendedStatistics {
    @Benchmark
    public long benchmark(BenchmarkData benchmarkData) {
        long result = 1L;
        for (DeltaLakeFileStatistics statistics : benchmarkData.fileStatistics) {
            for (int i = 0; i < benchmarkData.queries; ++i) {
                DeltaLakeColumnHandle column = benchmarkData.columns.get(benchmarkData.random.nextInt(benchmarkData.columnsCount));
                result += ((Long)statistics.getMaxColumnValue(column).get()).longValue();
                result += ((Long)statistics.getMinColumnValue(column).get()).longValue();
                result += ((Long)statistics.getNullCount(column.baseColumnName()).get()).longValue();
            }
        }
        return result;
    }

    @Test
    public void testBenchmark() {
        BenchmarkData benchmarkData = new BenchmarkData();
        benchmarkData.setup();
        this.benchmark(benchmarkData);
    }

    public static void main(String[] args) throws Exception {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkExtendedStatistics.class.getSimpleName() + ".*").resultFormat(ResultFormatType.JSON).result(String.format("%s/%s-result-%s.json", System.getProperty("java.io.tmpdir"), BenchmarkExtendedStatistics.class.getSimpleName(), DateTimeFormatter.ISO_DATE_TIME.format(LocalDateTime.now()))).build();
        new Runner(options).run();
    }

    @State(value=Scope.Benchmark)
    public static class BenchmarkData {
        @Param(value={"JSON", "PARQUET"})
        private String type = "JSON";
        @Param(value={"200"})
        private int filesCount = 200;
        @Param(value={"5", "10", "20", "50", "200"})
        private int columnsCount = 5;
        @Param(value={"100"})
        private int queries = 100;
        private Random random = new Random(1L);
        private List<DeltaLakeColumnHandle> columns;
        private List<DeltaLakeFileStatistics> fileStatistics;

        @Setup
        public void setup() {
            int i;
            this.columns = new ArrayList<DeltaLakeColumnHandle>(this.columnsCount);
            for (i = 0; i < this.columnsCount; ++i) {
                this.columns.add(new DeltaLakeColumnHandle("column_" + i, (Type)BigintType.BIGINT, OptionalInt.empty(), "column_" + i, (Type)BigintType.BIGINT, DeltaLakeColumnType.REGULAR, Optional.empty()));
            }
            this.fileStatistics = new ArrayList<DeltaLakeFileStatistics>(this.filesCount);
            for (i = 0; i < this.filesCount; ++i) {
                this.fileStatistics.add(this.createSingleFileStatistics());
            }
        }

        private DeltaLakeFileStatistics createSingleFileStatistics() {
            switch (this.type) {
                case "JSON": {
                    return new DeltaLakeJsonFileStatistics(Optional.of(this.random.nextLong()), this.createColumnValueMap(), this.createColumnValueMap(), this.createColumnValueMap());
                }
                case "PARQUET": {
                    return new DeltaLakeParquetFileStatistics(Optional.of(this.random.nextLong()), this.createColumnValueMap(), this.createColumnValueMap(), this.createColumnValueMap());
                }
            }
            throw new IllegalArgumentException("invalid stats type: " + this.type);
        }

        private Optional<Map<String, Object>> createColumnValueMap() {
            HashMap<String, Long> map = new HashMap<String, Long>();
            for (DeltaLakeColumnHandle column : this.columns) {
                map.put(column.baseColumnName(), this.random.nextLong());
            }
            return Optional.of(map);
        }
    }
}

