/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog.statistics;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.Slices;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.local.LocalInputFile;
import io.trino.parquet.ParquetReaderOptions;
import io.trino.plugin.base.metrics.FileFormatDataSourceStats;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnType;
import io.trino.plugin.deltalake.DeltaLakeConfig;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeTransactionLogEntry;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointEntryIterator;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointSchemaManager;
import io.trino.plugin.deltalake.transactionlog.statistics.DeltaLakeFileStatistics;
import io.trino.plugin.deltalake.transactionlog.statistics.DeltaLakeJsonFileStatistics;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.testing.TestingConnectorSession;
import io.trino.type.InternalTypeManager;
import java.io.File;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Iterator;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDeltaLakeFileStatistics {
    private final ObjectMapper objectMapper = new ObjectMapperProvider().get();

    @Test
    public void testParseJsonStatistics() throws Exception {
        File statsFile = new File(this.getClass().getResource("all_type_statistics.json").toURI());
        DeltaLakeFileStatistics fileStatistics = (DeltaLakeFileStatistics)this.objectMapper.readValue(statsFile, DeltaLakeJsonFileStatistics.class);
        TestDeltaLakeFileStatistics.testStatisticsValues(fileStatistics);
    }

    @Test
    public void testParseParquetStatistics() throws Exception {
        File statsFile = new File(this.getClass().getResource("/databricks73/pruning/parquet_struct_statistics/_delta_log/00000000000000000010.checkpoint.parquet").toURI());
        TypeManager typeManager = InternalTypeManager.TESTING_TYPE_MANAGER;
        CheckpointSchemaManager checkpointSchemaManager = new CheckpointSchemaManager(typeManager);
        LocalInputFile checkpointFile = new LocalInputFile(statsFile);
        CheckpointEntryIterator metadataEntryIterator = new CheckpointEntryIterator((TrinoInputFile)checkpointFile, TestingConnectorSession.SESSION, checkpointFile.length(), checkpointSchemaManager, typeManager, (Set)ImmutableSet.of((Object)CheckpointEntryIterator.EntryType.METADATA), Optional.empty(), Optional.empty(), new FileFormatDataSourceStats(), ParquetReaderOptions.defaultOptions(), true, new DeltaLakeConfig().getDomainCompactionThreshold(), TupleDomain.all(), Optional.empty());
        MetadataEntry metadataEntry = ((DeltaLakeTransactionLogEntry)Iterators.getOnlyElement((Iterator)metadataEntryIterator)).getMetaData();
        CheckpointEntryIterator protocolEntryIterator = new CheckpointEntryIterator((TrinoInputFile)checkpointFile, TestingConnectorSession.SESSION, checkpointFile.length(), checkpointSchemaManager, typeManager, (Set)ImmutableSet.of((Object)CheckpointEntryIterator.EntryType.PROTOCOL), Optional.empty(), Optional.empty(), new FileFormatDataSourceStats(), ParquetReaderOptions.defaultOptions(), true, new DeltaLakeConfig().getDomainCompactionThreshold(), TupleDomain.all(), Optional.empty());
        ProtocolEntry protocolEntry = ((DeltaLakeTransactionLogEntry)Iterators.getOnlyElement((Iterator)protocolEntryIterator)).getProtocol();
        CheckpointEntryIterator checkpointEntryIterator = new CheckpointEntryIterator((TrinoInputFile)checkpointFile, TestingConnectorSession.SESSION, checkpointFile.length(), checkpointSchemaManager, typeManager, (Set)ImmutableSet.of((Object)CheckpointEntryIterator.EntryType.ADD), Optional.of(metadataEntry), Optional.of(protocolEntry), new FileFormatDataSourceStats(), ParquetReaderOptions.defaultOptions(), true, new DeltaLakeConfig().getDomainCompactionThreshold(), TupleDomain.all(), Optional.of(Predicates.alwaysTrue()));
        DeltaLakeTransactionLogEntry matchingAddFileEntry = null;
        while (checkpointEntryIterator.hasNext()) {
            DeltaLakeTransactionLogEntry entry = (DeltaLakeTransactionLogEntry)checkpointEntryIterator.next();
            if (entry.getAdd() == null || !entry.getAdd().getPath().contains("part-00000-17951bea-0d04-43c1-979c-ea1fac19b382-c000.snappy.parquet")) continue;
            Assertions.assertThat(matchingAddFileEntry).isNull();
            matchingAddFileEntry = entry;
        }
        Assertions.assertThat(matchingAddFileEntry).isNotNull();
        Assertions.assertThat((Optional)matchingAddFileEntry.getAdd().getStats()).isPresent();
        TestDeltaLakeFileStatistics.testStatisticsValues((DeltaLakeFileStatistics)matchingAddFileEntry.getAdd().getStats().get());
    }

    private static void testStatisticsValues(DeltaLakeFileStatistics fileStatistics) {
        Assertions.assertThat((Optional)fileStatistics.getNumRecords()).isEqualTo(Optional.of(1L));
        Assertions.assertThat((Optional)fileStatistics.getMinColumnValue(new DeltaLakeColumnHandle("byt", (Type)TinyintType.TINYINT, OptionalInt.empty(), "byt", (Type)TinyintType.TINYINT, DeltaLakeColumnType.REGULAR, Optional.empty()))).isEqualTo(Optional.of(42L));
        Assertions.assertThat((Optional)fileStatistics.getMinColumnValue(new DeltaLakeColumnHandle("dat", (Type)DateType.DATE, OptionalInt.empty(), "dat", (Type)DateType.DATE, DeltaLakeColumnType.REGULAR, Optional.empty()))).isEqualTo(Optional.of(LocalDate.parse("5000-01-01").toEpochDay()));
        Assertions.assertThat((Optional)fileStatistics.getMinColumnValue(new DeltaLakeColumnHandle("dec_long", (Type)DecimalType.createDecimalType((int)25, (int)3), OptionalInt.empty(), "dec_long", (Type)DecimalType.createDecimalType((int)25, (int)3), DeltaLakeColumnType.REGULAR, Optional.empty()))).isEqualTo(Optional.of(Decimals.encodeScaledValue((BigDecimal)new BigDecimal("999999999999.123"), (int)3)));
        Assertions.assertThat((Optional)fileStatistics.getMinColumnValue(new DeltaLakeColumnHandle("dec_short", (Type)DecimalType.createDecimalType((int)5, (int)1), OptionalInt.empty(), "dec_short", (Type)DecimalType.createDecimalType((int)5, (int)1), DeltaLakeColumnType.REGULAR, Optional.empty()))).isEqualTo(Optional.of(new BigDecimal("10.1").unscaledValue().longValueExact()));
        Assertions.assertThat((Optional)fileStatistics.getMinColumnValue(new DeltaLakeColumnHandle("dou", (Type)DoubleType.DOUBLE, OptionalInt.empty(), "dou", (Type)DoubleType.DOUBLE, DeltaLakeColumnType.REGULAR, Optional.empty()))).isEqualTo(Optional.of(0.321));
        Assertions.assertThat((Optional)fileStatistics.getMinColumnValue(new DeltaLakeColumnHandle("fl", (Type)RealType.REAL, OptionalInt.empty(), "fl", (Type)RealType.REAL, DeltaLakeColumnType.REGULAR, Optional.empty()))).isEqualTo(Optional.of(Long.valueOf(Float.floatToIntBits(0.123f))));
        Assertions.assertThat((Optional)fileStatistics.getMinColumnValue(new DeltaLakeColumnHandle("in", (Type)IntegerType.INTEGER, OptionalInt.empty(), "in", (Type)IntegerType.INTEGER, DeltaLakeColumnType.REGULAR, Optional.empty()))).isEqualTo(Optional.of(20000000L));
        Assertions.assertThat((Optional)fileStatistics.getMinColumnValue(new DeltaLakeColumnHandle("l", (Type)BigintType.BIGINT, OptionalInt.empty(), "l", (Type)BigintType.BIGINT, DeltaLakeColumnType.REGULAR, Optional.empty()))).isEqualTo(Optional.of(10000000L));
        RowType rowType = RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"s1", (Type)IntegerType.INTEGER), RowType.field((String)"s3", (Type)VarcharType.createUnboundedVarcharType())});
        Assertions.assertThat((Optional)fileStatistics.getMinColumnValue(new DeltaLakeColumnHandle("row", (Type)rowType, OptionalInt.empty(), "row", (Type)rowType, DeltaLakeColumnType.REGULAR, Optional.empty()))).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)fileStatistics.getMinColumnValue(new DeltaLakeColumnHandle("arr", (Type)new ArrayType((Type)IntegerType.INTEGER), OptionalInt.empty(), "arr", (Type)new ArrayType((Type)IntegerType.INTEGER), DeltaLakeColumnType.REGULAR, Optional.empty()))).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)fileStatistics.getMinColumnValue(new DeltaLakeColumnHandle("m", (Type)new MapType((Type)IntegerType.INTEGER, (Type)VarcharType.createUnboundedVarcharType(), new TypeOperators()), OptionalInt.empty(), "m", (Type)new MapType((Type)IntegerType.INTEGER, (Type)VarcharType.createUnboundedVarcharType(), new TypeOperators()), DeltaLakeColumnType.REGULAR, Optional.empty()))).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)fileStatistics.getMinColumnValue(new DeltaLakeColumnHandle("sh", (Type)SmallintType.SMALLINT, OptionalInt.empty(), "sh", (Type)SmallintType.SMALLINT, DeltaLakeColumnType.REGULAR, Optional.empty()))).isEqualTo(Optional.of(123L));
        Assertions.assertThat((Optional)fileStatistics.getMinColumnValue(new DeltaLakeColumnHandle("str", (Type)VarcharType.createUnboundedVarcharType(), OptionalInt.empty(), "str", (Type)VarcharType.createUnboundedVarcharType(), DeltaLakeColumnType.REGULAR, Optional.empty()))).isEqualTo(Optional.of(Slices.utf8Slice((String)"a")));
        Assertions.assertThat((Optional)fileStatistics.getMinColumnValue(new DeltaLakeColumnHandle("ts", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, OptionalInt.empty(), "ts", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, DeltaLakeColumnType.REGULAR, Optional.empty()))).isEqualTo(Optional.of(DateTimeEncoding.packDateTimeWithZone((long)LocalDateTime.parse("2960-10-31T01:00:00.000").toInstant(ZoneOffset.UTC).toEpochMilli(), (TimeZoneKey)TimeZoneKey.UTC_KEY)));
        Assertions.assertThat((Optional)fileStatistics.getMinColumnValue(new DeltaLakeColumnHandle("bool", (Type)BooleanType.BOOLEAN, OptionalInt.empty(), "bool", (Type)BooleanType.BOOLEAN, DeltaLakeColumnType.REGULAR, Optional.empty()))).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)fileStatistics.getMinColumnValue(new DeltaLakeColumnHandle("bin", (Type)VarbinaryType.VARBINARY, OptionalInt.empty(), "bin", (Type)VarbinaryType.VARBINARY, DeltaLakeColumnType.REGULAR, Optional.empty()))).isEqualTo(Optional.empty());
    }
}

