/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.util;

import io.trino.plugin.deltalake.util.DeltaLakeWriteUtils;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.SqlDecimal;
import java.math.BigDecimal;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDeltaLakeWriteUtils {
    @Test
    public void testCreatePartitionValuesDecimal() {
        TestDeltaLakeWriteUtils.assertCreatePartitionValuesDecimal(10, 0, "12345", "12345");
        TestDeltaLakeWriteUtils.assertCreatePartitionValuesDecimal(10, 2, "123.45", "123.45");
        TestDeltaLakeWriteUtils.assertCreatePartitionValuesDecimal(10, 2, "12345.00", "12345");
        TestDeltaLakeWriteUtils.assertCreatePartitionValuesDecimal(5, 0, "12345", "12345");
        TestDeltaLakeWriteUtils.assertCreatePartitionValuesDecimal(38, 2, "12345.00", "12345");
        TestDeltaLakeWriteUtils.assertCreatePartitionValuesDecimal(38, 20, "12345.00000000000000000000", "12345");
        TestDeltaLakeWriteUtils.assertCreatePartitionValuesDecimal(38, 20, "12345.67898000000000000000", "12345.67898");
    }

    private static void assertCreatePartitionValuesDecimal(int precision, int scale, String decimalValue, String expectedValue) {
        DecimalType decimalType = DecimalType.createDecimalType((int)precision, (int)scale);
        List<DecimalType> types = List.of(decimalType);
        SqlDecimal decimal = SqlDecimal.decimal((String)decimalValue, (DecimalType)decimalType);
        Assertions.assertThat((String)decimal.toString()).isEqualTo(decimalValue);
        Assertions.assertThat((String)decimal.toBigDecimal().toString()).isEqualTo(decimalValue);
        PageBuilder pageBuilder = new PageBuilder(types);
        pageBuilder.declarePosition();
        TestDeltaLakeWriteUtils.writeDecimal(decimalType, decimal, pageBuilder.getBlockBuilder(0));
        Page page = pageBuilder.build();
        Assertions.assertThat((List)DeltaLakeWriteUtils.createPartitionValues(types, (Page)page, (int)0)).isEqualTo(List.of(expectedValue));
    }

    private static void writeDecimal(DecimalType decimalType, SqlDecimal decimal, BlockBuilder blockBuilder) {
        if (decimalType.isShort()) {
            Decimals.writeShortDecimal((BlockBuilder)blockBuilder, (long)decimal.toBigDecimal().unscaledValue().longValue());
        } else {
            Decimals.writeBigDecimal((DecimalType)decimalType, (BlockBuilder)blockBuilder, (BigDecimal)decimal.toBigDecimal());
        }
    }
}

