/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.MoreCollectors;
import io.airlift.units.DataSize;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.deltalake.DeltaLakeErrorCode;
import io.trino.plugin.deltalake.DeltaLakeTableName;
import io.trino.plugin.deltalake.transactionlog.TableSnapshot;
import io.trino.plugin.deltalake.transactionlog.Transaction;
import io.trino.plugin.deltalake.transactionlog.TransactionLogAccess;
import io.trino.plugin.deltalake.transactionlog.TransactionLogEntries;
import io.trino.plugin.deltalake.transactionlog.TransactionLogUtil;
import io.trino.plugin.deltalake.transactionlog.checkpoint.TransactionLogTail;
import io.trino.plugin.deltalake.util.PageListBuilder;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.EmptyPageSource;
import io.trino.spi.connector.FixedPageSource;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.TypeManager;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SequencedCollection;
import java.util.stream.IntStream;

public abstract class BaseTransactionsTable
implements SystemTable {
    private final SchemaTableName tableName;
    private final String tableLocation;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final TransactionLogAccess transactionLogAccess;
    private final ConnectorTableMetadata tableMetadata;

    public BaseTransactionsTable(SchemaTableName tableName, String tableLocation, TrinoFileSystemFactory fileSystemFactory, TransactionLogAccess transactionLogAccess, TypeManager typeManager, ConnectorTableMetadata tableMetadata) {
        Objects.requireNonNull(typeManager, "typeManager is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.tableLocation = Objects.requireNonNull(tableLocation, "tableLocation is null");
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.transactionLogAccess = Objects.requireNonNull(transactionLogAccess, "transactionLogAccess is null");
        this.tableMetadata = Objects.requireNonNull(tableMetadata, "tableMetadata is null");
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    public ConnectorPageSource pageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        Map domains;
        long snapshotVersion;
        try {
            SchemaTableName baseTableName = new SchemaTableName(this.tableName.getSchemaName(), DeltaLakeTableName.tableNameFrom(this.tableName.getTableName()));
            TableSnapshot tableSnapshot = this.transactionLogAccess.loadSnapshot(session, baseTableName, this.tableLocation, Optional.empty());
            snapshotVersion = tableSnapshot.getVersion();
            this.transactionLogAccess.getMetadataEntry(session, tableSnapshot);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, "Unable to load table metadata from location: " + this.tableLocation, (Throwable)e);
        }
        int versionColumnIndex = (Integer)IntStream.range(0, this.tableMetadata.getColumns().size()).filter(i -> ((ColumnMetadata)this.tableMetadata.getColumns().get(i)).getName().equals("version")).boxed().collect(MoreCollectors.onlyElement());
        Optional<Long> startVersionExclusive = Optional.empty();
        Optional<Object> endVersionInclusive = Optional.empty();
        if (constraint.getDomains().isPresent() && (domains = (Map)constraint.getDomains().get()).containsKey(versionColumnIndex)) {
            Domain versionDomain = (Domain)domains.get(versionColumnIndex);
            Range range = versionDomain.getValues().getRanges().getSpan();
            if (range.isSingleValue()) {
                long value = (Long)range.getSingleValue();
                startVersionExclusive = Optional.of(value - 1L);
                endVersionInclusive = Optional.of(value);
            } else {
                Optional<Long> highValue;
                Optional<Long> lowValue = range.getLowValue().map(Long.class::cast);
                if (lowValue.isPresent()) {
                    startVersionExclusive = Optional.of(lowValue.get() - (long)(range.isLowInclusive() ? 1 : 0));
                }
                if ((highValue = range.getHighValue().map(Long.class::cast)).isPresent()) {
                    endVersionInclusive = Optional.of(highValue.get() - (long)(range.isHighInclusive() ? 0 : 1));
                }
            }
        }
        if (startVersionExclusive.isPresent() && endVersionInclusive.isPresent() && (Long)startVersionExclusive.get() >= (Long)endVersionInclusive.get()) {
            return new EmptyPageSource();
        }
        if (endVersionInclusive.isEmpty()) {
            endVersionInclusive = Optional.of(snapshotVersion);
        }
        TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
        PageListBuilder pagesBuilder = PageListBuilder.forTable(this.tableMetadata);
        try {
            SequencedCollection transactions = BaseTransactionsTable.loadNewTailBackward(fileSystem, this.tableLocation, startVersionExclusive, (Long)endVersionInclusive.get()).reversed();
            return new FixedPageSource(this.buildPages(session, pagesBuilder, (List<Transaction>)transactions, fileSystem));
        }
        catch (TrinoException e) {
            throw e;
        }
        catch (IOException | RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, "Error getting commit info entries from " + this.tableLocation, (Throwable)e);
        }
    }

    private static List<Transaction> loadNewTailBackward(TrinoFileSystem fileSystem, String tableLocation, Optional<Long> startVersion, long endVersion) throws IOException {
        long version;
        ImmutableList.Builder transactionsBuilder = ImmutableList.builder();
        String transactionLogDir = TransactionLogUtil.getTransactionLogDir(tableLocation);
        long entryNumber = version = endVersion;
        boolean endOfHead = false;
        while (!endOfHead) {
            Optional<TransactionLogEntries> results = TransactionLogTail.getEntriesFromJson(entryNumber, transactionLogDir, fileSystem, DataSize.of((long)0L, (DataSize.Unit)DataSize.Unit.BYTE));
            if (results.isPresent()) {
                transactionsBuilder.add((Object)new Transaction(version, results.get()));
                version = entryNumber--;
            } else {
                endOfHead = true;
            }
            if ((!startVersion.isPresent() || version != startVersion.get() + 1L) && entryNumber >= 0L) continue;
            endOfHead = true;
        }
        return transactionsBuilder.build();
    }

    protected abstract List<Page> buildPages(ConnectorSession var1, PageListBuilder var2, List<Transaction> var3, TrinoFileSystem var4) throws IOException;
}

