/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import io.airlift.concurrent.Threads;
import io.trino.plugin.base.ClosingBinder;
import io.trino.plugin.deltalake.ForDeltaLakeMetadata;
import io.trino.plugin.deltalake.ForDeltaLakeSplitManager;
import io.trino.spi.catalog.CatalogName;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class DeltaLakeExecutorModule
implements Module {
    public void configure(Binder binder) {
        ClosingBinder.closingBinder((Binder)binder).registerExecutor(Key.get(ExecutorService.class, ForDeltaLakeMetadata.class));
        ClosingBinder.closingBinder((Binder)binder).registerExecutor(Key.get(ExecutorService.class, ForDeltaLakeSplitManager.class));
    }

    @Provides
    @Singleton
    @ForDeltaLakeMetadata
    public ExecutorService createMetadataExecutor(CatalogName catalogName) {
        return Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)("delta-metadata-" + String.valueOf(catalogName) + "-%s")));
    }

    @Provides
    @Singleton
    @ForDeltaLakeSplitManager
    public ExecutorService createSplitSourceExecutor(CatalogName catalogName) {
        return Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)("delta-split-source-" + String.valueOf(catalogName) + "-%s")));
    }
}

