/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.base.Preconditions;
import io.trino.plugin.deltalake.DataFileInfo;
import io.trino.plugin.deltalake.transactionlog.DeletionVectorEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public record DeltaLakeMergeResult(List<String> partitionValues, Optional<String> oldFile, Optional<DeletionVectorEntry> oldDeletionVector, Optional<DataFileInfo> newFile) {
    public DeltaLakeMergeResult {
        partitionValues = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(partitionValues, "partitionValues is null")));
        Objects.requireNonNull(oldFile, "oldFile is null");
        Objects.requireNonNull(oldDeletionVector, "oldDeletionVector is null");
        Objects.requireNonNull(newFile, "newFile is null");
        Preconditions.checkArgument((oldFile.isPresent() || newFile.isPresent() ? 1 : 0) != 0, (Object)"old or new must be present");
        Preconditions.checkArgument((oldDeletionVector.isEmpty() || oldFile.isPresent() ? 1 : 0) != 0, (Object)"oldDeletionVector is present only when oldFile is present");
    }
}

