/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.airlift.json.JsonCodec;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.parquet.ParquetReaderOptions;
import io.trino.plugin.base.metrics.FileFormatDataSourceStats;
import io.trino.plugin.deltalake.DataFileInfo;
import io.trino.plugin.deltalake.DeltaLakeCdfPageSink;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnType;
import io.trino.plugin.deltalake.DeltaLakeConfig;
import io.trino.plugin.deltalake.DeltaLakeInsertTableHandle;
import io.trino.plugin.deltalake.DeltaLakeMergeResult;
import io.trino.plugin.deltalake.DeltaLakeMergeSink;
import io.trino.plugin.deltalake.DeltaLakeMergeTableHandle;
import io.trino.plugin.deltalake.DeltaLakeOutputTableHandle;
import io.trino.plugin.deltalake.DeltaLakePageSink;
import io.trino.plugin.deltalake.DeltaLakeParquetSchemaMapping;
import io.trino.plugin.deltalake.DeltaLakeParquetSchemas;
import io.trino.plugin.deltalake.DeltaLakeWriterStats;
import io.trino.plugin.deltalake.procedure.DeltaLakeTableExecuteHandle;
import io.trino.plugin.deltalake.procedure.DeltaTableOptimizeHandle;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeSchemaSupport;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import io.trino.plugin.hive.NodeVersion;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import io.trino.spi.PageIndexerFactory;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorMergeSink;
import io.trino.spi.connector.ConnectorMergeTableHandle;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorPageSinkId;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableExecuteHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import org.joda.time.DateTimeZone;

public class DeltaLakePageSinkProvider
implements ConnectorPageSinkProvider {
    private final PageIndexerFactory pageIndexerFactory;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final JsonCodec<DataFileInfo> dataFileInfoCodec;
    private final JsonCodec<DeltaLakeMergeResult> mergeResultJsonCodec;
    private final DeltaLakeWriterStats stats;
    private final ParquetReaderOptions parquetReaderOptions;
    private final FileFormatDataSourceStats fileFormatDataSourceStats;
    private final int maxPartitionsPerWriter;
    private final DateTimeZone parquetDateTimeZone;
    private final TypeManager typeManager;
    private final String trinoVersion;
    private final int domainCompactionThreshold;

    @Inject
    public DeltaLakePageSinkProvider(PageIndexerFactory pageIndexerFactory, TrinoFileSystemFactory fileSystemFactory, JsonCodec<DataFileInfo> dataFileInfoCodec, JsonCodec<DeltaLakeMergeResult> mergeResultJsonCodec, DeltaLakeWriterStats stats, FileFormatDataSourceStats fileFormatDataSourceStats, DeltaLakeConfig deltaLakeConfig, ParquetReaderConfig parquetReaderConfig, TypeManager typeManager, NodeVersion nodeVersion) {
        this.pageIndexerFactory = pageIndexerFactory;
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.dataFileInfoCodec = dataFileInfoCodec;
        this.mergeResultJsonCodec = Objects.requireNonNull(mergeResultJsonCodec, "mergeResultJsonCodec is null");
        this.stats = stats;
        this.parquetReaderOptions = parquetReaderConfig.toParquetReaderOptions();
        this.fileFormatDataSourceStats = Objects.requireNonNull(fileFormatDataSourceStats, "fileFormatDataSourceStats is null");
        this.maxPartitionsPerWriter = deltaLakeConfig.getMaxPartitionsPerWriter();
        this.parquetDateTimeZone = deltaLakeConfig.getParquetDateTimeZone();
        this.domainCompactionThreshold = deltaLakeConfig.getDomainCompactionThreshold();
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.trinoVersion = nodeVersion.toString();
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorOutputTableHandle outputTableHandle, ConnectorPageSinkId pageSinkId) {
        DeltaLakeOutputTableHandle tableHandle = (DeltaLakeOutputTableHandle)outputTableHandle;
        DeltaLakeParquetSchemaMapping parquetSchemaMapping = DeltaLakeParquetSchemas.createParquetSchemaMapping(tableHandle.schemaString(), this.typeManager, tableHandle.columnMappingMode(), tableHandle.partitionedBy());
        return new DeltaLakePageSink(this.typeManager.getTypeOperators(), tableHandle.inputColumns(), tableHandle.partitionedBy(), this.pageIndexerFactory, this.fileSystemFactory, this.maxPartitionsPerWriter, this.dataFileInfoCodec, Location.of((String)tableHandle.location()), session, this.stats, this.trinoVersion, parquetSchemaMapping);
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorInsertTableHandle insertTableHandle, ConnectorPageSinkId pageSinkId) {
        DeltaLakeInsertTableHandle tableHandle = (DeltaLakeInsertTableHandle)insertTableHandle;
        MetadataEntry metadataEntry = tableHandle.metadataEntry();
        DeltaLakeParquetSchemaMapping parquetSchemaMapping = DeltaLakeParquetSchemas.createParquetSchemaMapping(metadataEntry, tableHandle.protocolEntry(), this.typeManager);
        return new DeltaLakePageSink(this.typeManager.getTypeOperators(), tableHandle.inputColumns(), tableHandle.metadataEntry().getOriginalPartitionColumns(), this.pageIndexerFactory, this.fileSystemFactory, this.maxPartitionsPerWriter, this.dataFileInfoCodec, Location.of((String)tableHandle.location()), session, this.stats, this.trinoVersion, parquetSchemaMapping);
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorTableExecuteHandle tableExecuteHandle, ConnectorPageSinkId pageSinkId) {
        DeltaLakeTableExecuteHandle executeHandle = (DeltaLakeTableExecuteHandle)tableExecuteHandle;
        switch (executeHandle.procedureId()) {
            case OPTIMIZE: {
                DeltaTableOptimizeHandle optimizeHandle = (DeltaTableOptimizeHandle)executeHandle.procedureHandle();
                DeltaLakeParquetSchemaMapping parquetSchemaMapping = DeltaLakeParquetSchemas.createParquetSchemaMapping(optimizeHandle.getMetadataEntry(), optimizeHandle.getProtocolEntry(), this.typeManager);
                return new DeltaLakePageSink(this.typeManager.getTypeOperators(), optimizeHandle.getTableColumns(), optimizeHandle.getOriginalPartitionColumns(), this.pageIndexerFactory, this.fileSystemFactory, this.maxPartitionsPerWriter, this.dataFileInfoCodec, Location.of((String)executeHandle.tableLocation()), session, this.stats, this.trinoVersion, parquetSchemaMapping);
            }
        }
        throw new IllegalArgumentException("Unknown procedure: " + String.valueOf((Object)executeHandle.procedureId()));
    }

    public ConnectorMergeSink createMergeSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorMergeTableHandle mergeHandle, ConnectorPageSinkId pageSinkId) {
        DeltaLakeMergeTableHandle merge = (DeltaLakeMergeTableHandle)mergeHandle;
        DeltaLakeInsertTableHandle tableHandle = merge.insertTableHandle();
        ConnectorPageSink pageSink = this.createPageSink(transactionHandle, session, tableHandle, pageSinkId);
        DeltaLakeParquetSchemaMapping parquetSchemaMapping = DeltaLakeParquetSchemas.createParquetSchemaMapping(tableHandle.metadataEntry(), tableHandle.protocolEntry(), this.typeManager);
        return new DeltaLakeMergeSink(this.typeManager.getTypeOperators(), this.fileSystemFactory, session, this.parquetDateTimeZone, this.trinoVersion, this.dataFileInfoCodec, this.mergeResultJsonCodec, this.stats, Location.of((String)tableHandle.location()), pageSink, tableHandle.inputColumns(), this.domainCompactionThreshold, () -> this.createCdfPageSink(merge, session), DeltaLakeSchemaSupport.changeDataFeedEnabled(tableHandle.metadataEntry(), tableHandle.protocolEntry()).orElse(false), parquetSchemaMapping, this.parquetReaderOptions, this.fileFormatDataSourceStats, DeltaLakeSchemaSupport.isDeletionVectorEnabled(tableHandle.metadataEntry(), tableHandle.protocolEntry()), merge.deletionVectors(), DeltaLakeSchemaSupport.getRandomPrefixLength(tableHandle.metadataEntry()), merge.shallowCloneSourceTableLocation());
    }

    private DeltaLakeCdfPageSink createCdfPageSink(DeltaLakeMergeTableHandle mergeTableHandle, ConnectorSession session) {
        MetadataEntry metadataEntry = mergeTableHandle.tableHandle().getMetadataEntry();
        ProtocolEntry protocolEntry = mergeTableHandle.tableHandle().getProtocolEntry();
        Set partitionKeys = (Set)mergeTableHandle.tableHandle().getMetadataEntry().getOriginalPartitionColumns().stream().collect(ImmutableSet.toImmutableSet());
        List tableColumns = (List)DeltaLakeSchemaSupport.extractSchema(metadataEntry, protocolEntry, this.typeManager).stream().map(metadata -> new DeltaLakeColumnHandle(metadata.name(), metadata.type(), metadata.fieldId(), metadata.physicalName(), metadata.physicalColumnType(), partitionKeys.contains(metadata.name()) ? DeltaLakeColumnType.PARTITION_KEY : DeltaLakeColumnType.REGULAR, Optional.empty())).collect(ImmutableList.toImmutableList());
        ImmutableList allColumns = ImmutableList.builder().addAll((Iterable)tableColumns).add((Object)new DeltaLakeColumnHandle("_change_type", (Type)VarcharType.VARCHAR, OptionalInt.empty(), "_change_type", (Type)VarcharType.VARCHAR, DeltaLakeColumnType.REGULAR, Optional.empty())).build();
        Location tableLocation = Location.of((String)mergeTableHandle.tableHandle().getLocation());
        DeltaLakeParquetSchemaMapping parquetSchemaMapping = DeltaLakeParquetSchemas.createParquetSchemaMapping(metadataEntry, protocolEntry, this.typeManager, true);
        return new DeltaLakeCdfPageSink(this.typeManager.getTypeOperators(), (List<DeltaLakeColumnHandle>)allColumns, metadataEntry.getOriginalPartitionColumns(), this.pageIndexerFactory, this.fileSystemFactory, this.maxPartitionsPerWriter, this.dataFileInfoCodec, tableLocation, tableLocation.appendPath("_change_data"), session, this.stats, this.trinoVersion, parquetSchemaMapping);
    }
}

