/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.inject.Binder;
import com.google.inject.Module;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigurationAwareModule;
import io.trino.plugin.base.security.AllowAllSecurityModule;
import io.trino.plugin.base.security.FileBasedAccessControlModule;
import io.trino.plugin.base.security.ReadOnlySecurityModule;
import io.trino.plugin.deltalake.DeltaLakeSecurityConfig;
import io.trino.plugin.hive.security.UsingSystemSecurity;

public class DeltaLakeSecurityModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        this.install(switch (((DeltaLakeSecurityConfig)this.buildConfigObject(DeltaLakeSecurityConfig.class)).getSecuritySystem().ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> ConfigurationAwareModule.combine((Module[])new Module[]{new AllowAllSecurityModule(), DeltaLakeSecurityModule.usingSystemSecurity(false)});
            case 1 -> ConfigurationAwareModule.combine((Module[])new Module[]{new ReadOnlySecurityModule(), DeltaLakeSecurityModule.usingSystemSecurity(false)});
            case 2 -> ConfigurationAwareModule.combine((Module[])new Module[]{new FileBasedAccessControlModule(), DeltaLakeSecurityModule.usingSystemSecurity(false)});
            case 3 -> DeltaLakeSecurityModule.usingSystemSecurity(true);
        });
    }

    private static Module usingSystemSecurity(boolean system) {
        return binder -> binder.bind(Boolean.TYPE).annotatedWith(UsingSystemSecurity.class).toInstance((Object)system);
    }

    public static enum DeltaLakeSecurity {
        ALLOW_ALL,
        READ_ONLY,
        FILE,
        SYSTEM;

    }
}

