/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.plugin.base.session.PropertyMetadataUtil;
import io.trino.plugin.base.session.SessionPropertiesProvider;
import io.trino.plugin.deltalake.DeltaLakeConfig;
import io.trino.plugin.hive.HiveCompressionOption;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import io.trino.plugin.hive.parquet.ParquetWriterConfig;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.session.PropertyMetadata;
import java.util.List;
import java.util.Optional;

public final class DeltaLakeSessionProperties
implements SessionPropertiesProvider {
    public static final String MAX_SPLIT_SIZE = "max_split_size";
    public static final String VACUUM_MIN_RETENTION = "vacuum_min_retention";
    private static final String HIVE_CATALOG_NAME = "hive_catalog_name";
    private static final String PARQUET_MAX_READ_BLOCK_SIZE = "parquet_max_read_block_size";
    private static final String PARQUET_MAX_READ_BLOCK_ROW_COUNT = "parquet_max_read_block_row_count";
    private static final String PARQUET_SMALL_FILE_THRESHOLD = "parquet_small_file_threshold";
    private static final String PARQUET_USE_COLUMN_INDEX = "parquet_use_column_index";
    private static final String PARQUET_IGNORE_STATISTICS = "parquet_ignore_statistics";
    private static final String PARQUET_VECTORIZED_DECODING_ENABLED = "parquet_vectorized_decoding_enabled";
    private static final String PARQUET_WRITER_BLOCK_SIZE = "parquet_writer_block_size";
    private static final String PARQUET_WRITER_PAGE_SIZE = "parquet_writer_page_size";
    private static final String PARQUET_WRITER_PAGE_VALUE_COUNT = "parquet_writer_page_value_count";
    private static final String TARGET_MAX_FILE_SIZE = "target_max_file_size";
    private static final String IDLE_WRITER_MIN_FILE_SIZE = "idle_writer_min_file_size";
    private static final String COMPRESSION_CODEC = "compression_codec";
    @Deprecated
    private static final String TIMESTAMP_PRECISION = "timestamp_precision";
    private static final String DYNAMIC_FILTERING_WAIT_TIMEOUT = "dynamic_filtering_wait_timeout";
    private static final String TABLE_STATISTICS_ENABLED = "statistics_enabled";
    public static final String EXTENDED_STATISTICS_ENABLED = "extended_statistics_enabled";
    public static final String EXTENDED_STATISTICS_COLLECT_ON_WRITE = "extended_statistics_collect_on_write";
    private static final String PROJECTION_PUSHDOWN_ENABLED = "projection_pushdown_enabled";
    private static final String QUERY_PARTITION_FILTER_REQUIRED = "query_partition_filter_required";
    private static final String CHECKPOINT_FILTERING_ENABLED = "checkpoint_filtering_enabled";
    private static final String STORE_TABLE_METADATA = "store_table_metadata";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public DeltaLakeSessionProperties(DeltaLakeConfig deltaLakeConfig, ParquetReaderConfig parquetReaderConfig, ParquetWriterConfig parquetWriterConfig) {
        this.sessionProperties = ImmutableList.of((Object)PropertyMetadataUtil.dataSizeProperty((String)MAX_SPLIT_SIZE, (String)"Max split size", (DataSize)deltaLakeConfig.getMaxSplitSize(), (boolean)true), (Object)PropertyMetadataUtil.durationProperty((String)VACUUM_MIN_RETENTION, (String)"Minimal retention period for vacuum procedure", (Duration)deltaLakeConfig.getVacuumMinRetention(), (boolean)false), (Object)PropertyMetadata.stringProperty((String)HIVE_CATALOG_NAME, (String)"Catalog to redirect to when a Hive table is referenced", (String)deltaLakeConfig.getHiveCatalogName().orElse(null), (boolean)true), (Object)PropertyMetadataUtil.dataSizeProperty((String)PARQUET_MAX_READ_BLOCK_SIZE, (String)"Parquet: Maximum size of a block to read", (DataSize)parquetReaderConfig.getMaxReadBlockSize(), (boolean)false), (Object)PropertyMetadata.integerProperty((String)PARQUET_MAX_READ_BLOCK_ROW_COUNT, (String)"Parquet: Maximum number of rows read in a batch", (Integer)parquetReaderConfig.getMaxReadBlockRowCount(), value -> {
            if (value < 128 || value > 65536) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s must be between 128 and 65536: %s", PARQUET_MAX_READ_BLOCK_ROW_COUNT, value));
            }
        }, (boolean)false), (Object)PropertyMetadataUtil.dataSizeProperty((String)PARQUET_SMALL_FILE_THRESHOLD, (String)"Parquet: Size below which a parquet file will be read entirely", (DataSize)parquetReaderConfig.getSmallFileThreshold(), value -> PropertyMetadataUtil.validateMaxDataSize((String)PARQUET_SMALL_FILE_THRESHOLD, (DataSize)value, (DataSize)DataSize.valueOf((String)"15MB")), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)PARQUET_USE_COLUMN_INDEX, (String)"Use Parquet column index", (Boolean)parquetReaderConfig.isUseColumnIndex(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)PARQUET_IGNORE_STATISTICS, (String)"Ignore statistics from Parquet to allow querying files with corrupted or incorrect statistics", (Boolean)parquetReaderConfig.isIgnoreStatistics(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)PARQUET_VECTORIZED_DECODING_ENABLED, (String)"Enable using Java Vector API for faster decoding of parquet files", (Boolean)parquetReaderConfig.isVectorizedDecodingEnabled(), (boolean)false), (Object)PropertyMetadataUtil.dataSizeProperty((String)PARQUET_WRITER_BLOCK_SIZE, (String)"Parquet: Writer block size", (DataSize)parquetWriterConfig.getBlockSize(), value -> PropertyMetadataUtil.validateMaxDataSize((String)PARQUET_WRITER_BLOCK_SIZE, (DataSize)value, (DataSize)DataSize.valueOf((String)"2GB")), (boolean)false), (Object)PropertyMetadataUtil.dataSizeProperty((String)PARQUET_WRITER_PAGE_SIZE, (String)"Parquet: Writer page size", (DataSize)parquetWriterConfig.getPageSize(), value -> {
            PropertyMetadataUtil.validateMinDataSize((String)PARQUET_WRITER_PAGE_SIZE, (DataSize)value, (DataSize)DataSize.valueOf((String)"8kB"));
            PropertyMetadataUtil.validateMaxDataSize((String)PARQUET_WRITER_PAGE_SIZE, (DataSize)value, (DataSize)DataSize.valueOf((String)"8MB"));
        }, (boolean)false), (Object)PropertyMetadata.integerProperty((String)PARQUET_WRITER_PAGE_VALUE_COUNT, (String)"Parquet: Writer page row count", (Integer)parquetWriterConfig.getPageValueCount(), value -> {
            if (value < 1000 || value > 200000) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s must be between %s and %s: %s", PARQUET_WRITER_PAGE_VALUE_COUNT, 1000, 200000, value));
            }
        }, (boolean)false), (Object[])new PropertyMetadata[]{PropertyMetadataUtil.dataSizeProperty((String)TARGET_MAX_FILE_SIZE, (String)"Target maximum size of written files; the actual size may be larger", (DataSize)deltaLakeConfig.getTargetMaxFileSize(), (boolean)false), PropertyMetadataUtil.dataSizeProperty((String)IDLE_WRITER_MIN_FILE_SIZE, (String)"Minimum data written by a single partition writer before it can be consider as 'idle' and could be closed by the engine", (DataSize)deltaLakeConfig.getIdleWriterMinFileSize(), (boolean)false), PropertyMetadata.enumProperty((String)TIMESTAMP_PRECISION, (String)"Internal Delta Lake connector property", HiveTimestampPrecision.class, (Enum)HiveTimestampPrecision.MILLISECONDS, value -> {
            throw new IllegalStateException("The property cannot be set");
        }, (boolean)true), PropertyMetadataUtil.durationProperty((String)DYNAMIC_FILTERING_WAIT_TIMEOUT, (String)"Duration to wait for completion of dynamic filters during split generation", (Duration)deltaLakeConfig.getDynamicFilteringWaitTimeout(), (boolean)false), PropertyMetadata.booleanProperty((String)TABLE_STATISTICS_ENABLED, (String)"Expose table statistics", (Boolean)deltaLakeConfig.isTableStatisticsEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)EXTENDED_STATISTICS_ENABLED, (String)"Enable collection (ANALYZE) and use of extended statistics.", (Boolean)deltaLakeConfig.isExtendedStatisticsEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)EXTENDED_STATISTICS_COLLECT_ON_WRITE, (String)"Enables automatic column level extended statistics collection on write", (Boolean)deltaLakeConfig.isCollectExtendedStatisticsOnWrite(), (boolean)false), PropertyMetadata.enumProperty((String)COMPRESSION_CODEC, (String)"Compression codec to use when writing new data files", HiveCompressionOption.class, (Enum)deltaLakeConfig.getCompressionCodec(), value -> {
            if (value == HiveCompressionOption.LZ4) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Unsupported codec: LZ4");
            }
        }, (boolean)false), PropertyMetadata.booleanProperty((String)PROJECTION_PUSHDOWN_ENABLED, (String)"Read only required fields from a row type", (Boolean)deltaLakeConfig.isProjectionPushdownEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)QUERY_PARTITION_FILTER_REQUIRED, (String)"Require filter on partition column", (Boolean)deltaLakeConfig.isQueryPartitionFilterRequired(), (boolean)false), PropertyMetadata.booleanProperty((String)CHECKPOINT_FILTERING_ENABLED, (String)"Use filter in checkpoint reader", (Boolean)deltaLakeConfig.isCheckpointFilteringEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)STORE_TABLE_METADATA, (String)"Store table metadata in metastore", (Boolean)deltaLakeConfig.isStoreTableMetadataEnabled(), (boolean)true)});
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static DataSize getMaxSplitSize(ConnectorSession session) {
        return (DataSize)session.getProperty(MAX_SPLIT_SIZE, DataSize.class);
    }

    public static Duration getVacuumMinRetention(ConnectorSession session) {
        return (Duration)session.getProperty(VACUUM_MIN_RETENTION, Duration.class);
    }

    public static Optional<String> getHiveCatalogName(ConnectorSession session) {
        return Optional.ofNullable((String)session.getProperty(HIVE_CATALOG_NAME, String.class));
    }

    public static DataSize getParquetMaxReadBlockSize(ConnectorSession session) {
        return (DataSize)session.getProperty(PARQUET_MAX_READ_BLOCK_SIZE, DataSize.class);
    }

    public static int getParquetMaxReadBlockRowCount(ConnectorSession session) {
        return (Integer)session.getProperty(PARQUET_MAX_READ_BLOCK_ROW_COUNT, Integer.class);
    }

    public static DataSize getParquetSmallFileThreshold(ConnectorSession session) {
        return (DataSize)session.getProperty(PARQUET_SMALL_FILE_THRESHOLD, DataSize.class);
    }

    public static boolean isParquetUseColumnIndex(ConnectorSession session) {
        return (Boolean)session.getProperty(PARQUET_USE_COLUMN_INDEX, Boolean.class);
    }

    public static boolean isParquetIgnoreStatistics(ConnectorSession session) {
        return (Boolean)session.getProperty(PARQUET_IGNORE_STATISTICS, Boolean.class);
    }

    public static boolean isParquetVectorizedDecodingEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(PARQUET_VECTORIZED_DECODING_ENABLED, Boolean.class);
    }

    public static DataSize getParquetWriterBlockSize(ConnectorSession session) {
        return (DataSize)session.getProperty(PARQUET_WRITER_BLOCK_SIZE, DataSize.class);
    }

    public static DataSize getParquetWriterPageSize(ConnectorSession session) {
        return (DataSize)session.getProperty(PARQUET_WRITER_PAGE_SIZE, DataSize.class);
    }

    public static int getParquetWriterPageValueCount(ConnectorSession session) {
        return (Integer)session.getProperty(PARQUET_WRITER_PAGE_VALUE_COUNT, Integer.class);
    }

    public static long getTargetMaxFileSize(ConnectorSession session) {
        return ((DataSize)session.getProperty(TARGET_MAX_FILE_SIZE, DataSize.class)).toBytes();
    }

    public static long getIdleWriterMinFileSize(ConnectorSession session) {
        return ((DataSize)session.getProperty(IDLE_WRITER_MIN_FILE_SIZE, DataSize.class)).toBytes();
    }

    public static Duration getDynamicFilteringWaitTimeout(ConnectorSession session) {
        return (Duration)session.getProperty(DYNAMIC_FILTERING_WAIT_TIMEOUT, Duration.class);
    }

    public static boolean isTableStatisticsEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(TABLE_STATISTICS_ENABLED, Boolean.class);
    }

    public static boolean isExtendedStatisticsEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(EXTENDED_STATISTICS_ENABLED, Boolean.class);
    }

    public static boolean isCollectExtendedStatisticsColumnStatisticsOnWrite(ConnectorSession session) {
        return (Boolean)session.getProperty(EXTENDED_STATISTICS_COLLECT_ON_WRITE, Boolean.class);
    }

    public static HiveCompressionOption getCompressionCodec(ConnectorSession session) {
        return (HiveCompressionOption)session.getProperty(COMPRESSION_CODEC, HiveCompressionOption.class);
    }

    public static boolean isProjectionPushdownEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(PROJECTION_PUSHDOWN_ENABLED, Boolean.class);
    }

    public static boolean isQueryPartitionFilterRequired(ConnectorSession session) {
        return (Boolean)session.getProperty(QUERY_PARTITION_FILTER_REQUIRED, Boolean.class);
    }

    public static boolean isCheckpointFilteringEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(CHECKPOINT_FILTERING_ENABLED, Boolean.class);
    }

    public static boolean isStoreTableMetadataInMetastoreEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(STORE_TABLE_METADATA, Boolean.class);
    }
}

