/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.MapBinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.json.JsonCodecBinder;
import io.trino.filesystem.s3.S3FileSystemConfig;
import io.trino.plugin.deltalake.transactionlog.writer.AzureTransactionLogSynchronizer;
import io.trino.plugin.deltalake.transactionlog.writer.GcsTransactionLogSynchronizer;
import io.trino.plugin.deltalake.transactionlog.writer.S3ConditionalWriteLogSynchronizer;
import io.trino.plugin.deltalake.transactionlog.writer.S3LockBasedTransactionLogSynchronizer;
import io.trino.plugin.deltalake.transactionlog.writer.TransactionLogSynchronizer;

public class DeltaLakeSynchronizerModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        MapBinder synchronizerBinder = MapBinder.newMapBinder((Binder)binder, String.class, TransactionLogSynchronizer.class);
        synchronizerBinder.addBinding((Object)"abfs").to(AzureTransactionLogSynchronizer.class).in(Scopes.SINGLETON);
        synchronizerBinder.addBinding((Object)"abfss").to(AzureTransactionLogSynchronizer.class).in(Scopes.SINGLETON);
        synchronizerBinder.addBinding((Object)"gs").to(GcsTransactionLogSynchronizer.class).in(Scopes.SINGLETON);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(S3LockBasedTransactionLogSynchronizer.LockFileContents.class);
        binder.bind(S3LockBasedTransactionLogSynchronizer.class).in(Scopes.SINGLETON);
        binder.bind(S3ConditionalWriteLogSynchronizer.class).in(Scopes.SINGLETON);
        this.install(ConditionalModule.conditionalModule(S3FileSystemConfig.class, S3FileSystemConfig::isSupportsExclusiveCreate, (Module)DeltaLakeSynchronizerModule.s3SynchronizerModule(S3ConditionalWriteLogSynchronizer.class), (Module)DeltaLakeSynchronizerModule.s3SynchronizerModule(S3LockBasedTransactionLogSynchronizer.class)));
    }

    private static Module s3SynchronizerModule(final Class<? extends TransactionLogSynchronizer> synchronizerClass) {
        return new AbstractModule(){

            protected void configure() {
                MapBinder synchronizerBinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, TransactionLogSynchronizer.class);
                synchronizerBinder.addBinding((Object)"s3").to(synchronizerClass).in(Scopes.SINGLETON);
                synchronizerBinder.addBinding((Object)"s3a").to(synchronizerClass).in(Scopes.SINGLETON);
                synchronizerBinder.addBinding((Object)"s3n").to(synchronizerClass).in(Scopes.SINGLETON);
            }
        };
    }
}

