/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableList;
import io.airlift.json.JsonCodec;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.deltalake.BaseTransactionsTable;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeTransactionLogEntry;
import io.trino.plugin.deltalake.transactionlog.Transaction;
import io.trino.plugin.deltalake.transactionlog.TransactionLogAccess;
import io.trino.plugin.deltalake.util.PageListBuilder;
import io.trino.spi.Page;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import java.util.List;
import java.util.Objects;

public class DeltaLakeTransactionsTable
extends BaseTransactionsTable {
    private static final JsonCodec<List<DeltaLakeTransactionLogEntry>> TRANSACTION_LOG_ENTRIES_CODEC = JsonCodec.listJsonCodec(DeltaLakeTransactionLogEntry.class);

    public DeltaLakeTransactionsTable(SchemaTableName tableName, String tableLocation, TrinoFileSystemFactory fileSystemFactory, TransactionLogAccess transactionLogAccess, TypeManager typeManager) {
        super(tableName, tableLocation, fileSystemFactory, transactionLogAccess, typeManager, new ConnectorTableMetadata(Objects.requireNonNull(tableName, "tableName is null"), (List)ImmutableList.builder().add((Object)new ColumnMetadata("version", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("transaction", typeManager.getType(new TypeSignature("json", new TypeSignatureParameter[0])))).build()));
    }

    @Override
    protected List<Page> buildPages(ConnectorSession session, PageListBuilder pagesBuilder, List<Transaction> transactions, TrinoFileSystem fileSystem) {
        for (Transaction transaction : transactions) {
            pagesBuilder.beginRow();
            pagesBuilder.appendBigint(transaction.transactionId());
            pagesBuilder.appendVarchar(TRANSACTION_LOG_ENTRIES_CODEC.toJson(transaction.transactionEntries().getEntriesList(fileSystem)));
            pagesBuilder.endRow();
        }
        return pagesBuilder.build();
    }
}

