/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.delete;

import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.delete.PageFilter;
import io.trino.plugin.deltalake.delete.RoaringBitmapArray;
import io.trino.spi.block.Block;
import io.trino.spi.type.BigintType;
import java.util.List;
import java.util.Objects;

public final class PositionDeleteFilter {
    private final RoaringBitmapArray deletedRows;

    public PositionDeleteFilter(RoaringBitmapArray deletedRows) {
        this.deletedRows = Objects.requireNonNull(deletedRows, "deletedRows is null");
    }

    public PageFilter createPredicate(List<DeltaLakeColumnHandle> columns) {
        int filePositionChannel = PositionDeleteFilter.rowPositionChannel(columns);
        return page -> {
            int positionCount = page.getPositionCount();
            int[] retained = new int[positionCount];
            int retainedCount = 0;
            Block block = page.getBlock(filePositionChannel);
            for (int position = 0; position < positionCount; ++position) {
                long filePosition = BigintType.BIGINT.getLong(block, position);
                if (this.deletedRows.contains(filePosition)) continue;
                retained[retainedCount] = position;
                ++retainedCount;
            }
            if (retainedCount == positionCount) {
                return page;
            }
            page.selectPositions(retained, 0, retainedCount);
            return page;
        };
    }

    private static int rowPositionChannel(List<DeltaLakeColumnHandle> columns) {
        for (int i = 0; i < columns.size(); ++i) {
            if (!columns.get(i).baseColumnName().equals("$row_position")) continue;
            return i;
        }
        throw new IllegalArgumentException("No row position column");
    }
}

