/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.delete;

import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedInts;
import org.roaringbitmap.RoaringBitmap;

public final class RoaringBitmapArray {
    private static final long MAX_REPRESENTABLE_VALUE = 9223372030412324864L;
    private static final int INDIVIDUAL_BITMAP_KEY_SIZE = 4;
    private RoaringBitmap[] bitmaps = new RoaringBitmap[0];

    public RoaringBitmap get(int i) {
        return this.bitmaps[i];
    }

    public boolean contains(long value) {
        Preconditions.checkArgument((value >= 0L && value <= 9223372030412324864L ? 1 : 0) != 0, (String)"Unsupported value: %s", (long)value);
        int high = RoaringBitmapArray.highBytes(value);
        if (high >= this.bitmaps.length) {
            return false;
        }
        int low = RoaringBitmapArray.lowBytes(value);
        return this.bitmaps[high].contains(low);
    }

    public boolean isEmpty() {
        for (RoaringBitmap bitmap : this.bitmaps) {
            if (bitmap.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public long length() {
        return this.bitmaps.length;
    }

    public long cardinality() {
        long sum = 0L;
        for (RoaringBitmap bitmap : this.bitmaps) {
            sum += bitmap.getLongCardinality();
        }
        return sum;
    }

    public int serializedSizeInBytes() {
        long size = 0L;
        for (RoaringBitmap bitmap : this.bitmaps) {
            size += (long)(bitmap.serializedSizeInBytes() + 4);
        }
        return Math.toIntExact(size);
    }

    public void add(long value) {
        Preconditions.checkArgument((value >= 0L && value <= 9223372030412324864L ? 1 : 0) != 0, (String)"Unsupported value: %s", (long)value);
        int high = RoaringBitmapArray.highBytes(value);
        int low = RoaringBitmapArray.lowBytes(value);
        if (high >= this.bitmaps.length) {
            this.extendBitmaps(high + 1);
        }
        RoaringBitmap highBitmap = this.bitmaps[high];
        highBitmap.add(low);
    }

    public void addRange(long rangeStart, long rangeEnd) {
        Preconditions.checkArgument((rangeStart >= 0L && rangeStart <= rangeEnd ? 1 : 0) != 0, (String)"Unsupported value: %s", (long)rangeStart);
        if (this.bitmaps.length == 0) {
            this.extendBitmaps(1);
        }
        int startHigh = RoaringBitmapArray.highBytes(rangeStart);
        int startLow = RoaringBitmapArray.lowBytes(rangeStart);
        int endHigh = RoaringBitmapArray.highBytes(rangeEnd);
        int endLow = RoaringBitmapArray.lowBytes(rangeEnd);
        int lastHigh = endHigh;
        if (lastHigh >= this.bitmaps.length) {
            this.extendBitmaps(lastHigh + 1);
        }
        for (int currentHigh = startHigh; currentHigh <= lastHigh; ++currentHigh) {
            long start = currentHigh == startHigh ? UnsignedInts.toLong((int)startLow) : 0L;
            long end = currentHigh == endHigh ? UnsignedInts.toLong((int)endLow) + 1L : 0x100000000L;
            this.bitmaps[currentHigh].add(start, end);
        }
    }

    public void or(RoaringBitmapArray other) {
        if (this.bitmaps.length < other.bitmaps.length) {
            this.extendBitmaps(other.bitmaps.length);
        }
        for (int i = 0; i < other.bitmaps.length; ++i) {
            this.bitmaps[i].or(other.bitmaps[i]);
        }
    }

    public void andNot(RoaringBitmapArray other) {
        int length = Math.min(this.bitmaps.length, other.bitmaps.length);
        for (int i = 0; i < length; ++i) {
            this.bitmaps[i].andNot(other.bitmaps[i]);
        }
    }

    private void extendBitmaps(int newLength) {
        if (this.bitmaps.length == 0 && newLength == 1) {
            this.bitmaps = new RoaringBitmap[]{new RoaringBitmap()};
            return;
        }
        RoaringBitmap[] newBitmaps = new RoaringBitmap[newLength];
        System.arraycopy(this.bitmaps, 0, newBitmaps, 0, this.bitmaps.length);
        for (int i = this.bitmaps.length; i < newLength; ++i) {
            newBitmaps[i] = new RoaringBitmap();
        }
        this.bitmaps = newBitmaps;
    }

    private static int highBytes(long value) {
        return (int)(value >> 32);
    }

    private static int lowBytes(long value) {
        return (int)value;
    }
}

