/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.functions.tablechanges;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.trino.plugin.base.util.Functions;
import io.trino.plugin.base.util.UncheckedCloseable;
import io.trino.plugin.deltalake.CorruptedDeltaLakeTableHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnType;
import io.trino.plugin.deltalake.DeltaLakeMetadata;
import io.trino.plugin.deltalake.DeltaLakeMetadataFactory;
import io.trino.plugin.deltalake.DeltaLakeTableHandle;
import io.trino.plugin.deltalake.functions.tablechanges.TableChangesTableFunctionHandle;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.function.table.AbstractConnectorTableFunction;
import io.trino.spi.function.table.Argument;
import io.trino.spi.function.table.ConnectorTableFunctionHandle;
import io.trino.spi.function.table.Descriptor;
import io.trino.spi.function.table.ReturnTypeSpecification;
import io.trino.spi.function.table.ScalarArgument;
import io.trino.spi.function.table.ScalarArgumentSpecification;
import io.trino.spi.function.table.TableFunctionAnalysis;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class TableChangesFunction
extends AbstractConnectorTableFunction {
    private static final String SCHEMA_NAME = "system";
    private static final String NAME = "table_changes";
    public static final String SCHEMA_NAME_ARGUMENT = "SCHEMA_NAME";
    private static final String TABLE_NAME_ARGUMENT = "TABLE_NAME";
    private static final String SINCE_VERSION_ARGUMENT = "SINCE_VERSION";
    private static final String CHANGE_TYPE_COLUMN_NAME = "_change_type";
    private static final String COMMIT_VERSION_COLUMN_NAME = "_commit_version";
    private static final String COMMIT_TIMESTAMP_COLUMN_NAME = "_commit_timestamp";
    private final DeltaLakeMetadataFactory deltaLakeMetadataFactory;

    public TableChangesFunction(DeltaLakeMetadataFactory deltaLakeMetadataFactory) {
        super(SCHEMA_NAME, NAME, (List)ImmutableList.of((Object)ScalarArgumentSpecification.builder().name(SCHEMA_NAME_ARGUMENT).type((Type)VarcharType.VARCHAR).build(), (Object)ScalarArgumentSpecification.builder().name(TABLE_NAME_ARGUMENT).type((Type)VarcharType.VARCHAR).build(), (Object)ScalarArgumentSpecification.builder().name(SINCE_VERSION_ARGUMENT).type((Type)BigintType.BIGINT).defaultValue(null).build()), (ReturnTypeSpecification)ReturnTypeSpecification.GenericTable.GENERIC_TABLE);
        this.deltaLakeMetadataFactory = Objects.requireNonNull(deltaLakeMetadataFactory, "deltaLakeMetadataFactory is null");
    }

    public TableFunctionAnalysis analyze(ConnectorSession session, ConnectorTransactionHandle transaction, Map<String, Argument> arguments, ConnectorAccessControl accessControl) {
        ScalarArgument schemaNameArgument = (ScalarArgument)arguments.get(SCHEMA_NAME_ARGUMENT);
        Functions.checkFunctionArgument((schemaNameArgument.getValue() != null ? 1 : 0) != 0, (String)"schema_name cannot be null", (Object[])new Object[0]);
        String schemaName = ((Slice)schemaNameArgument.getValue()).toStringUtf8();
        ScalarArgument tableNameArgument = (ScalarArgument)arguments.get(TABLE_NAME_ARGUMENT);
        Functions.checkFunctionArgument((tableNameArgument.getValue() != null ? 1 : 0) != 0, (String)"table_name value for function table_changes() cannot be null", (Object[])new Object[0]);
        String tableName = ((Slice)tableNameArgument.getValue()).toStringUtf8();
        ScalarArgument sinceVersionArgument = (ScalarArgument)arguments.get(SINCE_VERSION_ARGUMENT);
        Object sinceVersionValue = sinceVersionArgument.getValue();
        long sinceVersion = -1L;
        if (sinceVersionValue != null) {
            sinceVersion = (Long)sinceVersionValue;
            Functions.checkFunctionArgument((sinceVersion >= 0L ? 1 : 0) != 0, (String)"Invalid value of since_version: %s. It must not be negative.", (Object[])new Object[]{sinceVersion});
        }
        long firstReadVersion = sinceVersion + 1L;
        DeltaLakeMetadata deltaLakeMetadata = this.deltaLakeMetadataFactory.create(session.getIdentity());
        deltaLakeMetadata.beginQuery(session);
        try (UncheckedCloseable ignore = () -> deltaLakeMetadata.cleanupQuery(session);){
            SchemaTableName schemaTableName = new SchemaTableName(schemaName, tableName);
            ConnectorTableHandle connectorTableHandle = deltaLakeMetadata.getTableHandle(session, schemaTableName, Optional.empty(), Optional.empty());
            if (connectorTableHandle == null) {
                throw new TableNotFoundException(schemaTableName);
            }
            if (connectorTableHandle instanceof CorruptedDeltaLakeTableHandle) {
                CorruptedDeltaLakeTableHandle corruptedTableHandle = (CorruptedDeltaLakeTableHandle)connectorTableHandle;
                throw corruptedTableHandle.createException();
            }
            DeltaLakeTableHandle tableHandle = (DeltaLakeTableHandle)connectorTableHandle;
            if (sinceVersion > tableHandle.getReadVersion()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("since_version: %d is higher then current table version: %d", sinceVersion, tableHandle.getReadVersion()));
            }
            List columnHandles = (List)deltaLakeMetadata.getColumnHandles(session, tableHandle).values().stream().map(DeltaLakeColumnHandle.class::cast).filter(column -> column.columnType() != DeltaLakeColumnType.SYNTHESIZED).collect(ImmutableList.toImmutableList());
            accessControl.checkCanSelectFromColumns(null, schemaTableName, (Set)columnHandles.stream().map(column -> column.columnName().toLowerCase(Locale.ENGLISH)).collect(ImmutableSet.toImmutableSet()));
            ImmutableList.Builder outputFields = ImmutableList.builder();
            columnHandles.stream().map(columnHandle -> new Descriptor.Field(columnHandle.columnName(), Optional.of(columnHandle.type()))).forEach(arg_0 -> ((ImmutableList.Builder)outputFields).add(arg_0));
            outputFields.add((Object)new Descriptor.Field(CHANGE_TYPE_COLUMN_NAME, Optional.of(VarcharType.VARCHAR)));
            outputFields.add((Object)new Descriptor.Field(COMMIT_VERSION_COLUMN_NAME, Optional.of(BigintType.BIGINT)));
            outputFields.add((Object)new Descriptor.Field(COMMIT_TIMESTAMP_COLUMN_NAME, Optional.of(TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS)));
            TableFunctionAnalysis tableFunctionAnalysis = TableFunctionAnalysis.builder().handle((ConnectorTableFunctionHandle)new TableChangesTableFunctionHandle(schemaTableName, firstReadVersion, tableHandle.getReadVersion(), tableHandle.getLocation(), columnHandles)).returnedType(new Descriptor((List)outputFields.build())).build();
            return tableFunctionAnalysis;
        }
    }
}

