/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.metastore.file;

import com.google.common.collect.ImmutableMap;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.Table;
import io.trino.plugin.deltalake.metastore.DeltaLakeTableMetadataScheduler;
import io.trino.plugin.deltalake.metastore.DeltaLakeTableOperations;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DeltaLakeFileMetastoreTableOperations
implements DeltaLakeTableOperations {
    private final HiveMetastore metastore;

    public DeltaLakeFileMetastoreTableOperations(HiveMetastore metastore) {
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
    }

    @Override
    public void commitToExistingTable(SchemaTableName schemaTableName, long version, String schemaString, Optional<String> tableComment) {
        Table currentTable = (Table)this.metastore.getTable(schemaTableName.getSchemaName(), schemaTableName.getTableName()).orElseThrow(() -> new TableNotFoundException(schemaTableName));
        ImmutableMap parameters = ImmutableMap.builder().putAll(currentTable.getParameters()).putAll(DeltaLakeTableMetadataScheduler.tableMetadataParameters(version, schemaString, tableComment)).buildKeepingLast();
        Table updatedTable = currentTable.withParameters((Map)parameters);
        this.metastore.replaceTable(currentTable.getDatabaseName(), currentTable.getTableName(), updatedTable, MetastoreUtil.buildInitialPrivilegeSet((String)((String)currentTable.getOwner().orElseThrow())), (Map)ImmutableMap.of());
    }
}

