/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.metastore.glue;

import com.google.common.collect.ImmutableMap;
import io.trino.plugin.deltalake.metastore.DeltaLakeTableMetadataScheduler;
import io.trino.plugin.deltalake.metastore.DeltaLakeTableOperations;
import io.trino.plugin.hive.metastore.glue.GlueCache;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastore;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreStats;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.EntityNotFoundException;
import software.amazon.awssdk.services.glue.model.GetTableRequest;
import software.amazon.awssdk.services.glue.model.Table;
import software.amazon.awssdk.services.glue.model.TableInput;

public class DeltaLakeGlueMetastoreTableOperations
implements DeltaLakeTableOperations {
    private final GlueClient glueClient;
    private final GlueCache glueCache;
    private final GlueMetastoreStats stats;

    public DeltaLakeGlueMetastoreTableOperations(GlueClient glueClient, GlueCache glueCache, GlueMetastoreStats stats) {
        this.glueClient = Objects.requireNonNull(glueClient, "glueClient is null");
        this.glueCache = Objects.requireNonNull(glueCache, "glueCache is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
    }

    @Override
    public void commitToExistingTable(SchemaTableName schemaTableName, long version, String schemaString, Optional<String> tableComment) {
        Table currentTable;
        GetTableRequest getTableRequest = (GetTableRequest)GetTableRequest.builder().databaseName(schemaTableName.getSchemaName()).name(schemaTableName.getTableName()).build();
        try {
            currentTable = this.glueClient.getTable(getTableRequest).table();
        }
        catch (EntityNotFoundException e) {
            throw new TableNotFoundException(schemaTableName);
        }
        String glueVersionId = currentTable.versionId();
        this.stats.getUpdateTable().call(() -> this.glueClient.updateTable(builder -> builder.databaseName(schemaTableName.getSchemaName()).tableInput(DeltaLakeGlueMetastoreTableOperations.convertGlueTableToTableInput(currentTable, version, schemaString, tableComment)).versionId(glueVersionId)));
        this.glueCache.invalidateTable(schemaTableName.getSchemaName(), schemaTableName.getTableName(), false);
    }

    private static TableInput convertGlueTableToTableInput(Table glueTable, long version, String schemaString, Optional<String> tableComment) {
        ImmutableMap parameters = ImmutableMap.builder().putAll(glueTable.parameters()).putAll(DeltaLakeTableMetadataScheduler.tableMetadataParameters(version, schemaString, tableComment)).buildKeepingLast();
        return (TableInput)GlueHiveMetastore.asTableInputBuilder((Table)glueTable).parameters((Map)parameters).build();
    }
}

