/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.airlift.slice.SizeOf;
import io.trino.plugin.deltalake.transactionlog.TransactionLogUtil;
import java.util.Map;
import java.util.Optional;

public class CdcEntry {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(CdcEntry.class);
    private final String path;
    private final Map<String, String> partitionValues;
    private final Map<String, Optional<String>> canonicalPartitionValues;
    private final long size;
    private final boolean dataChange;

    @JsonCreator
    public CdcEntry(@JsonProperty(value="path") String path, @JsonProperty(value="partitionValues") Map<String, String> partitionValues, @JsonProperty(value="size") long size) {
        this.path = path;
        this.partitionValues = partitionValues;
        this.canonicalPartitionValues = TransactionLogUtil.canonicalizePartitionValues(partitionValues);
        this.size = size;
        this.dataChange = false;
    }

    @JsonProperty
    public String getPath() {
        return this.path;
    }

    @JsonProperty
    public Map<String, String> getPartitionValues() {
        return this.partitionValues;
    }

    @JsonIgnore
    public Map<String, Optional<String>> getCanonicalPartitionValues() {
        return this.canonicalPartitionValues;
    }

    @JsonProperty
    public long getSize() {
        return this.size;
    }

    @JsonProperty(value="dataChange")
    public boolean isDataChange() {
        return this.dataChange;
    }

    public String toString() {
        return String.format("CdcEntry{path=%s, partitionValues=%s, size=%d, dataChange=%b}", this.path, this.partitionValues, this.size, this.dataChange);
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.path) + SizeOf.estimatedSizeOf(this.partitionValues, SizeOf::estimatedSizeOf, SizeOf::estimatedSizeOf) + SizeOf.estimatedSizeOf(this.canonicalPartitionValues, SizeOf::estimatedSizeOf, value -> SizeOf.sizeOf((Optional)value, SizeOf::estimatedSizeOf)) + 8L;
    }
}

