/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog;

import io.airlift.slice.SizeOf;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;

public record CommitInfoEntry(long version, OptionalLong inCommitTimestamp, long timestamp, String userId, String userName, String operation, Map<String, String> operationParameters, Job job, Notebook notebook, String clusterId, long readVersion, String isolationLevel, Optional<Boolean> isBlindAppend, Map<String, String> operationMetrics) {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(CommitInfoEntry.class);

    public CommitInfoEntry {
        Objects.requireNonNull(isBlindAppend, "isBlindAppend is null");
    }

    public CommitInfoEntry withVersion(long version) {
        return new CommitInfoEntry(version, this.inCommitTimestamp, this.timestamp, this.userId, this.userName, this.operation, this.operationParameters, this.job, this.notebook, this.clusterId, this.readVersion, this.isolationLevel, this.isBlindAppend, this.operationMetrics);
    }

    public long getRetainedSizeInBytes() {
        return (long)(INSTANCE_SIZE + 8) + SizeOf.sizeOf((OptionalLong)this.inCommitTimestamp) + 8L + SizeOf.estimatedSizeOf((String)this.userId) + SizeOf.estimatedSizeOf((String)this.userName) + SizeOf.estimatedSizeOf((String)this.operation) + SizeOf.estimatedSizeOf(this.operationParameters, SizeOf::estimatedSizeOf, SizeOf::estimatedSizeOf) + (this.job == null ? 0L : this.job.getRetainedSizeInBytes()) + (this.notebook == null ? 0L : this.notebook.getRetainedSizeInBytes()) + SizeOf.estimatedSizeOf((String)this.clusterId) + 8L + SizeOf.estimatedSizeOf((String)this.isolationLevel) + SizeOf.sizeOf(this.isBlindAppend, SizeOf::sizeOf) + SizeOf.estimatedSizeOf(this.operationMetrics, SizeOf::estimatedSizeOf, SizeOf::estimatedSizeOf);
    }

    public record Job(String jobId, String jobName, String runId, String jobOwnerId, String triggerType) {
        private static final int INSTANCE_SIZE = SizeOf.instanceSize(Job.class);

        public long getRetainedSizeInBytes() {
            return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.jobId) + SizeOf.estimatedSizeOf((String)this.jobName) + SizeOf.estimatedSizeOf((String)this.runId) + SizeOf.estimatedSizeOf((String)this.jobOwnerId) + SizeOf.estimatedSizeOf((String)this.triggerType);
        }
    }

    public record Notebook(String notebookId) {
        private static final int INSTANCE_SIZE = SizeOf.instanceSize(Notebook.class);

        public long getRetainedSizeInBytes() {
            return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.notebookId);
        }
    }
}

