/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog;

import io.airlift.slice.SizeOf;
import java.util.Objects;
import java.util.OptionalInt;

public record DeletionVectorEntry(String storageType, String pathOrInlineDv, OptionalInt offset, int sizeInBytes, long cardinality) {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(DeletionVectorEntry.class);

    public DeletionVectorEntry {
        Objects.requireNonNull(storageType, "storageType is null");
        Objects.requireNonNull(pathOrInlineDv, "pathOrInlineDv is null");
        Objects.requireNonNull(offset, "offset is null");
    }

    public String uniqueId() {
        String uniqueFileId = this.storageType + this.pathOrInlineDv;
        if (this.offset.isPresent()) {
            return uniqueFileId + "@" + String.valueOf(this.offset);
        }
        return uniqueFileId;
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.storageType) + SizeOf.estimatedSizeOf((String)this.pathOrInlineDv) + SizeOf.sizeOf((OptionalInt)this.offset) + 4L + 8L;
    }
}

