/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Enums;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.log.Logger;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnMetadata;
import io.trino.plugin.deltalake.DeltaLakeColumnType;
import io.trino.plugin.deltalake.DeltaLakeErrorCode;
import io.trino.plugin.deltalake.DeltaLakeTable;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import io.trino.plugin.deltalake.transactionlog.TransactionLogAccess;
import io.trino.plugin.deltalake.transactionlog.statistics.DeltaLakeFileStatistics;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Location;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeNotFoundException;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import jakarta.annotation.Nullable;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

public final class DeltaLakeSchemaSupport {
    private static final Logger log = Logger.get(DeltaLakeSchemaSupport.class);
    private static final Splitter SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings().trimResults();
    public static final String APPEND_ONLY_CONFIGURATION_KEY = "delta.appendOnly";
    public static final String COLUMN_MAPPING_MODE_CONFIGURATION_KEY = "delta.columnMapping.mode";
    public static final String COLUMN_MAPPING_PHYSICAL_NAME_CONFIGURATION_KEY = "delta.columnMapping.physicalName";
    public static final String MAX_COLUMN_ID_CONFIGURATION_KEY = "delta.columnMapping.maxColumnId";
    public static final String ISOLATION_LEVEL_CONFIGURATION_KEY = "delta.isolationLevel";
    public static final String DELETION_VECTORS_CONFIGURATION_KEY = "delta.enableDeletionVectors";
    private static final String UNIVERSAL_FORMAT_CONFIGURATION_KEY = "delta.universalFormat.enabledFormats";
    private static final Map<Type, String> PRIMITIVE_TYPE_MAPPING = ImmutableMap.builder().put((Object)BigintType.BIGINT, (Object)"long").put((Object)IntegerType.INTEGER, (Object)"integer").put((Object)SmallintType.SMALLINT, (Object)"short").put((Object)TinyintType.TINYINT, (Object)"byte").put((Object)RealType.REAL, (Object)"float").put((Object)DoubleType.DOUBLE, (Object)"double").put((Object)BooleanType.BOOLEAN, (Object)"boolean").put((Object)VarbinaryType.VARBINARY, (Object)"binary").put((Object)DateType.DATE, (Object)"date").buildOrThrow();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapperProvider().get();

    private DeltaLakeSchemaSupport() {
    }

    public static boolean isAppendOnly(MetadataEntry metadataEntry, ProtocolEntry protocolEntry) {
        if (protocolEntry.supportsWriterFeatures() && !protocolEntry.writerFeaturesContains("appendOnly")) {
            return false;
        }
        return Boolean.parseBoolean(metadataEntry.getConfiguration().getOrDefault(APPEND_ONLY_CONFIGURATION_KEY, "false"));
    }

    public static boolean isDeletionVectorEnabled(MetadataEntry metadataEntry, ProtocolEntry protocolEntry) {
        if (protocolEntry.supportsWriterFeatures() && !protocolEntry.writerFeaturesContains("deletionVectors")) {
            return false;
        }
        return Boolean.parseBoolean(metadataEntry.getConfiguration().get(DELETION_VECTORS_CONFIGURATION_KEY));
    }

    public static int getRandomPrefixLength(MetadataEntry metadataEntry) {
        boolean randomizeFilePrefixes = Boolean.parseBoolean(metadataEntry.getConfiguration().get("delta.randomizeFilePrefixes"));
        if (randomizeFilePrefixes) {
            int randomPrefixLength = Integer.parseInt(metadataEntry.getConfiguration().getOrDefault("delta.randomPrefixLength", "2"));
            Preconditions.checkArgument((randomPrefixLength >= 0 ? 1 : 0) != 0, (String)"randomPrefixLength must be >= 0: %s", (int)randomPrefixLength);
            return randomPrefixLength;
        }
        return 0;
    }

    public static List<String> enabledUniversalFormats(MetadataEntry metadataEntry) {
        String formats = metadataEntry.getConfiguration().get(UNIVERSAL_FORMAT_CONFIGURATION_KEY);
        return formats == null ? ImmutableList.of() : SPLITTER.splitToList((CharSequence)formats);
    }

    public static ColumnMappingMode getColumnMappingMode(MetadataEntry metadata, ProtocolEntry protocolEntry) {
        if (protocolEntry.supportsReaderFeatures() || protocolEntry.supportsWriterFeatures()) {
            if (protocolEntry.writerFeaturesContains("icebergCompatV1") || protocolEntry.writerFeaturesContains("icebergCompatV2")) {
                String columnMappingMode = metadata.getConfiguration().get(COLUMN_MAPPING_MODE_CONFIGURATION_KEY);
                Preconditions.checkArgument((columnMappingMode != null && columnMappingMode.equals("name") ? 1 : 0) != 0, (String)"Column mapping mode must be 'name' for Iceberg compatibility: %s", (Object)columnMappingMode);
                return ColumnMappingMode.NAME;
            }
            if (protocolEntry.supportsReaderFeatures() && protocolEntry.supportsWriterFeatures()) {
                boolean supportsColumnMappingWriter;
                boolean supportsColumnMappingReader = protocolEntry.readerFeaturesContains("columnMapping");
                Preconditions.checkArgument((supportsColumnMappingReader == (supportsColumnMappingWriter = protocolEntry.writerFeaturesContains("columnMapping")) ? 1 : 0) != 0, (String)"Both reader and writer features must have the same value for 'columnMapping'. reader: %s, writer: %s", (Object)supportsColumnMappingReader, (Object)supportsColumnMappingWriter);
                if (!supportsColumnMappingReader) {
                    return ColumnMappingMode.NONE;
                }
            }
        }
        String columnMappingMode = metadata.getConfiguration().getOrDefault(COLUMN_MAPPING_MODE_CONFIGURATION_KEY, "none");
        return (ColumnMappingMode)((Object)Enums.getIfPresent(ColumnMappingMode.class, (String)columnMappingMode.toUpperCase(Locale.ENGLISH)).or((Object)ColumnMappingMode.UNKNOWN));
    }

    public static IsolationLevel getIsolationLevel(MetadataEntry metadata) {
        String isolationLevel = metadata.getConfiguration().getOrDefault(ISOLATION_LEVEL_CONFIGURATION_KEY, IsolationLevel.WRITESERIALIZABLE.getValue());
        return (IsolationLevel)((Object)Enums.getIfPresent(IsolationLevel.class, (String)isolationLevel.toUpperCase(Locale.ENGLISH)).toJavaUtil().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported isolation level '%s'".formatted(isolationLevel))));
    }

    public static int getMaxColumnId(MetadataEntry metadata) {
        String maxColumnId = metadata.getConfiguration().get(MAX_COLUMN_ID_CONFIGURATION_KEY);
        Objects.requireNonNull(maxColumnId, "delta.columnMapping.maxColumnId metadata configuration property not found");
        return Integer.parseInt(maxColumnId);
    }

    public static List<DeltaLakeColumnHandle> extractPartitionColumns(MetadataEntry metadataEntry, ProtocolEntry protocolEntry, TypeManager typeManager) {
        return DeltaLakeSchemaSupport.extractPartitionColumns(DeltaLakeSchemaSupport.extractSchema(metadataEntry, protocolEntry, typeManager), metadataEntry.getOriginalPartitionColumns());
    }

    public static List<DeltaLakeColumnHandle> extractPartitionColumns(List<DeltaLakeColumnMetadata> schema, List<String> originalPartitionColumns) {
        if (originalPartitionColumns.isEmpty()) {
            return ImmutableList.of();
        }
        return (List)schema.stream().filter(entry -> originalPartitionColumns.contains(entry.name())).map(entry -> new DeltaLakeColumnHandle(entry.name(), entry.type(), OptionalInt.empty(), entry.physicalName(), entry.physicalColumnType(), DeltaLakeColumnType.PARTITION_KEY, Optional.empty())).collect(ImmutableList.toImmutableList());
    }

    public static String serializeSchemaAsJson(DeltaLakeTable deltaTable) {
        try {
            return OBJECT_MAPPER.writeValueAsString(DeltaLakeSchemaSupport.serializeStructType(deltaTable));
        }
        catch (JsonProcessingException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, DeltaLakeSchemaSupport.getLocation(e), "Failed to encode Delta Lake schema", (Throwable)e);
        }
    }

    private static Map<String, Object> serializeStructType(DeltaLakeTable deltaTable) {
        ImmutableMap.Builder schema = ImmutableMap.builder();
        schema.put((Object)"type", (Object)"struct");
        schema.put((Object)"fields", deltaTable.columns().stream().map(column -> DeltaLakeSchemaSupport.serializeStructField(column.name(), column.type(), column.comment(), column.nullable(), column.metadata())).collect(ImmutableList.toImmutableList()));
        return schema.buildOrThrow();
    }

    private static Map<String, Object> serializeStructField(String name, Object type, @Nullable String comment, boolean nullable, @Nullable Map<String, Object> metadata) {
        ImmutableMap.Builder fieldContents = ImmutableMap.builder();
        fieldContents.put((Object)"name", (Object)name);
        fieldContents.put((Object)"type", type);
        fieldContents.put((Object)"nullable", (Object)nullable);
        ImmutableMap.Builder columnMetadata = ImmutableMap.builder();
        if (comment != null) {
            columnMetadata.put((Object)"comment", (Object)comment);
        }
        if (metadata != null) {
            metadata.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("comment")).forEach(entry -> columnMetadata.put((Object)((String)entry.getKey()), entry.getValue()));
        }
        fieldContents.put((Object)"metadata", (Object)columnMetadata.buildOrThrow());
        return fieldContents.buildOrThrow();
    }

    public static Object serializeColumnType(ColumnMappingMode columnMappingMode, AtomicInteger maxColumnId, Type columnType) {
        if (columnType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)columnType;
            return DeltaLakeSchemaSupport.serializeArrayType(columnMappingMode, maxColumnId, arrayType);
        }
        if (columnType instanceof RowType) {
            RowType rowType = (RowType)columnType;
            return DeltaLakeSchemaSupport.serializeStructType(columnMappingMode, maxColumnId, rowType);
        }
        if (columnType instanceof MapType) {
            MapType mapType = (MapType)columnType;
            return DeltaLakeSchemaSupport.serializeMapType(columnMappingMode, maxColumnId, mapType);
        }
        return DeltaLakeSchemaSupport.serializePrimitiveType(columnType);
    }

    private static Map<String, Object> serializeArrayType(ColumnMappingMode columnMappingMode, AtomicInteger maxColumnId, ArrayType arrayType) {
        ImmutableMap.Builder fields = ImmutableMap.builder();
        fields.put((Object)"type", (Object)"array");
        fields.put((Object)"elementType", DeltaLakeSchemaSupport.serializeColumnType(columnMappingMode, maxColumnId, arrayType.getElementType()));
        fields.put((Object)"containsNull", (Object)true);
        return fields.buildOrThrow();
    }

    private static Map<String, Object> serializeMapType(ColumnMappingMode columnMappingMode, AtomicInteger maxColumnId, MapType mapType) {
        ImmutableMap.Builder fields = ImmutableMap.builder();
        fields.put((Object)"type", (Object)"map");
        fields.put((Object)"keyType", DeltaLakeSchemaSupport.serializeColumnType(columnMappingMode, maxColumnId, mapType.getKeyType()));
        fields.put((Object)"valueType", DeltaLakeSchemaSupport.serializeColumnType(columnMappingMode, maxColumnId, mapType.getValueType()));
        fields.put((Object)"valueContainsNull", (Object)true);
        return fields.buildOrThrow();
    }

    private static Map<String, Object> serializeStructType(ColumnMappingMode columnMappingMode, AtomicInteger maxColumnId, RowType rowType) {
        HashSet fieldNames = new HashSet();
        ImmutableMap.Builder fields = ImmutableMap.builder();
        fields.put((Object)"type", (Object)"struct");
        fields.put((Object)"fields", rowType.getFields().stream().map(field -> {
            String name = (String)field.getName().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Row type field does not have a name: " + rowType.getDisplayName()));
            if (!fieldNames.add(name.toLowerCase(Locale.ENGLISH))) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_COLUMN_NAME, "Field name '%s' specified more than once".formatted(name.toLowerCase(Locale.ENGLISH)));
            }
            Object fieldType = DeltaLakeSchemaSupport.serializeColumnType(columnMappingMode, maxColumnId, field.getType());
            Map<String, Object> metadata = DeltaLakeSchemaSupport.generateColumnMetadata(columnMappingMode, maxColumnId);
            return DeltaLakeSchemaSupport.serializeStructField(name, fieldType, null, true, metadata);
        }).collect(ImmutableList.toImmutableList()));
        return fields.buildOrThrow();
    }

    public static Map<String, Object> generateColumnMetadata(ColumnMappingMode columnMappingMode, AtomicInteger maxColumnId) {
        return switch (columnMappingMode.ordinal()) {
            case 2 -> {
                Verify.verify((maxColumnId.get() == 0 ? 1 : 0) != 0, (String)"maxColumnId must be 0 for column mapping mode 'none'", (Object[])new Object[0]);
                yield ImmutableMap.of();
            }
            case 0, 1 -> ImmutableMap.builder().put((Object)"delta.columnMapping.id", (Object)maxColumnId.incrementAndGet()).put((Object)COLUMN_MAPPING_PHYSICAL_NAME_CONFIGURATION_KEY, (Object)("col-" + String.valueOf(UUID.randomUUID()))).buildOrThrow();
            default -> throw new IllegalArgumentException("Unexpected column mapping mode: " + String.valueOf((Object)columnMappingMode));
        };
    }

    private static String serializePrimitiveType(Type type) {
        return DeltaLakeSchemaSupport.serializeSupportedPrimitiveType(type).orElseThrow(() -> new TypeNotFoundException(type.getTypeSignature()));
    }

    private static Optional<String> serializeSupportedPrimitiveType(Type type) {
        if (type instanceof TimestampType) {
            return Optional.of("timestamp_ntz");
        }
        if (type instanceof TimestampWithTimeZoneType) {
            return Optional.of("timestamp");
        }
        if (type instanceof VarcharType) {
            return Optional.of("string");
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return Optional.of(String.format("decimal(%s,%s)", decimalType.getPrecision(), decimalType.getScale()));
        }
        return Optional.ofNullable(PRIMITIVE_TYPE_MAPPING.get(type));
    }

    public static void validateType(Type type) {
        DeltaLakeSchemaSupport.validateType(Optional.empty(), type);
    }

    private static void validateType(Optional<Type> rootType, Type type) {
        if (HiveUtil.isStructuralType((Type)type)) {
            DeltaLakeSchemaSupport.validateStructuralType(Optional.of(rootType.orElse(type)), type);
        } else {
            DeltaLakeSchemaSupport.validatePrimitiveType(type);
        }
    }

    private static void validateStructuralType(Optional<Type> rootType, Type type) {
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            DeltaLakeSchemaSupport.validateType(rootType, arrayType.getElementType());
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            DeltaLakeSchemaSupport.validateType(rootType, mapType.getKeyType());
            DeltaLakeSchemaSupport.validateType(rootType, mapType.getValueType());
        }
        if (type instanceof RowType) {
            RowType rowType = (RowType)type;
            rowType.getFields().forEach(field -> DeltaLakeSchemaSupport.validateType(rootType, field.getType()));
        }
    }

    private static void validatePrimitiveType(Type type) {
        TimestampWithTimeZoneType timestampWithTimeZoneType;
        TimestampType timestampType;
        if (DeltaLakeSchemaSupport.serializeSupportedPrimitiveType(type).isEmpty() || type instanceof TimestampType && (timestampType = (TimestampType)type).getPrecision() != 6 || type instanceof TimestampWithTimeZoneType && (timestampWithTimeZoneType = (TimestampWithTimeZoneType)type).getPrecision() != 3) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, "Unsupported type: " + String.valueOf(type));
        }
    }

    public static String serializeStatsAsJson(DeltaLakeFileStatistics fileStatistics) throws JsonProcessingException {
        return OBJECT_MAPPER.writeValueAsString((Object)fileStatistics);
    }

    public static List<ColumnMetadata> extractColumnMetadata(MetadataEntry metadataEntry, ProtocolEntry protocolEntry, TypeManager typeManager) {
        return (List)DeltaLakeSchemaSupport.extractSchema(metadataEntry, protocolEntry, typeManager).stream().map(DeltaLakeColumnMetadata::columnMetadata).collect(ImmutableList.toImmutableList());
    }

    public static List<DeltaLakeColumnMetadata> extractSchema(MetadataEntry metadataEntry, ProtocolEntry protocolEntry, TypeManager typeManager) {
        ColumnMappingMode mappingMode = DeltaLakeSchemaSupport.getColumnMappingMode(metadataEntry, protocolEntry);
        DeltaLakeSchemaSupport.verifySupportedColumnMapping(mappingMode);
        return Optional.ofNullable(metadataEntry.getSchemaString()).map(json -> DeltaLakeSchemaSupport.getColumnMetadata(json, typeManager, mappingMode, metadataEntry.getOriginalPartitionColumns())).orElseThrow(() -> new IllegalStateException("Serialized schema not found in transaction log for " + metadataEntry.getName()));
    }

    public static void verifySupportedColumnMapping(ColumnMappingMode mappingMode) {
        if (mappingMode != ColumnMappingMode.ID && mappingMode != ColumnMappingMode.NAME && mappingMode != ColumnMappingMode.NONE) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Only 'id', 'name' or 'none' is supported for the '%s' table property", COLUMN_MAPPING_MODE_CONFIGURATION_KEY));
        }
    }

    public static List<DeltaLakeColumnMetadata> getColumnMetadata(String json, TypeManager typeManager, ColumnMappingMode mappingMode, List<String> partitionColumns) {
        try {
            ImmutableList.Builder columns = ImmutableList.builder();
            Iterator nodes = OBJECT_MAPPER.readTree(json).get("fields").elements();
            while (nodes.hasNext()) {
                try {
                    columns.add((Object)DeltaLakeSchemaSupport.mapColumn(typeManager, (JsonNode)nodes.next(), mappingMode, partitionColumns));
                }
                catch (UnsupportedTypeException e) {
                    log.debug("Skip unsupported column type: %s", new Object[]{e.getMessage()});
                }
            }
            return columns.build();
        }
        catch (JsonProcessingException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, DeltaLakeSchemaSupport.getLocation(e), "Failed to parse serialized schema: " + json, (Throwable)e);
        }
    }

    private static DeltaLakeColumnMetadata mapColumn(TypeManager typeManager, JsonNode node, ColumnMappingMode mappingMode, List<String> partitionColumns) throws UnsupportedTypeException {
        String physicalName;
        String fieldName = node.get("name").asText();
        JsonNode typeNode = node.get("type");
        boolean nullable = node.get("nullable").asBoolean();
        Type columnType = DeltaLakeSchemaSupport.buildType(typeManager, typeNode, false);
        OptionalInt fieldId = OptionalInt.empty();
        JsonNode metadata = node.get("metadata");
        DeltaLakeSchemaSupport.verifyTypeChanges(metadata, typeNode, partitionColumns.contains(fieldName));
        Type physicalColumnType = switch (mappingMode.ordinal()) {
            case 0 -> {
                String columnMappingId = metadata.get("delta.columnMapping.id").asText();
                Verify.verify((!Strings.isNullOrEmpty((String)columnMappingId) ? 1 : 0) != 0, (String)"id is null or empty", (Object[])new Object[0]);
                fieldId = OptionalInt.of(Integer.parseInt(columnMappingId));
                physicalName = metadata.get(COLUMN_MAPPING_PHYSICAL_NAME_CONFIGURATION_KEY).asText();
                Verify.verify((!Strings.isNullOrEmpty((String)physicalName) ? 1 : 0) != 0, (String)"physicalName is null or empty", (Object[])new Object[0]);
                yield DeltaLakeSchemaSupport.buildType(typeManager, typeNode, true);
            }
            case 1 -> {
                physicalName = metadata.get(COLUMN_MAPPING_PHYSICAL_NAME_CONFIGURATION_KEY).asText();
                Verify.verify((!Strings.isNullOrEmpty((String)physicalName) ? 1 : 0) != 0, (String)"physicalName is null or empty", (Object[])new Object[0]);
                yield DeltaLakeSchemaSupport.buildType(typeManager, typeNode, true);
            }
            default -> {
                physicalName = fieldName;
                yield columnType;
            }
        };
        ColumnMetadata columnMetadata = ColumnMetadata.builder().setName(fieldName).setType(columnType).setNullable(nullable).setComment(Optional.ofNullable(DeltaLakeSchemaSupport.getComment(node))).build();
        return new DeltaLakeColumnMetadata(columnMetadata, fieldName, fieldId, physicalName, physicalColumnType);
    }

    private static void verifyTypeChanges(JsonNode metadata, JsonNode typeNode, boolean isPartitionColumn) throws UnsupportedTypeException {
        if (DeltaLakeSchemaSupport.isStruct(typeNode)) {
            DeltaLakeSchemaSupport.verifyStructTypeChanges(typeNode);
        } else if (!isPartitionColumn) {
            DeltaLakeSchemaSupport.verifyTypeChanges(metadata);
        }
    }

    private static void verifyTypeChanges(JsonNode metadata) throws UnsupportedTypeException {
        if (metadata.has("delta.typeChanges")) {
            Iterator typeChanges = metadata.get("delta.typeChanges").elements();
            while (typeChanges.hasNext()) {
                DeltaLakeSchemaSupport.verifyTypeChange((JsonNode)typeChanges.next());
            }
        }
    }

    private static void verifyStructTypeChanges(JsonNode container) throws UnsupportedTypeException {
        Iterator fields = container.get("fields").elements();
        while (fields.hasNext()) {
            JsonNode field = (JsonNode)fields.next();
            JsonNode fieldMetadata = field.get("metadata");
            JsonNode typeNode = field.get("type");
            DeltaLakeSchemaSupport.verifyTypeChanges(fieldMetadata, typeNode, false);
        }
    }

    private static void verifyTypeChange(JsonNode typeChange) throws UnsupportedTypeException {
        String fromType = typeChange.get("fromType").asText();
        String toType = typeChange.get("toType").asText();
        if (fromType.equals("byte") && (toType.equals("short") || toType.equals("integer")) || fromType.equals("short") && toType.equals("integer")) {
            return;
        }
        throw new UnsupportedTypeException(fromType, toType);
    }

    private static boolean isStruct(JsonNode typeNode) {
        return typeNode.isContainerNode() && Objects.equals(typeNode.get("type").asText(), "struct");
    }

    public static Map<String, Object> getColumnTypes(MetadataEntry metadataEntry) {
        return DeltaLakeSchemaSupport.getColumnProperties(metadataEntry, node -> OBJECT_MAPPER.convertValue((Object)node.get("type"), (TypeReference)new TypeReference<Object>(){}));
    }

    public static Map<String, String> getColumnComments(MetadataEntry metadataEntry) {
        return DeltaLakeSchemaSupport.getColumnProperties(metadataEntry, DeltaLakeSchemaSupport::getComment);
    }

    @Nullable
    private static String getComment(JsonNode node) {
        JsonNode comment = node.get("metadata").get("comment");
        return comment == null ? null : comment.asText();
    }

    public static Map<String, Boolean> getColumnsNullability(MetadataEntry metadataEntry) {
        return DeltaLakeSchemaSupport.getColumnProperties(metadataEntry, node -> node.get("nullable").asBoolean());
    }

    public static Map<String, Boolean> getColumnIdentities(MetadataEntry metadataEntry, ProtocolEntry protocolEntry) {
        if (protocolEntry.supportsWriterFeatures() && !protocolEntry.writerFeaturesContains("identityColumns")) {
            return ImmutableMap.of();
        }
        return DeltaLakeSchemaSupport.getColumnProperties(metadataEntry, DeltaLakeSchemaSupport::isIdentityColumn);
    }

    private static boolean isIdentityColumn(JsonNode node) {
        return Streams.stream((Iterator)node.get("metadata").fieldNames()).anyMatch(name -> name.startsWith("delta.identity."));
    }

    public static Map<String, String> getColumnInvariants(MetadataEntry metadataEntry, ProtocolEntry protocolEntry) {
        if (protocolEntry.supportsWriterFeatures()) {
            if (!protocolEntry.writerFeaturesContains("invariants")) {
                return ImmutableMap.of();
            }
            return DeltaLakeSchemaSupport.getColumnProperties(metadataEntry, DeltaLakeSchemaSupport::getInvariantsWriterFeature);
        }
        return DeltaLakeSchemaSupport.getColumnProperties(metadataEntry, DeltaLakeSchemaSupport::getInvariants);
    }

    @Nullable
    private static String getInvariantsWriterFeature(JsonNode node) {
        JsonNode invariants = node.get("metadata").get("delta.invariants");
        return invariants == null ? null : invariants.asText();
    }

    @Nullable
    private static String getInvariants(JsonNode node) {
        JsonNode invariants = node.get("metadata").get("delta.invariants");
        return invariants == null ? null : DeltaLakeSchemaSupport.extractInvariantsExpression(invariants.asText());
    }

    private static String extractInvariantsExpression(String invariants) {
        try {
            return OBJECT_MAPPER.readTree(invariants).get("expression").get("expression").asText();
        }
        catch (JsonProcessingException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, DeltaLakeSchemaSupport.getLocation(e), "Failed to parse invariants expression: " + invariants, (Throwable)e);
        }
    }

    public static Map<String, String> getGeneratedColumnExpressions(MetadataEntry metadataEntry) {
        return DeltaLakeSchemaSupport.getColumnProperties(metadataEntry, DeltaLakeSchemaSupport::getGeneratedColumnExpressions);
    }

    @Nullable
    private static String getGeneratedColumnExpressions(JsonNode node) {
        JsonNode generationExpression = node.get("metadata").get("delta.generationExpression");
        return generationExpression == null ? null : generationExpression.asText();
    }

    public static Map<String, String> getCheckConstraints(MetadataEntry metadataEntry, ProtocolEntry protocolEntry) {
        if (protocolEntry.supportsWriterFeatures() && !protocolEntry.writerFeaturesContains("checkConstraints")) {
            return ImmutableMap.of();
        }
        return (Map)metadataEntry.getConfiguration().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("delta.constraints.")).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static Optional<Boolean> changeDataFeedEnabled(MetadataEntry metadataEntry, ProtocolEntry protocolEntry) {
        if (protocolEntry.supportsWriterFeatures() && !protocolEntry.writerFeaturesContains("changeDataFeed")) {
            return Optional.empty();
        }
        String enableChangeDataFeed = metadataEntry.getConfiguration().get("delta.enableChangeDataFeed");
        if (enableChangeDataFeed == null) {
            return Optional.empty();
        }
        return Optional.of(Boolean.parseBoolean(enableChangeDataFeed));
    }

    public static Map<String, Map<String, Object>> getColumnsMetadata(MetadataEntry metadataEntry) {
        return DeltaLakeSchemaSupport.getColumnProperties(metadataEntry, node -> (Map)OBJECT_MAPPER.convertValue((Object)node.get("metadata"), (TypeReference)new TypeReference<Map<String, Object>>(){}));
    }

    public static <T> Map<String, T> getColumnProperties(MetadataEntry metadataEntry, Function<JsonNode, T> extractor) {
        return Optional.ofNullable(metadataEntry.getSchemaString()).map(json -> DeltaLakeSchemaSupport.getColumnProperty(json, extractor)).orElseThrow(() -> new IllegalStateException("Serialized schema not found in transaction log for " + metadataEntry.getName()));
    }

    private static <T> Map<String, T> getColumnProperty(String json, Function<JsonNode, T> extractor) {
        try {
            return (Map)Streams.stream((Iterator)OBJECT_MAPPER.readTree(json).get("fields").elements()).map(field -> new AbstractMap.SimpleEntry(field.get("name").asText(), extractor.apply((JsonNode)field))).filter(entry -> entry.getValue() != null).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        catch (JsonProcessingException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, DeltaLakeSchemaSupport.getLocation(e), "Failed to parse serialized schema: " + json, (Throwable)e);
        }
    }

    public static List<String> getExactColumnNames(MetadataEntry metadataEntry) {
        try {
            return (List)Streams.stream((Iterator)OBJECT_MAPPER.readTree(metadataEntry.getSchemaString()).get("fields").elements()).map(field -> field.get("name").asText()).collect(ImmutableList.toImmutableList());
        }
        catch (JsonProcessingException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, DeltaLakeSchemaSupport.getLocation(e), "Failed to parse serialized schema: " + metadataEntry.getSchemaString(), (Throwable)e);
        }
    }

    public static Type deserializeType(TypeManager typeManager, Object type, boolean usePhysicalName) throws UnsupportedTypeException {
        try {
            String json = OBJECT_MAPPER.writeValueAsString(type);
            return DeltaLakeSchemaSupport.buildType(typeManager, OBJECT_MAPPER.readTree(json), usePhysicalName);
        }
        catch (JsonProcessingException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, "Failed to deserialize type: " + String.valueOf(type));
        }
    }

    private static Type buildType(TypeManager typeManager, JsonNode typeNode, boolean usePhysicalName) throws UnsupportedTypeException {
        if (typeNode.isContainerNode()) {
            return DeltaLakeSchemaSupport.buildContainerType(typeManager, typeNode, usePhysicalName);
        }
        String primitiveType = typeNode.asText();
        if (primitiveType.startsWith("decimal")) {
            return typeManager.fromSqlType(primitiveType);
        }
        return switch (primitiveType) {
            case "string" -> VarcharType.VARCHAR;
            case "long" -> BigintType.BIGINT;
            case "integer" -> IntegerType.INTEGER;
            case "short" -> SmallintType.SMALLINT;
            case "byte" -> TinyintType.TINYINT;
            case "float" -> RealType.REAL;
            case "double" -> DoubleType.DOUBLE;
            case "boolean" -> BooleanType.BOOLEAN;
            case "binary" -> VarbinaryType.VARBINARY;
            case "date" -> DateType.DATE;
            case "timestamp_ntz" -> TimestampType.TIMESTAMP_MICROS;
            case "timestamp" -> TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS;
            case "variant" -> typeManager.getType(new TypeSignature("json", new TypeSignatureParameter[0]));
            default -> throw new TypeNotFoundException(new TypeSignature(primitiveType, new TypeSignatureParameter[0]));
        };
    }

    private static Type buildContainerType(TypeManager typeManager, JsonNode typeNode, boolean usePhysicalName) throws UnsupportedTypeException {
        String containerType;
        return switch (containerType = typeNode.get("type").asText()) {
            case "array" -> DeltaLakeSchemaSupport.buildArrayType(typeManager, typeNode, usePhysicalName);
            case "map" -> DeltaLakeSchemaSupport.buildMapType(typeManager, typeNode, usePhysicalName);
            case "struct" -> DeltaLakeSchemaSupport.buildRowType(typeManager, typeNode, usePhysicalName);
            default -> throw new TypeNotFoundException(new TypeSignature(containerType, new TypeSignatureParameter[0]));
        };
    }

    private static RowType buildRowType(TypeManager typeManager, JsonNode typeNode, boolean usePhysicalName) throws UnsupportedTypeException {
        ImmutableList.Builder fields = ImmutableList.builder();
        Iterator elements = typeNode.get("fields").elements();
        while (elements.hasNext()) {
            JsonNode element = (JsonNode)elements.next();
            String fieldName = usePhysicalName ? element.get("metadata").get(COLUMN_MAPPING_PHYSICAL_NAME_CONFIGURATION_KEY).asText() : element.get("name").asText();
            Verify.verify((!Strings.isNullOrEmpty((String)fieldName) ? 1 : 0) != 0, (String)"fieldName is null or empty", (Object[])new Object[0]);
            fields.add((Object)TypeSignatureParameter.namedField((String)TransactionLogAccess.canonicalizeColumnName(fieldName), (TypeSignature)DeltaLakeSchemaSupport.buildType(typeManager, element.get("type"), usePhysicalName).getTypeSignature()));
        }
        return (RowType)typeManager.getType(TypeSignature.rowType((List)fields.build()));
    }

    private static ArrayType buildArrayType(TypeManager typeManager, JsonNode typeNode, boolean usePhysicalName) throws UnsupportedTypeException {
        return (ArrayType)typeManager.getType(TypeSignature.arrayType((TypeSignature)DeltaLakeSchemaSupport.buildType(typeManager, typeNode.get("elementType"), usePhysicalName).getTypeSignature()));
    }

    private static MapType buildMapType(TypeManager typeManager, JsonNode typeNode, boolean usePhysicalName) throws UnsupportedTypeException {
        return (MapType)typeManager.getType(TypeSignature.mapType((TypeSignature)DeltaLakeSchemaSupport.buildType(typeManager, typeNode.get("keyType"), usePhysicalName).getTypeSignature(), (TypeSignature)DeltaLakeSchemaSupport.buildType(typeManager, typeNode.get("valueType"), usePhysicalName).getTypeSignature()));
    }

    private static Optional<Location> getLocation(JsonProcessingException e) {
        return Optional.ofNullable(e.getLocation()).map(location -> new Location(location.getLineNr(), location.getColumnNr()));
    }

    public static enum ColumnMappingMode {
        ID,
        NAME,
        NONE,
        UNKNOWN;

    }

    public static enum IsolationLevel {
        WRITESERIALIZABLE("WriteSerializable"),
        SERIALIZABLE("Serializable");

        private final String value;

        private IsolationLevel(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class UnsupportedTypeException
    extends Exception {
        public UnsupportedTypeException(String fromType, String toType) {
            super("Type change from '%s' to '%s' is not supported".formatted(Objects.requireNonNull(fromType, "fromType is null"), Objects.requireNonNull(toType, "toType is null")));
        }
    }
}

