/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog;

import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import io.airlift.slice.SizeOf;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public record ProtocolEntry(int minReaderVersion, int minWriterVersion, Optional<Set<String>> readerFeatures, Optional<Set<String>> writerFeatures) {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(ProtocolEntry.class);

    public ProtocolEntry {
        if (minReaderVersion < 3 && readerFeatures.isPresent()) {
            throw new IllegalArgumentException("readerFeatures must not exist when minReaderVersion is less than 3");
        }
        if (minWriterVersion < 7 && writerFeatures.isPresent()) {
            throw new IllegalArgumentException("writerFeatures must not exist when minWriterVersion is less than 7");
        }
        readerFeatures = Objects.requireNonNull(readerFeatures, "readerFeatures is null").map(ImmutableSet::copyOf);
        writerFeatures = Objects.requireNonNull(writerFeatures, "writerFeatures is null").map(ImmutableSet::copyOf);
    }

    public boolean supportsReaderFeatures() {
        return this.minReaderVersion >= 3;
    }

    public boolean readerFeaturesContains(String featureName) {
        return this.readerFeatures.map(features -> features.contains(featureName)).orElse(false);
    }

    public boolean supportsWriterFeatures() {
        return this.minWriterVersion >= 7;
    }

    public boolean writerFeaturesContains(String featureName) {
        return this.writerFeatures.map(features -> features.contains(featureName)).orElse(false);
    }

    public long getRetainedSizeInBytes() {
        return (long)(INSTANCE_SIZE + 4 + 4) + SizeOf.sizeOf(this.readerFeatures, features -> SizeOf.estimatedSizeOf((Set)features, SizeOf::estimatedSizeOf)) + SizeOf.sizeOf(this.writerFeatures, features -> SizeOf.estimatedSizeOf((Set)features, SizeOf::estimatedSizeOf));
    }

    public static Builder builder(ProtocolEntry protocolEntry) {
        return new Builder(protocolEntry.minReaderVersion, protocolEntry.minWriterVersion, protocolEntry.readerFeatures, protocolEntry.writerFeatures);
    }

    public static Builder builder(int readerVersion, int writerVersion) {
        return new Builder(readerVersion, writerVersion, Optional.empty(), Optional.empty());
    }

    public static class Builder {
        private int readerVersion;
        private int writerVersion;
        private final Set<String> readerFeatures = new HashSet<String>();
        private final Set<String> writerFeatures = new HashSet<String>();

        private Builder(int readerVersion, int writerVersion, Optional<Set<String>> readerFeatures, Optional<Set<String>> writerFeatures) {
            this.readerVersion = readerVersion;
            this.writerVersion = writerVersion;
            Objects.requireNonNull(readerFeatures, "readerFeatures is null").ifPresent(this.readerFeatures::addAll);
            Objects.requireNonNull(writerFeatures, "writerFeatures is null").ifPresent(this.writerFeatures::addAll);
        }

        public Builder enableChangeDataFeed() {
            this.writerVersion = Ints.max((int[])new int[]{this.writerVersion, 4});
            this.writerFeatures.add("changeDataFeed");
            return this;
        }

        public Builder enableColumnMapping() {
            this.readerVersion = Ints.max((int[])new int[]{this.readerVersion, 2});
            this.writerVersion = Ints.max((int[])new int[]{this.writerVersion, 5});
            this.readerFeatures.add("columnMapping");
            this.writerFeatures.add("columnMapping");
            return this;
        }

        public Builder enableTimestampNtz() {
            this.readerVersion = Ints.max((int[])new int[]{this.readerVersion, 3});
            this.writerVersion = Ints.max((int[])new int[]{this.writerVersion, 7});
            this.readerFeatures.add("timestampNtz");
            this.writerFeatures.add("timestampNtz");
            return this;
        }

        public Builder enableDeletionVector() {
            this.readerVersion = Ints.max((int[])new int[]{this.readerVersion, 3});
            this.writerVersion = Ints.max((int[])new int[]{this.writerVersion, 7});
            this.readerFeatures.add("deletionVectors");
            this.writerFeatures.add("deletionVectors");
            return this;
        }

        public ProtocolEntry build() {
            return new ProtocolEntry(this.readerVersion, this.writerVersion, this.readerVersion < 3 || this.readerFeatures.isEmpty() ? Optional.empty() : Optional.of(this.readerFeatures), this.writerVersion < 7 || this.writerFeatures.isEmpty() ? Optional.empty() : Optional.of(this.writerFeatures));
        }
    }
}

