/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog.checkpoint;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MoreCollectors;
import com.google.common.math.LongMath;
import io.airlift.log.Logger;
import io.trino.filesystem.TrinoInputFile;
import io.trino.parquet.ParquetReaderOptions;
import io.trino.plugin.base.metrics.FileFormatDataSourceStats;
import io.trino.plugin.deltalake.DeltaHiveTypeTranslator;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnMetadata;
import io.trino.plugin.deltalake.DeltaLakeColumnType;
import io.trino.plugin.deltalake.DeltaLakeErrorCode;
import io.trino.plugin.deltalake.transactionlog.AddFileEntry;
import io.trino.plugin.deltalake.transactionlog.DeletionVectorEntry;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeSchemaSupport;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeTransactionLogEntry;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import io.trino.plugin.deltalake.transactionlog.RemoveFileEntry;
import io.trino.plugin.deltalake.transactionlog.SidecarEntry;
import io.trino.plugin.deltalake.transactionlog.TransactionEntry;
import io.trino.plugin.deltalake.transactionlog.TransactionLogAccess;
import io.trino.plugin.deltalake.transactionlog.TransactionLogParser;
import io.trino.plugin.deltalake.transactionlog.TransactionLogUtil;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointFieldReader;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointSchemaManager;
import io.trino.plugin.deltalake.transactionlog.statistics.DeltaLakeParquetFileStatistics;
import io.trino.plugin.deltalake.util.DeltaLakeDomains;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveColumnProjectionInfo;
import io.trino.plugin.hive.parquet.ParquetPageSourceFactory;
import io.trino.plugin.hive.util.HiveTypeTranslator;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.block.RowBlock;
import io.trino.spi.block.SqlRow;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SourcePage;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeUtils;
import io.trino.spi.type.VarcharType;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.RoundingMode;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Queue;
import java.util.Set;
import java.util.function.Predicate;
import org.joda.time.DateTimeZone;

public class CheckpointEntryIterator
extends AbstractIterator<DeltaLakeTransactionLogEntry> {
    private static final Logger log = Logger.get(CheckpointEntryIterator.class);
    private final String checkpointPath;
    private final ConnectorSession session;
    private final ConnectorPageSource pageSource;
    private final MapType stringMap;
    private final ArrayType stringList;
    private final Queue<DeltaLakeTransactionLogEntry> nextEntries;
    private final List<CheckpointFieldExtractor> extractors;
    private final boolean checkpointRowStatisticsWritingEnabled;
    private final TupleDomain<DeltaLakeColumnHandle> partitionConstraint;
    private final Optional<RowType> txnType;
    private final Optional<RowType> addType;
    private final Optional<RowType> addDeletionVectorType;
    private final Optional<RowType> addParsedStatsFieldType;
    private final Optional<RowType> removeType;
    private final Optional<RowType> removeDeletionVectorType;
    private final Optional<RowType> metadataType;
    private final Optional<RowType> protocolType;
    private final Optional<RowType> sidecarType;
    private MetadataEntry metadataEntry;
    private ProtocolEntry protocolEntry;
    private boolean deletionVectorsEnabled;
    private List<DeltaLakeColumnMetadata> schema;
    private List<DeltaLakeColumnMetadata> columnsWithMinMaxStats;
    private SourcePage page;
    private int pagePosition;

    public CheckpointEntryIterator(TrinoInputFile checkpoint, ConnectorSession session, long fileSize, CheckpointSchemaManager checkpointSchemaManager, TypeManager typeManager, Set<EntryType> fields, Optional<MetadataEntry> metadataEntry, Optional<ProtocolEntry> protocolEntry, FileFormatDataSourceStats stats, ParquetReaderOptions parquetReaderOptions, boolean checkpointRowStatisticsWritingEnabled, int domainCompactionThreshold, TupleDomain<DeltaLakeColumnHandle> partitionConstraint, Optional<Predicate<String>> addStatsMinMaxColumnFilter) {
        this.checkpointPath = checkpoint.location().toString();
        this.session = Objects.requireNonNull(session, "session is null");
        this.stringList = (ArrayType)typeManager.getType(TypeSignature.arrayType((TypeSignature)VarcharType.VARCHAR.getTypeSignature()));
        this.stringMap = (MapType)typeManager.getType(TypeSignature.mapType((TypeSignature)VarcharType.VARCHAR.getTypeSignature(), (TypeSignature)VarcharType.VARCHAR.getTypeSignature()));
        this.checkpointRowStatisticsWritingEnabled = checkpointRowStatisticsWritingEnabled;
        this.partitionConstraint = Objects.requireNonNull(partitionConstraint, "partitionConstraint is null");
        Objects.requireNonNull(addStatsMinMaxColumnFilter, "addStatsMinMaxColumnFilter is null");
        Preconditions.checkArgument((!fields.isEmpty() ? 1 : 0) != 0, (Object)"fields is empty");
        if (fields.contains((Object)EntryType.ADD)) {
            Preconditions.checkArgument((boolean)metadataEntry.isPresent(), (Object)"Metadata entry must be provided when reading ADD entries from Checkpoint files");
            this.metadataEntry = metadataEntry.get();
            Preconditions.checkArgument((boolean)protocolEntry.isPresent(), (Object)"Protocol entry must be provided when reading ADD entries from Checkpoint files");
            this.protocolEntry = protocolEntry.get();
            this.deletionVectorsEnabled = DeltaLakeSchemaSupport.isDeletionVectorEnabled(this.metadataEntry, this.protocolEntry);
            Preconditions.checkArgument((boolean)addStatsMinMaxColumnFilter.isPresent(), (Object)"addStatsMinMaxColumnFilter must be provided when reading ADD entries from Checkpoint files");
            this.schema = DeltaLakeSchemaSupport.extractSchema(this.metadataEntry, this.protocolEntry, typeManager);
            this.columnsWithMinMaxStats = TransactionLogAccess.columnsWithStats(this.schema, this.metadataEntry.getOriginalPartitionColumns());
            Predicate<String> columnStatsFilterFunction = addStatsMinMaxColumnFilter.orElseThrow();
            this.columnsWithMinMaxStats = (List)this.columnsWithMinMaxStats.stream().filter(column -> columnStatsFilterFunction.test(column.name())).collect(ImmutableList.toImmutableList());
        }
        ImmutableList.Builder columnsBuilder = ImmutableList.builderWithExpectedSize((int)fields.size());
        ImmutableList.Builder disjunctDomainsBuilder = ImmutableList.builderWithExpectedSize((int)fields.size());
        for (EntryType field : fields) {
            HiveColumnHandle column2 = CheckpointEntryIterator.buildColumnHandle(field, checkpointSchemaManager, this.metadataEntry, this.protocolEntry, addStatsMinMaxColumnFilter).toHiveColumnHandle();
            columnsBuilder.add((Object)column2);
            disjunctDomainsBuilder.add(this.buildTupleDomainColumnHandle(field, column2));
        }
        ImmutableList columns = columnsBuilder.build();
        this.pageSource = ParquetPageSourceFactory.createPageSource((TrinoInputFile)checkpoint, (long)0L, (long)fileSize, (List)columns, (List)disjunctDomainsBuilder.build(), (boolean)true, (DateTimeZone)DateTimeZone.UTC, (FileFormatDataSourceStats)stats, (ParquetReaderOptions)parquetReaderOptions, Optional.empty(), (int)domainCompactionThreshold, (OptionalLong)OptionalLong.of(fileSize));
        try {
            this.nextEntries = new ArrayDeque<DeltaLakeTransactionLogEntry>();
            this.extractors = (List)fields.stream().map(this::createCheckpointFieldExtractor).collect(ImmutableList.toImmutableList());
            this.txnType = CheckpointEntryIterator.getParquetType(fields, EntryType.TRANSACTION, (List<HiveColumnHandle>)columns);
            this.addType = CheckpointEntryIterator.getAddParquetTypeContainingField(fields, "path", (List<HiveColumnHandle>)columns);
            this.addDeletionVectorType = this.addType.flatMap(type -> CheckpointEntryIterator.getOptionalFieldType(type, "deletionVector"));
            this.addParsedStatsFieldType = this.addType.flatMap(type -> CheckpointEntryIterator.getOptionalFieldType(type, "stats_parsed"));
            this.removeType = CheckpointEntryIterator.getParquetType(fields, EntryType.REMOVE, (List<HiveColumnHandle>)columns);
            this.removeDeletionVectorType = this.removeType.flatMap(type -> CheckpointEntryIterator.getOptionalFieldType(type, "deletionVector"));
            this.metadataType = CheckpointEntryIterator.getParquetType(fields, EntryType.METADATA, (List<HiveColumnHandle>)columns);
            this.protocolType = CheckpointEntryIterator.getParquetType(fields, EntryType.PROTOCOL, (List<HiveColumnHandle>)columns);
            this.sidecarType = CheckpointEntryIterator.getParquetType(fields, EntryType.SIDECAR, (List<HiveColumnHandle>)columns);
        }
        catch (Exception e) {
            try {
                this.pageSource.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Error while initializing the checkpoint entry iterator for the file %s".formatted(checkpoint.location()), (Throwable)e);
        }
    }

    private static Optional<RowType> getOptionalFieldType(RowType type, String fieldName) {
        return ((Optional)type.getFields().stream().filter(field -> ((String)field.getName().orElseThrow()).equals(fieldName)).collect(MoreCollectors.toOptional())).map(RowType.Field::getType).map(RowType.class::cast);
    }

    private static Optional<RowType> getAddParquetTypeContainingField(Set<EntryType> fields, String fieldName, List<HiveColumnHandle> columns) {
        return fields.contains((Object)EntryType.ADD) ? ((Optional)columns.stream().filter(column -> {
            if (!column.getName().equals(EntryType.ADD.getColumnName())) return false;
            Type patt0$temp = column.getType();
            if (!(patt0$temp instanceof RowType)) return false;
            RowType rowType = (RowType)patt0$temp;
            if (!rowType.getFields().stream().map(RowType.Field::getName).filter(Optional::isPresent).flatMap(Optional::stream).anyMatch(fieldName::equals)) return false;
            return true;
        }).collect(MoreCollectors.toOptional())).map(HiveColumnHandle::getType).map(RowType.class::cast) : Optional.empty();
    }

    private static Optional<RowType> getParquetType(Set<EntryType> fields, EntryType field, List<HiveColumnHandle> columns) {
        return fields.contains((Object)field) ? CheckpointEntryIterator.getParquetType(field.getColumnName(), columns).map(RowType.class::cast) : Optional.empty();
    }

    private static Optional<Type> getParquetType(String columnName, List<HiveColumnHandle> columns) {
        return ((Optional)columns.stream().filter(column -> column.getName().equals(columnName)).collect(MoreCollectors.toOptional())).map(HiveColumnHandle::getType);
    }

    private CheckpointFieldExtractor createCheckpointFieldExtractor(EntryType entryType) {
        return switch (entryType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this::buildTxnEntry;
            case 1 -> new AddFileEntryExtractor();
            case 2 -> this::buildRemoveEntry;
            case 3 -> this::buildMetadataEntry;
            case 4 -> this::buildProtocolEntry;
            case 5 -> this::buildSidecarEntry;
        };
    }

    private static DeltaLakeColumnHandle buildColumnHandle(EntryType entryType, CheckpointSchemaManager schemaManager, MetadataEntry metadataEntry, ProtocolEntry protocolEntry, Optional<Predicate<String>> addStatsMinMaxColumnFilter) {
        RowType type = switch (entryType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> schemaManager.getTxnEntryType();
            case 1 -> schemaManager.getAddEntryType(metadataEntry, protocolEntry, addStatsMinMaxColumnFilter.orElseThrow(), true, true, true);
            case 2 -> schemaManager.getRemoveEntryType();
            case 3 -> schemaManager.getMetadataEntryType();
            case 4 -> schemaManager.getProtocolEntryType(true, true);
            case 5 -> schemaManager.getSidecarEntryType();
        };
        return new DeltaLakeColumnHandle(entryType.getColumnName(), (Type)type, OptionalInt.empty(), entryType.getColumnName(), (Type)type, DeltaLakeColumnType.REGULAR, Optional.empty());
    }

    private TupleDomain<HiveColumnHandle> buildTupleDomainColumnHandle(EntryType entryType, HiveColumnHandle column) {
        String field;
        BigintType type = switch (entryType.ordinal()) {
            case 0 -> {
                field = "version";
                yield BigintType.BIGINT;
            }
            case 1, 2, 5 -> {
                field = "path";
                yield VarcharType.VARCHAR;
            }
            case 3 -> {
                field = "id";
                yield VarcharType.VARCHAR;
            }
            case 4 -> {
                field = "minReaderVersion";
                yield BigintType.BIGINT;
            }
            default -> throw new IllegalArgumentException("Unsupported Delta Lake checkpoint entry type: " + String.valueOf((Object)entryType));
        };
        HiveColumnHandle handle = new HiveColumnHandle(column.getBaseColumnName(), column.getBaseHiveColumnIndex(), column.getBaseHiveType(), column.getBaseType(), Optional.of(new HiveColumnProjectionInfo((List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)field), HiveTypeTranslator.toHiveType((Type)type), (Type)type)), HiveColumnHandle.ColumnType.REGULAR, column.getComment());
        ImmutableMap.Builder domains = ImmutableMap.builder().put((Object)handle, (Object)Domain.notNull((Type)handle.getType()));
        if (entryType == EntryType.ADD) {
            ((Map)this.partitionConstraint.getDomains().orElseThrow()).forEach((key, value) -> domains.put((Object)CheckpointEntryIterator.toPartitionValuesParsedField(column, key), value));
        }
        return TupleDomain.withColumnDomains((Map)domains.buildOrThrow());
    }

    private static HiveColumnHandle toPartitionValuesParsedField(HiveColumnHandle addColumn, DeltaLakeColumnHandle partitionColumn) {
        Preconditions.checkArgument((boolean)partitionColumn.isBaseColumn(), (String)"partitionColumn must be a base column: %s", (Object)partitionColumn);
        return new HiveColumnHandle(addColumn.getBaseColumnName(), addColumn.getBaseHiveColumnIndex(), addColumn.getBaseHiveType(), addColumn.getBaseType(), Optional.of(new HiveColumnProjectionInfo((List)ImmutableList.of((Object)0, (Object)0), (List)ImmutableList.of((Object)"partitionvalues_parsed", (Object)partitionColumn.basePhysicalColumnName()), DeltaHiveTypeTranslator.toHiveType(partitionColumn.type()), partitionColumn.type())), HiveColumnHandle.ColumnType.REGULAR, addColumn.getComment());
    }

    private DeltaLakeTransactionLogEntry buildProtocolEntry(ConnectorSession session, int pagePosition, Block block) {
        log.debug("Building protocol entry from %s pagePosition %d", new Object[]{block, pagePosition});
        if (block.isNull(pagePosition)) {
            return null;
        }
        RowType type = this.protocolType.orElseThrow();
        int minProtocolFields = 2;
        int maxProtocolFields = 4;
        SqlRow protocolEntryRow = CheckpointEntryIterator.getRow(block, pagePosition);
        int fieldCount = protocolEntryRow.getFieldCount();
        log.debug("Block %s has %s fields", new Object[]{block, fieldCount});
        if (fieldCount < minProtocolFields || fieldCount > maxProtocolFields) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, String.format("Expected block %s to have between %d and %d children, but found %s", block, minProtocolFields, maxProtocolFields, fieldCount));
        }
        CheckpointFieldReader protocol = new CheckpointFieldReader(session, protocolEntryRow, type);
        ProtocolEntry result = new ProtocolEntry(protocol.getInt("minReaderVersion"), protocol.getInt("minWriterVersion"), protocol.getOptionalSet(this.stringList, "readerFeatures"), protocol.getOptionalSet(this.stringList, "writerFeatures"));
        log.debug("Result: %s", new Object[]{result});
        return DeltaLakeTransactionLogEntry.protocolEntry(result);
    }

    private DeltaLakeTransactionLogEntry buildMetadataEntry(ConnectorSession session, int pagePosition, Block block) {
        log.debug("Building metadata entry from %s pagePosition %d", new Object[]{block, pagePosition});
        if (block.isNull(pagePosition)) {
            return null;
        }
        RowType type = this.metadataType.orElseThrow();
        int metadataFields = 8;
        int formatFields = 2;
        SqlRow metadataEntryRow = CheckpointEntryIterator.getRow(block, pagePosition);
        CheckpointFieldReader metadata = new CheckpointFieldReader(session, metadataEntryRow, type);
        log.debug("Block %s has %s fields", new Object[]{block, metadataEntryRow.getFieldCount()});
        if (metadataEntryRow.getFieldCount() != metadataFields) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, String.format("Expected block %s to have %d children, but found %s", block, metadataFields, metadataEntryRow.getFieldCount()));
        }
        SqlRow formatRow = metadata.getRow("format");
        if (formatRow.getFieldCount() != formatFields) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, String.format("Expected block %s to have %d children, but found %s", formatRow, formatFields, formatRow.getFieldCount()));
        }
        RowType.Field formatField = (RowType.Field)type.getFields().stream().filter(field -> ((String)field.getName().orElseThrow()).equals("format")).collect(MoreCollectors.onlyElement());
        CheckpointFieldReader format = new CheckpointFieldReader(session, formatRow, (RowType)formatField.getType());
        MetadataEntry result = new MetadataEntry(metadata.getString("id"), metadata.getString("name"), metadata.getString("description"), new MetadataEntry.Format(format.getString("provider"), format.getMap(this.stringMap, "options")), metadata.getString("schemaString"), metadata.getList(this.stringList, "partitionColumns"), metadata.getMap(this.stringMap, "configuration"), metadata.getLong("createdTime"));
        log.debug("Result: %s", new Object[]{result});
        return DeltaLakeTransactionLogEntry.metadataEntry(result);
    }

    private DeltaLakeTransactionLogEntry buildRemoveEntry(ConnectorSession session, int pagePosition, Block block) {
        log.debug("Building remove entry from %s pagePosition %d", new Object[]{block, pagePosition});
        if (block.isNull(pagePosition)) {
            return null;
        }
        RowType type = this.removeType.orElseThrow();
        int removeFields = 4;
        SqlRow removeEntryRow = CheckpointEntryIterator.getRow(block, pagePosition);
        log.debug("Block %s has %s fields", new Object[]{block, removeEntryRow.getFieldCount()});
        if (removeEntryRow.getFieldCount() != removeFields) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, String.format("Expected block %s to have %d children, but found %s", block, removeFields, removeEntryRow.getFieldCount()));
        }
        CheckpointFieldReader remove = new CheckpointFieldReader(session, removeEntryRow, type);
        Optional<DeletionVectorEntry> deletionVector = Optional.empty();
        if (this.deletionVectorsEnabled) {
            deletionVector = Optional.ofNullable(remove.getRow("deletionVector")).map(row -> CheckpointEntryIterator.parseDeletionVectorFromParquet(session, row, this.removeDeletionVectorType.orElseThrow()));
        }
        RemoveFileEntry result = new RemoveFileEntry(remove.getString("path"), remove.getMap(this.stringMap, "partitionValues"), remove.getLong("deletionTimestamp"), remove.getBoolean("dataChange"), deletionVector);
        log.debug("Result: %s", new Object[]{result});
        return DeltaLakeTransactionLogEntry.removeFileEntry(result);
    }

    private DeltaLakeTransactionLogEntry buildSidecarEntry(ConnectorSession session, int pagePosition, Block block) {
        log.debug("Building sidecar entry from %s pagePosition %d", new Object[]{block, pagePosition});
        if (block.isNull(pagePosition)) {
            return null;
        }
        int sidecarFields = 4;
        SqlRow sidecarEntryRow = CheckpointEntryIterator.getRow(block, pagePosition);
        if (sidecarEntryRow.getFieldCount() != sidecarFields) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, String.format("Expected block %s to have %d children, but found %s", block, sidecarFields, sidecarEntryRow.getFieldCount()));
        }
        RowType type = this.sidecarType.orElseThrow();
        CheckpointFieldReader sidecar = new CheckpointFieldReader(session, sidecarEntryRow, type);
        SidecarEntry result = new SidecarEntry(sidecar.getString("path"), sidecar.getLong("sizeInBytes"), sidecar.getLong("modificationTime"), Optional.ofNullable(sidecar.getMap(this.stringMap, "tags")));
        return DeltaLakeTransactionLogEntry.sidecarEntry(result);
    }

    private static DeletionVectorEntry parseDeletionVectorFromParquet(ConnectorSession session, SqlRow row, RowType type) {
        Preconditions.checkArgument((row.getFieldCount() == 5 ? 1 : 0) != 0, (Object)"Deletion vector entry must have 5 fields");
        CheckpointFieldReader deletionVector = new CheckpointFieldReader(session, row, type);
        String storageType = deletionVector.getString("storageType");
        String pathOrInlineDv = deletionVector.getString("pathOrInlineDv");
        OptionalInt offset = deletionVector.getOptionalInt("offset");
        int sizeInBytes = deletionVector.getInt("sizeInBytes");
        long cardinality = deletionVector.getLong("cardinality");
        return new DeletionVectorEntry(storageType, pathOrInlineDv, offset, sizeInBytes, cardinality);
    }

    private DeltaLakeParquetFileStatistics parseStatisticsFromParquet(ConnectorSession session, SqlRow statsRow, RowType type) {
        CheckpointFieldReader stats = new CheckpointFieldReader(session, statsRow, type);
        long numRecords = stats.getLong("numRecords");
        Optional<Map<String, Object>> minValues = Optional.empty();
        Optional<Map<String, Object>> maxValues = Optional.empty();
        if (!this.columnsWithMinMaxStats.isEmpty()) {
            minValues = Optional.of(this.parseMinMax(stats.getRow("minValues"), this.columnsWithMinMaxStats));
            maxValues = Optional.of(this.parseMinMax(stats.getRow("maxValues"), this.columnsWithMinMaxStats));
        }
        Optional<Map<String, Object>> nullCount = Optional.of(this.parseNullCount(stats.getRow("nullCount"), this.schema));
        return new DeltaLakeParquetFileStatistics(Optional.of(numRecords), minValues, maxValues, nullCount);
    }

    private Map<String, Object> parseMinMax(@Nullable SqlRow row, List<DeltaLakeColumnMetadata> eligibleColumns) {
        if (row == null) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder values = ImmutableMap.builder();
        for (int i = 0; i < eligibleColumns.size(); ++i) {
            int fieldIndex;
            DeltaLakeColumnMetadata metadata = eligibleColumns.get(i);
            String name = metadata.physicalName();
            Type type = metadata.physicalColumnType();
            ValueBlock fieldBlock = row.getUnderlyingFieldBlock(i);
            if (fieldBlock.isNull(fieldIndex = row.getUnderlyingFieldPosition(i))) continue;
            if (type instanceof RowType) {
                RowType rowType = (RowType)type;
                if (!this.checkpointRowStatisticsWritingEnabled) continue;
                values.put((Object)name, (Object)rowType.getObject((Block)fieldBlock, fieldIndex));
                continue;
            }
            if (type instanceof TimestampWithTimeZoneType) {
                long epochMillis = LongMath.divide((long)((Long)TypeUtils.readNativeValue((Type)TimestampType.TIMESTAMP_MILLIS, (Block)fieldBlock, (int)fieldIndex)), (long)1000L, (RoundingMode)RoundingMode.UNNECESSARY);
                if (Math.floorDiv(epochMillis, 86400000) < TransactionLogParser.START_OF_MODERN_ERA_EPOCH_DAY) continue;
                values.put((Object)name, (Object)DateTimeEncoding.packDateTimeWithZone((long)epochMillis, (TimeZoneKey)TimeZoneKey.UTC_KEY));
                continue;
            }
            values.put((Object)name, TypeUtils.readNativeValue((Type)type, (Block)fieldBlock, (int)fieldIndex));
        }
        return values.buildOrThrow();
    }

    private Map<String, Object> parseNullCount(SqlRow row, List<DeltaLakeColumnMetadata> columns) {
        if (row == null) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder values = ImmutableMap.builder();
        for (int i = 0; i < columns.size(); ++i) {
            int fieldIndex;
            DeltaLakeColumnMetadata metadata = columns.get(i);
            ValueBlock fieldBlock = row.getUnderlyingFieldBlock(i);
            if (fieldBlock.isNull(fieldIndex = row.getUnderlyingFieldPosition(i))) continue;
            if (metadata.type() instanceof RowType) {
                if (!this.checkpointRowStatisticsWritingEnabled) continue;
                values.put((Object)metadata.physicalName(), (Object)CheckpointEntryIterator.getRow((Block)fieldBlock, fieldIndex));
                continue;
            }
            values.put((Object)metadata.physicalName(), (Object)CheckpointEntryIterator.getLongField(row, i));
        }
        return values.buildOrThrow();
    }

    private DeltaLakeTransactionLogEntry buildTxnEntry(ConnectorSession session, int pagePosition, Block block) {
        log.debug("Building txn entry from %s pagePosition %d", new Object[]{block, pagePosition});
        if (block.isNull(pagePosition)) {
            return null;
        }
        RowType type = this.txnType.orElseThrow();
        int txnFields = 3;
        SqlRow txnEntryRow = CheckpointEntryIterator.getRow(block, pagePosition);
        log.debug("Block %s has %s fields", new Object[]{block, txnEntryRow.getFieldCount()});
        if (txnEntryRow.getFieldCount() != txnFields) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, String.format("Expected block %s to have %d children, but found %s", block, txnFields, txnEntryRow.getFieldCount()));
        }
        CheckpointFieldReader txn = new CheckpointFieldReader(session, txnEntryRow, type);
        TransactionEntry result = new TransactionEntry(txn.getString("appId"), txn.getLong("version"), txn.getLong("lastUpdated"));
        log.debug("Result: %s", new Object[]{result});
        return DeltaLakeTransactionLogEntry.transactionEntry(result);
    }

    private static long getLongField(SqlRow row, int field) {
        LongArrayBlock valueBlock = (LongArrayBlock)row.getUnderlyingFieldBlock(field);
        return valueBlock.getLong(row.getUnderlyingFieldPosition(field));
    }

    protected DeltaLakeTransactionLogEntry computeNext() {
        try {
            if (this.nextEntries.isEmpty()) {
                this.fillNextEntries();
            }
            if (!this.nextEntries.isEmpty()) {
                return this.nextEntries.remove();
            }
            this.pageSource.close();
            return (DeltaLakeTransactionLogEntry)this.endOfData();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private boolean tryAdvancePage() throws IOException {
        if (this.pageSource.isFinished()) {
            this.pageSource.close();
            return false;
        }
        boolean isFirstPage = this.page == null;
        this.page = this.pageSource.getNextSourcePage();
        if (this.page == null) {
            return false;
        }
        if (isFirstPage) {
            int requiredExtractorChannels = this.extractors.size();
            if (this.page.getChannelCount() != requiredExtractorChannels) {
                throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, String.format("Expected page in %s to contain %d channels, but found %d", this.checkpointPath, requiredExtractorChannels, this.page.getChannelCount()));
            }
        }
        this.pagePosition = 0;
        return true;
    }

    public void close() {
        try {
            this.pageSource.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void fillNextEntries() throws IOException {
        while (this.nextEntries.isEmpty()) {
            while (this.page == null || this.pagePosition == this.page.getPositionCount()) {
                if (this.tryAdvancePage()) continue;
                return;
            }
            int blockIndex = 0;
            for (CheckpointFieldExtractor extractor : this.extractors) {
                DeltaLakeTransactionLogEntry entry = extractor.getEntry(this.session, this.pagePosition, this.page.getBlock(blockIndex));
                if (entry != null) {
                    this.nextEntries.add(entry);
                }
                ++blockIndex;
            }
            ++this.pagePosition;
        }
    }

    @VisibleForTesting
    OptionalLong getCompletedPositions() {
        return this.pageSource.getCompletedPositions();
    }

    @VisibleForTesting
    long getCompletedBytes() {
        return this.pageSource.getCompletedBytes();
    }

    private static SqlRow getRow(Block block, int position) {
        return ((RowBlock)block.getUnderlyingValueBlock()).getRow(block.getUnderlyingValuePosition(position));
    }

    public static enum EntryType {
        TRANSACTION("txn"),
        ADD("add"),
        REMOVE("remove"),
        METADATA("metadata"),
        PROTOCOL("protocol"),
        SIDECAR("sidecar");

        private final String columnName;

        private EntryType(String columnName) {
            this.columnName = columnName;
        }

        public String getColumnName() {
            return this.columnName;
        }
    }

    @FunctionalInterface
    private static interface CheckpointFieldExtractor {
        @Nullable
        public DeltaLakeTransactionLogEntry getEntry(ConnectorSession var1, int var2, Block var3);
    }

    private class AddFileEntryExtractor
    implements CheckpointFieldExtractor {
        private AddFileEntryExtractor() {
        }

        @Override
        @Nullable
        public DeltaLakeTransactionLogEntry getEntry(ConnectorSession session, int pagePosition, Block addBlock) {
            log.debug("Building add entry from %s pagePosition %d", new Object[]{addBlock, pagePosition});
            if (addBlock.isNull(pagePosition)) {
                return null;
            }
            SqlRow addEntryRow = CheckpointEntryIterator.getRow(addBlock, pagePosition);
            log.debug("Block %s has %s fields", new Object[]{addBlock, addEntryRow.getFieldCount()});
            CheckpointFieldReader addReader = new CheckpointFieldReader(session, addEntryRow, CheckpointEntryIterator.this.addType.orElseThrow());
            Map<String, String> partitionValues = addReader.getMap(CheckpointEntryIterator.this.stringMap, "partitionValues");
            Map<String, Optional<String>> canonicalPartitionValues = TransactionLogUtil.canonicalizePartitionValues(partitionValues);
            if (!CheckpointEntryIterator.this.partitionConstraint.isAll() && !DeltaLakeDomains.partitionMatchesPredicate(canonicalPartitionValues, (Map)CheckpointEntryIterator.this.partitionConstraint.getDomains().orElseThrow())) {
                return null;
            }
            String path = addReader.getString("path");
            long size = addReader.getLong("size");
            long modificationTime = addReader.getLong("modificationTime");
            boolean dataChange = addReader.getBoolean("dataChange");
            Optional<DeletionVectorEntry> deletionVector = Optional.empty();
            if (CheckpointEntryIterator.this.deletionVectorsEnabled) {
                deletionVector = Optional.ofNullable(addReader.getRow("deletionVector")).map(row -> CheckpointEntryIterator.parseDeletionVectorFromParquet(session, row, CheckpointEntryIterator.this.addDeletionVectorType.orElseThrow()));
            }
            Optional<DeltaLakeParquetFileStatistics> parsedStats = Optional.ofNullable(addReader.getRow("stats_parsed")).map(row -> CheckpointEntryIterator.this.parseStatisticsFromParquet(session, (SqlRow)row, CheckpointEntryIterator.this.addParsedStatsFieldType.orElseThrow()));
            Optional<String> stats = Optional.empty();
            if (parsedStats.isEmpty()) {
                stats = Optional.ofNullable(addReader.getString("stats"));
            }
            Map<String, String> tags = addReader.getMap(CheckpointEntryIterator.this.stringMap, "tags");
            AddFileEntry result = new AddFileEntry(path, partitionValues, canonicalPartitionValues, size, modificationTime, dataChange, stats, parsedStats, tags, deletionVector);
            log.debug("Result: %s", new Object[]{result});
            return DeltaLakeTransactionLogEntry.addFileEntry(result);
        }
    }
}

