/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog.checkpoint;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.metastore.HiveType;
import io.trino.plugin.deltalake.DeltaHiveTypeTranslator;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnMetadata;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeSchemaSupport;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import io.trino.plugin.deltalake.transactionlog.TransactionLogAccess;
import io.trino.plugin.hive.util.HiveTypeUtil;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class CheckpointSchemaManager {
    private final TypeManager typeManager;
    private static final RowType DELETION_VECTORS_TYPE = RowType.from((List)ImmutableList.builder().add((Object)RowType.field((String)"storageType", (Type)VarcharType.VARCHAR)).add((Object)RowType.field((String)"pathOrInlineDv", (Type)VarcharType.VARCHAR)).add((Object)RowType.field((String)"offset", (Type)IntegerType.INTEGER)).add((Object)RowType.field((String)"sizeInBytes", (Type)IntegerType.INTEGER)).add((Object)RowType.field((String)"cardinality", (Type)BigintType.BIGINT)).build());
    private static final RowType TXN_ENTRY_TYPE = RowType.from((List)ImmutableList.of((Object)RowType.field((String)"appId", (Type)VarcharType.VARCHAR), (Object)RowType.field((String)"version", (Type)BigintType.BIGINT), (Object)RowType.field((String)"lastUpdated", (Type)BigintType.BIGINT)));
    private final RowType metadataEntryType;
    private final RowType removeEntryType;
    private final RowType sidecarEntryType;
    private final ArrayType stringList;

    @Inject
    public CheckpointSchemaManager(TypeManager typeManager) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.stringList = (ArrayType)this.typeManager.getType(TypeSignature.arrayType((TypeSignature)VarcharType.VARCHAR.getTypeSignature()));
        MapType stringMap = (MapType)this.typeManager.getType(TypeSignature.mapType((TypeSignature)VarcharType.VARCHAR.getTypeSignature(), (TypeSignature)VarcharType.VARCHAR.getTypeSignature()));
        this.metadataEntryType = RowType.from((List)ImmutableList.of((Object)RowType.field((String)"id", (Type)VarcharType.VARCHAR), (Object)RowType.field((String)"name", (Type)VarcharType.VARCHAR), (Object)RowType.field((String)"description", (Type)VarcharType.VARCHAR), (Object)RowType.field((String)"format", (Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"provider", (Type)VarcharType.VARCHAR), (Object)RowType.field((String)"options", (Type)stringMap)))), (Object)RowType.field((String)"schemaString", (Type)VarcharType.VARCHAR), (Object)RowType.field((String)"partitionColumns", (Type)this.stringList), (Object)RowType.field((String)"configuration", (Type)stringMap), (Object)RowType.field((String)"createdTime", (Type)BigintType.BIGINT)));
        this.removeEntryType = RowType.from((List)ImmutableList.of((Object)RowType.field((String)"path", (Type)VarcharType.VARCHAR), (Object)RowType.field((String)"partitionValues", (Type)stringMap), (Object)RowType.field((String)"deletionTimestamp", (Type)BigintType.BIGINT), (Object)RowType.field((String)"dataChange", (Type)BooleanType.BOOLEAN)));
        this.sidecarEntryType = RowType.from((List)ImmutableList.builder().add((Object)RowType.field((String)"path", (Type)VarcharType.VARCHAR)).add((Object)RowType.field((String)"sizeInBytes", (Type)BigintType.BIGINT)).add((Object)RowType.field((String)"modificationTime", (Type)BigintType.BIGINT)).add((Object)RowType.field((String)"tags", (Type)stringMap)).build());
    }

    public RowType getMetadataEntryType() {
        return this.metadataEntryType;
    }

    public RowType getAddEntryType(MetadataEntry metadataEntry, ProtocolEntry protocolEntry, Predicate<String> addStatsMinMaxColumnFilter, boolean requireWriteStatsAsJson, boolean requireWriteStatsAsStruct, boolean usePartitionValues) {
        List<DeltaLakeColumnMetadata> allColumns = DeltaLakeSchemaSupport.extractSchema(metadataEntry, protocolEntry, this.typeManager);
        List minMaxColumns = TransactionLogAccess.columnsWithStats(metadataEntry, protocolEntry, this.typeManager);
        minMaxColumns = (List)minMaxColumns.stream().filter(column -> addStatsMinMaxColumnFilter.test(column.name())).collect(ImmutableList.toImmutableList());
        boolean deletionVectorEnabled = DeltaLakeSchemaSupport.isDeletionVectorEnabled(metadataEntry, protocolEntry);
        ImmutableList.Builder minMaxFields = ImmutableList.builder();
        for (DeltaLakeColumnMetadata dataColumn : minMaxColumns) {
            Type type = dataColumn.physicalColumnType();
            if (type instanceof TimestampWithTimeZoneType) {
                minMaxFields.add((Object)RowType.field((String)dataColumn.physicalName(), (Type)TimestampType.TIMESTAMP_MILLIS));
                continue;
            }
            minMaxFields.add((Object)RowType.field((String)dataColumn.physicalName(), (Type)type));
        }
        ImmutableList.Builder statsColumns = ImmutableList.builder();
        statsColumns.add((Object)RowType.field((String)"numRecords", (Type)BigintType.BIGINT));
        ImmutableList minMax = minMaxFields.build();
        if (!minMax.isEmpty()) {
            RowType minMaxType = RowType.from((List)minMax);
            statsColumns.add((Object)RowType.field((String)"minValues", (Type)minMaxType));
            statsColumns.add((Object)RowType.field((String)"maxValues", (Type)minMaxType));
        }
        statsColumns.add((Object)RowType.field((String)"nullCount", (Type)RowType.from((List)((List)allColumns.stream().map(column -> CheckpointSchemaManager.buildNullCountType(Optional.of(column.physicalName()), column.physicalColumnType())).collect(ImmutableList.toImmutableList())))));
        MapType stringMap = (MapType)this.typeManager.getType(TypeSignature.mapType((TypeSignature)VarcharType.VARCHAR.getTypeSignature(), (TypeSignature)VarcharType.VARCHAR.getTypeSignature()));
        ImmutableList.Builder addFields = ImmutableList.builder();
        addFields.add((Object)RowType.field((String)"path", (Type)VarcharType.VARCHAR));
        if (usePartitionValues) {
            addFields.add((Object)RowType.field((String)"partitionValues", (Type)stringMap));
        }
        addFields.add((Object)RowType.field((String)"size", (Type)BigintType.BIGINT));
        addFields.add((Object)RowType.field((String)"modificationTime", (Type)BigintType.BIGINT));
        addFields.add((Object)RowType.field((String)"dataChange", (Type)BooleanType.BOOLEAN));
        if (requireWriteStatsAsJson) {
            addFields.add((Object)RowType.field((String)"stats", (Type)VarcharType.VARCHAR));
        }
        if (requireWriteStatsAsStruct) {
            List<DeltaLakeColumnHandle> partitionColumns = DeltaLakeSchemaSupport.extractPartitionColumns(metadataEntry, protocolEntry, this.typeManager);
            if (!partitionColumns.isEmpty()) {
                List partitionValuesParsed = (List)partitionColumns.stream().map(column -> RowType.field((String)column.basePhysicalColumnName(), (Type)this.typeManager.getType(HiveTypeUtil.getTypeSignature((HiveType)DeltaHiveTypeTranslator.toHiveType(column.type()))))).collect(ImmutableList.toImmutableList());
                addFields.add((Object)RowType.field((String)"partitionValues_parsed", (Type)RowType.from((List)partitionValuesParsed)));
            }
            addFields.add((Object)RowType.field((String)"stats_parsed", (Type)RowType.from((List)statsColumns.build())));
        }
        addFields.add((Object)RowType.field((String)"tags", (Type)stringMap));
        if (deletionVectorEnabled) {
            addFields.add((Object)RowType.field((String)"deletionVector", (Type)DELETION_VECTORS_TYPE));
        }
        return RowType.from((List)addFields.build());
    }

    private static RowType.Field buildNullCountType(Optional<String> columnName, Type columnType) {
        if (columnType instanceof RowType) {
            RowType rowType = (RowType)columnType;
            RowType rowTypeFromFields = RowType.from((List)((List)rowType.getFields().stream().map(field -> CheckpointSchemaManager.buildNullCountType(field.getName(), field.getType())).collect(ImmutableList.toImmutableList())));
            return new RowType.Field(columnName, (Type)rowTypeFromFields);
        }
        return new RowType.Field(columnName, (Type)BigintType.BIGINT);
    }

    public RowType getRemoveEntryType() {
        return this.removeEntryType;
    }

    public RowType getTxnEntryType() {
        return TXN_ENTRY_TYPE;
    }

    public RowType getProtocolEntryType(boolean requireReaderFeatures, boolean requireWriterFeatures) {
        ImmutableList.Builder fields = ImmutableList.builder();
        fields.add((Object)RowType.field((String)"minReaderVersion", (Type)IntegerType.INTEGER));
        fields.add((Object)RowType.field((String)"minWriterVersion", (Type)IntegerType.INTEGER));
        if (requireReaderFeatures) {
            fields.add((Object)RowType.field((String)"readerFeatures", (Type)this.stringList));
        }
        if (requireWriterFeatures) {
            fields.add((Object)RowType.field((String)"writerFeatures", (Type)this.stringList));
        }
        return RowType.from((List)fields.build());
    }

    public RowType getSidecarEntryType() {
        return this.sidecarEntryType;
    }
}

