/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog.writer;

import com.google.inject.Inject;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.deltalake.transactionlog.writer.TransactionConflictException;
import io.trino.plugin.deltalake.transactionlog.writer.TransactionLogSynchronizer;
import io.trino.spi.connector.ConnectorSession;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileAlreadyExistsException;
import java.util.Objects;

public class S3ConditionalWriteLogSynchronizer
implements TransactionLogSynchronizer {
    private final TrinoFileSystemFactory fileSystemFactory;

    @Inject
    S3ConditionalWriteLogSynchronizer(TrinoFileSystemFactory fileSystemFactory) {
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
    }

    @Override
    public void write(ConnectorSession session, String clusterId, Location newLogEntryPath, byte[] entryContents) {
        TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
        try {
            fileSystem.newOutputFile(newLogEntryPath).createExclusive(entryContents);
        }
        catch (FileAlreadyExistsException e) {
            throw new TransactionConflictException("Conflict detected while writing Transaction Log entry " + String.valueOf(newLogEntryPath) + " to S3", e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public boolean isUnsafe() {
        return false;
    }
}

