/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.util;

import io.airlift.slice.Slices;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.transactionlog.TransactionLogParser;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.Type;
import java.util.Map;
import java.util.Optional;

public final class DeltaLakeDomains {
    private DeltaLakeDomains() {
    }

    public static boolean partitionMatchesPredicate(Map<String, Optional<String>> partitionKeys, Map<DeltaLakeColumnHandle, Domain> domains) {
        for (Map.Entry<DeltaLakeColumnHandle, Domain> enforcedDomainsEntry : domains.entrySet()) {
            DeltaLakeColumnHandle partitionColumn = enforcedDomainsEntry.getKey();
            Domain partitionDomain = enforcedDomainsEntry.getValue();
            if (partitionDomain.includesNullableValue(TransactionLogParser.deserializePartitionValue(partitionColumn, partitionKeys.get(partitionColumn.basePhysicalColumnName())))) continue;
            return false;
        }
        return true;
    }

    public static Domain getFileModifiedTimeDomain(TupleDomain<DeltaLakeColumnHandle> effectivePredicate) {
        return effectivePredicate.getDomains().flatMap(domains -> Optional.ofNullable((Domain)domains.get(DeltaLakeColumnHandle.fileModifiedTimeColumnHandle()))).orElseGet(() -> Domain.all((Type)DeltaLakeColumnHandle.fileModifiedTimeColumnHandle().baseType()));
    }

    public static boolean fileModifiedTimeMatchesPredicate(Domain fileModifiedTimeDomain, long fileModifiedTime) {
        return fileModifiedTimeDomain.includesNullableValue((Object)DateTimeEncoding.packDateTimeWithZone((long)fileModifiedTime, (TimeZoneKey)TimeZoneKey.UTC_KEY));
    }

    public static Domain getPathDomain(TupleDomain<DeltaLakeColumnHandle> effectivePredicate) {
        return effectivePredicate.getDomains().flatMap(domains -> Optional.ofNullable((Domain)domains.get(DeltaLakeColumnHandle.pathColumnHandle()))).orElseGet(() -> Domain.all((Type)DeltaLakeColumnHandle.pathColumnHandle().baseType()));
    }

    public static boolean pathMatchesPredicate(Domain pathDomain, String path) {
        return pathDomain.includesNullableValue((Object)Slices.utf8Slice((String)path));
    }

    public static Domain getFileSizeDomain(TupleDomain<DeltaLakeColumnHandle> effectivePredicate) {
        return effectivePredicate.getDomains().flatMap(domains -> Optional.ofNullable((Domain)domains.get(DeltaLakeColumnHandle.fileSizeColumnHandle()))).orElseGet(() -> Domain.all((Type)DeltaLakeColumnHandle.fileSizeColumnHandle().baseType()));
    }

    public static boolean fileSizeMatchesPredicate(Domain fileSizeDomain, long fileSize) {
        return fileSizeDomain.includesNullableValue((Object)fileSize);
    }
}

