/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import io.airlift.log.Logger;
import io.airlift.units.DataSize;
import io.trino.plugin.jdbc.JdbcJoinPushdownSessionProperties;
import io.trino.plugin.jdbc.JoinPushdownStrategy;
import io.trino.plugin.jdbc.PreparedQuery;
import io.trino.spi.connector.BasicRelationStatistics;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.JoinStatistics;
import io.trino.spi.connector.JoinType;
import java.util.Optional;
import java.util.function.Supplier;

public final class JdbcJoinPushdownUtil {
    private static final Logger LOG = Logger.get(JdbcJoinPushdownUtil.class);

    private JdbcJoinPushdownUtil() {
    }

    public static Optional<PreparedQuery> implementJoinCostAware(ConnectorSession session, JoinType joinType, PreparedQuery leftSource, PreparedQuery rightSource, JoinStatistics statistics, Supplier<Optional<PreparedQuery>> delegate) {
        Optional<PreparedQuery> result = delegate.get();
        if (result.isEmpty()) {
            return Optional.empty();
        }
        JoinPushdownStrategy joinPushdownStrategy = JdbcJoinPushdownSessionProperties.getJoinPushdownStrategy(session);
        return switch (joinPushdownStrategy) {
            default -> throw new MatchException(null, null);
            case JoinPushdownStrategy.EAGER -> result;
            case JoinPushdownStrategy.AUTOMATIC -> JdbcJoinPushdownUtil.shouldPushDownJoinCostAware(session, joinType, leftSource, rightSource, statistics) ? result : Optional.empty();
        };
    }

    public static boolean shouldPushDownJoinCostAware(ConnectorSession session, JoinType joinType, PreparedQuery leftSource, PreparedQuery rightSource, JoinStatistics statistics) {
        long maxTableSizeBytes = JdbcJoinPushdownSessionProperties.getJoinPushdownAutomaticMaxTableSize(session).map(DataSize::toBytes).orElse(Long.MAX_VALUE);
        String joinSignature = "";
        if (LOG.isDebugEnabled()) {
            joinSignature = JdbcJoinPushdownUtil.diagnosticsJoinSignature(joinType, leftSource, rightSource);
        }
        if (statistics.getLeftStatistics().isEmpty()) {
            JdbcJoinPushdownUtil.logNoPushdown(joinSignature, "left stats empty");
            return false;
        }
        double leftDataSize = ((BasicRelationStatistics)statistics.getLeftStatistics().get()).getDataSize();
        if (leftDataSize > (double)maxTableSizeBytes) {
            JdbcJoinPushdownUtil.logNoPushdown(joinSignature, () -> "left size " + leftDataSize + " > " + maxTableSizeBytes);
            return false;
        }
        if (statistics.getRightStatistics().isEmpty()) {
            JdbcJoinPushdownUtil.logNoPushdown(joinSignature, "right stats empty");
            return false;
        }
        double rightDataSize = ((BasicRelationStatistics)statistics.getRightStatistics().get()).getDataSize();
        if (rightDataSize > (double)maxTableSizeBytes) {
            JdbcJoinPushdownUtil.logNoPushdown(joinSignature, () -> "right size " + rightDataSize + " > " + maxTableSizeBytes);
            return false;
        }
        if (statistics.getJoinStatistics().isEmpty()) {
            JdbcJoinPushdownUtil.logNoPushdown(joinSignature, "join stats empty");
            return false;
        }
        double joinDataSize = ((BasicRelationStatistics)statistics.getJoinStatistics().get()).getDataSize();
        if (joinDataSize < JdbcJoinPushdownSessionProperties.getJoinPushdownAutomaticJoinToTablesRatio(session) * (leftDataSize + rightDataSize)) {
            LOG.debug("triggering join pushdown for %s", new Object[]{joinSignature});
            return true;
        }
        JdbcJoinPushdownUtil.logNoPushdown(joinSignature, () -> "joinDataSize " + joinDataSize + " >= " + JdbcJoinPushdownSessionProperties.getJoinPushdownAutomaticJoinToTablesRatio(session) + " * (leftDataSize " + leftDataSize + " + rightDataSize " + rightDataSize + ") = " + JdbcJoinPushdownSessionProperties.getJoinPushdownAutomaticJoinToTablesRatio(session) * (leftDataSize + rightDataSize));
        return false;
    }

    private static String diagnosticsJoinSignature(JoinType joinType, PreparedQuery leftSource, PreparedQuery rightSource) {
        return String.format("%s JOIN(%s; %s)", joinType, leftSource.query(), rightSource.query());
    }

    private static void logNoPushdown(String joinSignature, String reason) {
        JdbcJoinPushdownUtil.logNoPushdown(joinSignature, () -> reason);
    }

    private static void logNoPushdown(String joinSignature, Supplier<String> reason) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("skipping join pushdown for %s; %s", new Object[]{joinSignature, reason.get()});
        }
    }
}

