/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.plugin.base.session.SessionPropertiesProvider;
import io.trino.plugin.jdbc.JdbcMetadataConfig;
import io.trino.plugin.jdbc.MaxDomainCompactionThreshold;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.session.PropertyMetadata;
import java.util.List;
import java.util.Optional;

public class JdbcMetadataSessionProperties
implements SessionPropertiesProvider {
    public static final String COMPLEX_EXPRESSION_PUSHDOWN = "complex_expression_pushdown";
    public static final String JOIN_PUSHDOWN_ENABLED = "join_pushdown_enabled";
    public static final String COMPLEX_JOIN_PUSHDOWN_ENABLED = "complex_join_pushdown_enabled";
    public static final String AGGREGATION_PUSHDOWN_ENABLED = "aggregation_pushdown_enabled";
    public static final String TOPN_PUSHDOWN_ENABLED = "topn_pushdown_enabled";
    public static final String BULK_LIST_COLUMNS = "bulk_list_columns";
    public static final String DOMAIN_COMPACTION_THRESHOLD = "domain_compaction_threshold";
    private final List<PropertyMetadata<?>> properties;

    @Inject
    public JdbcMetadataSessionProperties(JdbcMetadataConfig jdbcMetadataConfig, @MaxDomainCompactionThreshold Optional<Integer> maxDomainCompactionThreshold) {
        JdbcMetadataSessionProperties.validateDomainCompactionThreshold(jdbcMetadataConfig.getDomainCompactionThreshold(), maxDomainCompactionThreshold);
        this.properties = ImmutableList.builder().add((Object)PropertyMetadata.booleanProperty((String)COMPLEX_EXPRESSION_PUSHDOWN, (String)"Allow complex expression pushdown into connectors", (Boolean)jdbcMetadataConfig.isComplexExpressionPushdownEnabled(), (boolean)true)).add((Object)PropertyMetadata.booleanProperty((String)JOIN_PUSHDOWN_ENABLED, (String)"Enable join pushdown", (Boolean)jdbcMetadataConfig.isJoinPushdownEnabled(), (boolean)false)).add((Object)PropertyMetadata.booleanProperty((String)COMPLEX_JOIN_PUSHDOWN_ENABLED, (String)"Enable join pushdown with non-comparison expressions", (Boolean)jdbcMetadataConfig.isComplexJoinPushdownEnabled(), (boolean)false)).add((Object)PropertyMetadata.booleanProperty((String)AGGREGATION_PUSHDOWN_ENABLED, (String)"Enable aggregation pushdown", (Boolean)jdbcMetadataConfig.isAggregationPushdownEnabled(), (boolean)false)).add((Object)PropertyMetadata.booleanProperty((String)BULK_LIST_COLUMNS, (String)"Listing tables' columns in bulk", (Boolean)jdbcMetadataConfig.isBulkListColumns(), (boolean)true)).add((Object)PropertyMetadata.integerProperty((String)DOMAIN_COMPACTION_THRESHOLD, (String)"Maximum ranges to allow in a tuple domain without simplifying it", (Integer)jdbcMetadataConfig.getDomainCompactionThreshold(), value -> JdbcMetadataSessionProperties.validateDomainCompactionThreshold(value, maxDomainCompactionThreshold), (boolean)false)).add((Object)PropertyMetadata.booleanProperty((String)TOPN_PUSHDOWN_ENABLED, (String)"Enable TopN pushdown", (Boolean)jdbcMetadataConfig.isTopNPushdownEnabled(), (boolean)false)).build();
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.properties;
    }

    public static boolean isComplexExpressionPushdown(ConnectorSession session) {
        return (Boolean)session.getProperty(COMPLEX_EXPRESSION_PUSHDOWN, Boolean.class);
    }

    public static boolean isJoinPushdownEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(JOIN_PUSHDOWN_ENABLED, Boolean.class);
    }

    public static boolean isComplexJoinPushdownEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(COMPLEX_JOIN_PUSHDOWN_ENABLED, Boolean.class);
    }

    public static boolean isAggregationPushdownEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(AGGREGATION_PUSHDOWN_ENABLED, Boolean.class);
    }

    public static boolean isTopNPushdownEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(TOPN_PUSHDOWN_ENABLED, Boolean.class);
    }

    public static boolean isBulkListColumns(ConnectorSession session) {
        return (Boolean)session.getProperty(BULK_LIST_COLUMNS, Boolean.class);
    }

    public static int getDomainCompactionThreshold(ConnectorSession session) {
        return (Integer)session.getProperty(DOMAIN_COMPACTION_THRESHOLD, Integer.class);
    }

    private static void validateDomainCompactionThreshold(int domainCompactionThreshold, Optional<Integer> maxDomainCompactionThreshold) {
        if (domainCompactionThreshold < 1) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("Domain compaction threshold (%s) must be greater than 0", domainCompactionThreshold));
        }
        maxDomainCompactionThreshold.ifPresent(max -> {
            if (domainCompactionThreshold > max) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("Domain compaction threshold (%s) cannot exceed %s", domainCompactionThreshold, max));
            }
        });
    }
}

