/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MoreCollectors;
import com.google.inject.Inject;
import dev.failsafe.RetryPolicy;
import io.trino.plugin.base.MappedPageSource;
import io.trino.plugin.jdbc.BaseJdbcConnectorTableHandle;
import io.trino.plugin.jdbc.ForJdbcClient;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcPageSource;
import io.trino.plugin.jdbc.JdbcProcedureHandle;
import io.trino.plugin.jdbc.JdbcSplit;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.MergeJdbcPageSource;
import io.trino.plugin.jdbc.RetryingModule;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.predicate.TupleDomain;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.UnaryOperator;
import java.util.stream.IntStream;

public class JdbcPageSourceProvider
implements ConnectorPageSourceProvider {
    private final JdbcClient jdbcClient;
    private final ExecutorService executor;
    private final RetryPolicy<Object> policy;

    @Inject
    public JdbcPageSourceProvider(JdbcClient jdbcClient, @ForJdbcClient ExecutorService executor, RetryPolicy<Object> policy) {
        this.jdbcClient = Objects.requireNonNull(jdbcClient, "jdbcClient is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.policy = Objects.requireNonNull(policy, "policy is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<ColumnHandle> columns, DynamicFilter dynamicFilter) {
        JdbcSplit jdbcSplit = (JdbcSplit)split;
        List jdbcColumns = (List)columns.stream().map(JdbcColumnHandle.class::cast).collect(ImmutableList.toImmutableList());
        if (table instanceof JdbcProcedureHandle) {
            JdbcProcedureHandle procedureHandle = (JdbcProcedureHandle)table;
            List<JdbcColumnHandle> sourceColumns = procedureHandle.getColumns().orElseThrow();
            Map columnIndexMap = (Map)IntStream.range(0, sourceColumns.size()).boxed().collect(ImmutableMap.toImmutableMap(sourceColumns::get, UnaryOperator.identity()));
            return new MappedPageSource((ConnectorPageSource)this.createPageSource(session, jdbcSplit, procedureHandle, sourceColumns), (List)jdbcColumns.stream().map(columnIndexMap::get).collect(ImmutableList.toImmutableList()));
        }
        JdbcTableHandle tableHandle = (JdbcTableHandle)table;
        Optional mergeRowId = (Optional)jdbcColumns.stream().filter(column -> column.getColumnName().equalsIgnoreCase("$merge_row_id")).collect(MoreCollectors.toOptional());
        if (mergeRowId.isEmpty()) {
            return new JdbcPageSource(this.jdbcClient, this.executor, session, jdbcSplit, tableHandle.intersectedWithConstraint((TupleDomain<ColumnHandle>)jdbcSplit.getDynamicFilter().transformKeys(ColumnHandle.class::cast)), jdbcColumns);
        }
        return this.createMergePageSource(session, jdbcSplit, jdbcColumns, tableHandle, mergeRowId);
    }

    private MergeJdbcPageSource createMergePageSource(ConnectorSession session, JdbcSplit jdbcSplit, List<JdbcColumnHandle> columns, JdbcTableHandle tableHandle, Optional<JdbcColumnHandle> mergeRowId) {
        List<JdbcColumnHandle> primaryKeys = this.jdbcClient.getPrimaryKeys(session, tableHandle.getRequiredNamedRelation().getRemoteTableName());
        List<JdbcColumnHandle> scanColumns = JdbcPageSourceProvider.getScanColumns(session, this.jdbcClient, tableHandle, primaryKeys);
        ImmutableList.Builder columnAdaptationsBuilder = ImmutableList.builder();
        for (JdbcColumnHandle columnHandle : columns) {
            if (columnHandle.equals(mergeRowId.get())) {
                columnAdaptationsBuilder.add((Object)JdbcPageSourceProvider.buildMergeIdColumnAdaptation(scanColumns, primaryKeys));
                continue;
            }
            columnAdaptationsBuilder.add((Object)new MergeJdbcPageSource.SourceColumn(scanColumns.indexOf(columnHandle)));
        }
        JdbcTableHandle newTableHandle = new JdbcTableHandle(tableHandle.getRelationHandle(), tableHandle.getConstraint(), tableHandle.getConstraintExpressions(), tableHandle.getSortOrder(), tableHandle.getLimit(), Optional.of(scanColumns), tableHandle.getOtherReferencedTables(), tableHandle.getNextSyntheticColumnId(), tableHandle.getAuthorization(), tableHandle.getUpdateAssignments());
        return new MergeJdbcPageSource(this.createPageSource(session, jdbcSplit, newTableHandle, scanColumns), (List<MergeJdbcPageSource.ColumnAdaptation>)columnAdaptationsBuilder.build());
    }

    private JdbcPageSource createPageSource(ConnectorSession session, JdbcSplit jdbcSplit, BaseJdbcConnectorTableHandle table, List<JdbcColumnHandle> columnHandles) {
        return (JdbcPageSource)RetryingModule.retry(this.policy, () -> new JdbcPageSource(this.jdbcClient, this.executor, session, jdbcSplit, table, columnHandles));
    }

    private static List<JdbcColumnHandle> getScanColumns(ConnectorSession session, JdbcClient jdbcClient, JdbcTableHandle tableHandle, List<JdbcColumnHandle> primaryKeys) {
        List<JdbcColumnHandle> allTableColumns = jdbcClient.getColumns(session, tableHandle.getRequiredNamedRelation().getSchemaTableName(), tableHandle.getRequiredNamedRelation().getRemoteTableName());
        ImmutableList.Builder scanColumnsBuilder = ImmutableList.builder();
        scanColumnsBuilder.addAll(allTableColumns);
        for (JdbcColumnHandle primaryKey : primaryKeys) {
            if (allTableColumns.contains(primaryKey)) continue;
            scanColumnsBuilder.add((Object)primaryKey);
        }
        return scanColumnsBuilder.build();
    }

    private static MergeJdbcPageSource.ColumnAdaptation buildMergeIdColumnAdaptation(List<JdbcColumnHandle> scanColumns, List<JdbcColumnHandle> primaryKeys) {
        List mergeRowIdSourceChannels = (List)primaryKeys.stream().map(scanColumns::indexOf).peek(channel -> Preconditions.checkArgument((channel >= 0 ? 1 : 0) != 0, (Object)"There are primary keys not exist in scan columns")).collect(ImmutableList.toImmutableList());
        return new MergeJdbcPageSource.MergedRowAdaptation(mergeRowIdSourceChannels);
    }
}

