/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import io.trino.plugin.jdbc.WriteFunction;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Objects;

public interface LongWriteFunction
extends WriteFunction {
    @Override
    default public Class<?> getJavaType() {
        return Long.TYPE;
    }

    public void set(PreparedStatement var1, int var2, long var3) throws SQLException;

    public static LongWriteFunction of(final int nullJdbcType, final LongWriteFunctionImplementation implementation) {
        Objects.requireNonNull(implementation, "implementation is null");
        return new LongWriteFunction(){

            @Override
            public void set(PreparedStatement statement, int index, long value) throws SQLException {
                implementation.set(statement, index, value);
            }

            @Override
            public void setNull(PreparedStatement statement, int index) throws SQLException {
                statement.setNull(index, nullJdbcType);
            }
        };
    }

    @FunctionalInterface
    public static interface LongWriteFunctionImplementation {
        public void set(PreparedStatement var1, int var2, long var3) throws SQLException;
    }
}

