/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.expression;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.expression.FunctionName;
import io.trino.spi.expression.StandardFunctions;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;

public enum ComparisonOperator {
    EQUAL(StandardFunctions.EQUAL_OPERATOR_FUNCTION_NAME, "="),
    NOT_EQUAL(StandardFunctions.NOT_EQUAL_OPERATOR_FUNCTION_NAME, "<>"),
    LESS_THAN(StandardFunctions.LESS_THAN_OPERATOR_FUNCTION_NAME, "<"),
    LESS_THAN_OR_EQUAL(StandardFunctions.LESS_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME, "<="),
    GREATER_THAN(StandardFunctions.GREATER_THAN_OPERATOR_FUNCTION_NAME, ">"),
    GREATER_THAN_OR_EQUAL(StandardFunctions.GREATER_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME, ">="),
    IDENTICAL(StandardFunctions.IDENTICAL_OPERATOR_FUNCTION_NAME, "IS NOT DISTINCT FROM");

    private final FunctionName functionName;
    private final String operator;
    private static final Map<FunctionName, ComparisonOperator> OPERATOR_BY_FUNCTION_NAME;

    private ComparisonOperator(FunctionName functionName, String operator) {
        this.functionName = Objects.requireNonNull(functionName, "functionName is null");
        this.operator = Objects.requireNonNull(operator, "operator is null");
    }

    public FunctionName getFunctionName() {
        return this.functionName;
    }

    public String getOperator() {
        return this.operator;
    }

    public static ComparisonOperator forFunctionName(FunctionName functionName) {
        return (ComparisonOperator)((Object)Verify.verifyNotNull((Object)((Object)OPERATOR_BY_FUNCTION_NAME.get(functionName)), (String)"Function name not recognized: %s", (Object[])new Object[]{functionName}));
    }

    static {
        OPERATOR_BY_FUNCTION_NAME = (Map)Stream.of(ComparisonOperator.values()).collect(ImmutableMap.toImmutableMap(ComparisonOperator::getFunctionName, Function.identity()));
    }
}

