/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.jdbc.expression.CallPattern;
import io.trino.plugin.jdbc.expression.ConnectorExpressionPatternBaseVisitor;
import io.trino.plugin.jdbc.expression.ConnectorExpressionPatternParser;
import io.trino.plugin.jdbc.expression.ExpressionCapture;
import io.trino.plugin.jdbc.expression.ExpressionPattern;
import io.trino.plugin.jdbc.expression.LongTypeParameter;
import io.trino.plugin.jdbc.expression.SimpleTypePattern;
import io.trino.plugin.jdbc.expression.TypeClassPattern;
import io.trino.plugin.jdbc.expression.TypeParameterCapture;
import io.trino.plugin.jdbc.expression.TypePattern;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public class ExpressionPatternBuilder
extends ConnectorExpressionPatternBaseVisitor<Object> {
    private final Map<String, Set<String>> typeClasses;

    public ExpressionPatternBuilder(Map<String, Set<String>> typeClasses) {
        this.typeClasses = ImmutableMap.copyOf(Objects.requireNonNull(typeClasses, "typeClasses is null"));
    }

    @Override
    public Object visitStandaloneExpression(ConnectorExpressionPatternParser.StandaloneExpressionContext context) {
        return this.visit((ParseTree)context.expression());
    }

    @Override
    public Object visitStandaloneType(ConnectorExpressionPatternParser.StandaloneTypeContext context) {
        return this.visit((ParseTree)context.type());
    }

    @Override
    public Object visitCall(ConnectorExpressionPatternParser.CallContext context) {
        return new CallPattern(this.visit(context.identifier(), String.class), this.visit(context.expression(), ExpressionPattern.class), this.visitIfPresent(context.type(), TypePattern.class));
    }

    @Override
    public ExpressionPattern visitExpressionCapture(ConnectorExpressionPatternParser.ExpressionCaptureContext context) {
        return new ExpressionCapture(this.visit(context.identifier(), String.class), this.visitIfPresent(context.type(), TypePattern.class));
    }

    @Override
    public TypePattern visitType(ConnectorExpressionPatternParser.TypeContext context) {
        String baseName = this.visit(context.identifier(), String.class);
        List<ConnectorExpressionPatternParser.TypeParameterContext> parameters = context.typeParameter();
        Set<String> typeClass = this.typeClasses.get(baseName);
        if (typeClass != null) {
            Preconditions.checkArgument((boolean)parameters.isEmpty(), (Object)"parameters are not allowed for a type class");
            return new TypeClassPattern(baseName, typeClass);
        }
        return new SimpleTypePattern(baseName, (List)parameters.stream().map(parameter -> {
            Object result = this.visit((ParserRuleContext)parameter, (Class)Object.class);
            if (result instanceof String) {
                String stringValue = (String)result;
                return new TypeParameterCapture(stringValue);
            }
            if (result instanceof Long) {
                Long longValue = (Long)result;
                return new LongTypeParameter(longValue);
            }
            throw new UnsupportedOperationException(String.format("Unsupported parameter %s (%s) from %s", result, result.getClass(), parameter));
        }).collect(ImmutableList.toImmutableList()));
    }

    @Override
    public Object visitNumber(ConnectorExpressionPatternParser.NumberContext context) {
        return Long.parseLong(context.INTEGER_VALUE().getText());
    }

    @Override
    public Object visitIdentifier(ConnectorExpressionPatternParser.IdentifierContext context) {
        return context.getText();
    }

    private <T> List<T> visit(List<? extends ParserRuleContext> contexts, Class<T> expected) {
        return (List)contexts.stream().map(context -> this.visit((ParserRuleContext)context, expected)).collect(ImmutableList.toImmutableList());
    }

    private <T> Optional<T> visitIfPresent(@Nullable ParserRuleContext context, Class<T> expected) {
        if (context == null) {
            return Optional.empty();
        }
        return Optional.of(this.visit(context, expected));
    }

    private <T> T visit(ParserRuleContext context, Class<T> expected) {
        return expected.cast(super.visit((ParseTree)context));
    }

    protected Object aggregateResult(Object aggregate, Object nextResult) {
        if (nextResult == null) {
            throw new UnsupportedOperationException("not yet implemented");
        }
        if (aggregate == null) {
            return nextResult;
        }
        throw new UnsupportedOperationException(String.format("Cannot combine %s and %s", aggregate, nextResult));
    }
}

