/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.expression;

import com.google.common.collect.ImmutableList;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.base.expression.ConnectorExpressionPatterns;
import io.trino.plugin.base.expression.ConnectorExpressionRule;
import io.trino.plugin.jdbc.CaseSensitivity;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.QueryParameter;
import io.trino.plugin.jdbc.expression.ParameterizedExpression;
import io.trino.spi.expression.Call;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.StandardFunctions;
import io.trino.spi.expression.Variable;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Optional;

public class RewriteLikeWithCaseSensitivity
implements ConnectorExpressionRule<Call, ParameterizedExpression> {
    private static final Capture<ConnectorExpression> LIKE_VALUE = Capture.newCapture();
    private static final Capture<ConnectorExpression> LIKE_PATTERN = Capture.newCapture();
    private static final Pattern<Call> PATTERN = ConnectorExpressionPatterns.call().with(ConnectorExpressionPatterns.functionName().equalTo((Object)StandardFunctions.LIKE_FUNCTION_NAME)).with(ConnectorExpressionPatterns.type().equalTo((Object)BooleanType.BOOLEAN)).with(ConnectorExpressionPatterns.argumentCount().equalTo((Object)2)).with(ConnectorExpressionPatterns.argument((int)0).matching(ConnectorExpressionPatterns.expression().capturedAs(LIKE_VALUE).with(ConnectorExpressionPatterns.type().matching(VarcharType.class::isInstance)))).with(ConnectorExpressionPatterns.argument((int)1).matching(ConnectorExpressionPatterns.expression().capturedAs(LIKE_PATTERN).with(ConnectorExpressionPatterns.type().matching(VarcharType.class::isInstance))));

    public Pattern<Call> getPattern() {
        return PATTERN;
    }

    public Optional<ParameterizedExpression> rewrite(Call expression, Captures captures, ConnectorExpressionRule.RewriteContext<ParameterizedExpression> context) {
        Variable variable;
        JdbcColumnHandle columnHandle;
        Optional<CaseSensitivity> caseSensitivity;
        ConnectorExpression capturedValue = (ConnectorExpression)captures.get(LIKE_VALUE);
        if (capturedValue instanceof Variable && (caseSensitivity = (columnHandle = (JdbcColumnHandle)context.getAssignment((variable = (Variable)capturedValue).getName())).getJdbcTypeHandle().caseSensitivity()).orElse(CaseSensitivity.CASE_INSENSITIVE) == CaseSensitivity.CASE_INSENSITIVE) {
            return Optional.empty();
        }
        Optional value = context.defaultRewrite(capturedValue);
        if (value.isEmpty()) {
            return Optional.empty();
        }
        ImmutableList.Builder parameters = ImmutableList.builder();
        parameters.addAll(((ParameterizedExpression)value.get()).parameters());
        Optional pattern = context.defaultRewrite((ConnectorExpression)captures.get(LIKE_PATTERN));
        if (pattern.isEmpty()) {
            return Optional.empty();
        }
        parameters.addAll(((ParameterizedExpression)pattern.get()).parameters());
        return Optional.of(new ParameterizedExpression(String.format("%s LIKE %s", ((ParameterizedExpression)value.get()).expression(), ((ParameterizedExpression)pattern.get()).expression()), (List<QueryParameter>)parameters.build()));
    }
}

