/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.duckdb;

import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.opentelemetry.api.OpenTelemetry;
import io.trino.plugin.duckdb.DuckDbClient;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DriverConnectionFactory;
import io.trino.plugin.jdbc.ForBaseJdbc;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcStatisticsConfig;
import io.trino.plugin.jdbc.credential.CredentialProvider;
import io.trino.plugin.jdbc.ptf.Query;
import io.trino.spi.function.table.ConnectorTableFunction;
import java.sql.Driver;
import java.util.Properties;
import org.duckdb.DuckDBDriver;

public final class DuckDbClientModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        binder.bind(JdbcClient.class).annotatedWith(ForBaseJdbc.class).to(DuckDbClient.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(JdbcStatisticsConfig.class);
        Multibinder.newSetBinder((Binder)binder, ConnectorTableFunction.class).addBinding().toProvider(Query.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    @ForBaseJdbc
    public static ConnectionFactory connectionFactory(BaseJdbcConfig config, CredentialProvider credentialProvider, OpenTelemetry openTelemetry) {
        Properties connectionProperties = new Properties();
        return DriverConnectionFactory.builder((Driver)new DuckDBDriver(), (String)config.getConnectionUrl(), (CredentialProvider)credentialProvider).setConnectionProperties(connectionProperties).setOpenTelemetry(openTelemetry).build();
    }
}

