/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.elasticsearch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.predicate.TupleDomain;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.stream.Collectors;

public final class ElasticsearchTableHandle
implements ConnectorTableHandle {
    private final Type type;
    private final String schema;
    private final String index;
    private final TupleDomain<ColumnHandle> constraint;
    private final Map<String, String> regexes;
    private final Optional<String> query;
    private final OptionalLong limit;

    public ElasticsearchTableHandle(Type type, String schema, String index, Optional<String> query) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.index = Objects.requireNonNull(index, "index is null");
        this.query = Objects.requireNonNull(query, "query is null");
        this.constraint = TupleDomain.all();
        this.regexes = ImmutableMap.of();
        this.limit = OptionalLong.empty();
    }

    @JsonCreator
    public ElasticsearchTableHandle(@JsonProperty(value="type") Type type, @JsonProperty(value="schema") String schema, @JsonProperty(value="index") String index, @JsonProperty(value="constraint") TupleDomain<ColumnHandle> constraint, @JsonProperty(value="regexes") Map<String, String> regexes, @JsonProperty(value="query") Optional<String> query, @JsonProperty(value="limit") OptionalLong limit) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.index = Objects.requireNonNull(index, "index is null");
        this.constraint = Objects.requireNonNull(constraint, "constraint is null");
        this.regexes = ImmutableMap.copyOf(Objects.requireNonNull(regexes, "regexes is null"));
        this.query = Objects.requireNonNull(query, "query is null");
        this.limit = Objects.requireNonNull(limit, "limit is null");
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @JsonProperty
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty
    public String getIndex() {
        return this.index;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getConstraint() {
        return this.constraint;
    }

    @JsonProperty
    public Map<String, String> getRegexes() {
        return this.regexes;
    }

    @JsonProperty
    public OptionalLong getLimit() {
        return this.limit;
    }

    @JsonProperty
    public Optional<String> getQuery() {
        return this.query;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElasticsearchTableHandle that = (ElasticsearchTableHandle)o;
        return this.type == that.type && this.schema.equals(that.schema) && this.index.equals(that.index) && this.constraint.equals(that.constraint) && this.regexes.equals(that.regexes) && this.query.equals(that.query) && this.limit.equals(that.limit);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.schema, this.index, this.constraint, this.regexes, this.query, this.limit});
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.valueOf((Object)this.type) + ":" + this.index);
        StringBuilder attributes = new StringBuilder();
        if (!this.regexes.isEmpty()) {
            attributes.append("regexes=[");
            attributes.append(this.regexes.entrySet().stream().map(regex -> (String)regex.getKey() + ":" + (String)regex.getValue()).collect(Collectors.joining(", ")));
            attributes.append("]");
        }
        this.limit.ifPresent(value -> attributes.append("limit=" + value));
        this.query.ifPresent(value -> attributes.append("query" + value));
        if (attributes.length() > 0) {
            builder.append("(");
            builder.append((CharSequence)attributes);
            builder.append(")");
        }
        return builder.toString();
    }

    public static enum Type {
        SCAN,
        QUERY;

    }
}

