/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.util.function.IntConsumer;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.routing.Murmur3HashFunction;
import org.elasticsearch.core.Nullable;

public abstract class IndexRouting {
    private final int routingNumShards;
    private final int routingFactor;

    public static IndexRouting fromIndexMetadata(IndexMetadata indexMetadata) {
        if (indexMetadata.isRoutingPartitionedIndex()) {
            return new Partitioned(indexMetadata.getRoutingNumShards(), indexMetadata.getRoutingFactor(), indexMetadata.getRoutingPartitionSize());
        }
        return new Unpartitioned(indexMetadata.getRoutingNumShards(), indexMetadata.getRoutingFactor());
    }

    private IndexRouting(int routingNumShards, int routingFactor) {
        this.routingNumShards = routingNumShards;
        this.routingFactor = routingFactor;
    }

    public abstract int shardId(String var1, @Nullable String var2);

    public abstract void collectSearchShards(String var1, IntConsumer var2);

    protected final int hashToShardId(int hash) {
        return Math.floorMod(hash, this.routingNumShards) / this.routingFactor;
    }

    private static int effectiveRoutingToHash(String effectiveRouting) {
        return Murmur3HashFunction.hash(effectiveRouting);
    }

    private static class Partitioned
    extends IndexRouting {
        private final int routingPartitionSize;

        Partitioned(int routingNumShards, int routingFactor, int routingPartitionSize) {
            super(routingNumShards, routingFactor);
            this.routingPartitionSize = routingPartitionSize;
        }

        @Override
        public int shardId(String id, @Nullable String routing) {
            if (routing == null) {
                throw new IllegalArgumentException("A routing value is required for gets from a partitioned index");
            }
            int offset = Math.floorMod(IndexRouting.effectiveRoutingToHash(id), this.routingPartitionSize);
            return this.hashToShardId(IndexRouting.effectiveRoutingToHash(routing) + offset);
        }

        @Override
        public void collectSearchShards(String routing, IntConsumer consumer) {
            int hash = IndexRouting.effectiveRoutingToHash(routing);
            for (int i = 0; i < this.routingPartitionSize; ++i) {
                consumer.accept(this.hashToShardId(hash + i));
            }
        }
    }

    private static class Unpartitioned
    extends IndexRouting {
        Unpartitioned(int routingNumShards, int routingFactor) {
            super(routingNumShards, routingFactor);
        }

        @Override
        public int shardId(String id, @Nullable String routing) {
            return this.hashToShardId(IndexRouting.effectiveRoutingToHash(routing == null ? id : routing));
        }

        @Override
        public void collectSearchShards(String routing, IntConsumer consumer) {
            consumer.accept(this.hashToShardId(IndexRouting.effectiveRoutingToHash(routing)));
        }
    }
}

