/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.DelayedBucket;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;

public abstract class TopBucketBuilder<B extends InternalMultiBucketAggregation.InternalBucket> {
    static final int USE_BUFFERING_BUILDER = 1024;
    protected final Consumer<DelayedBucket<B>> nonCompetitive;

    public static <B extends InternalMultiBucketAggregation.InternalBucket> TopBucketBuilder<B> build(int size, BucketOrder order, Consumer<DelayedBucket<B>> nonCompetitive) {
        if (size < 1024) {
            return new PriorityQueueTopBucketBuilder<B>(size, order, nonCompetitive);
        }
        return new BufferingTopBucketBuilder<B>(size, order, nonCompetitive);
    }

    private TopBucketBuilder(Consumer<DelayedBucket<B>> nonCompetitive) {
        this.nonCompetitive = nonCompetitive;
    }

    public abstract void add(DelayedBucket<B> var1);

    public abstract List<B> build();

    static class PriorityQueueTopBucketBuilder<B extends InternalMultiBucketAggregation.InternalBucket>
    extends TopBucketBuilder<B> {
        private final PriorityQueue<DelayedBucket<B>> queue;

        PriorityQueueTopBucketBuilder(int size, final BucketOrder order, Consumer<DelayedBucket<B>> nonCompetitive) {
            super(nonCompetitive);
            if (size >= ArrayUtil.MAX_ARRAY_LENGTH) {
                throw new IllegalArgumentException("can't reduce more than [" + ArrayUtil.MAX_ARRAY_LENGTH + "] buckets");
            }
            this.queue = new PriorityQueue<DelayedBucket<B>>(size){
                private final Comparator<DelayedBucket<? extends MultiBucketsAggregation.Bucket>> comparator;
                {
                    super(arg0);
                    this.comparator = order.delayedBucketComparator();
                }

                protected boolean lessThan(DelayedBucket<B> a, DelayedBucket<B> b) {
                    return this.comparator.compare(a, b) > 0;
                }
            };
        }

        @Override
        public void add(DelayedBucket<B> bucket) {
            DelayedBucket removed = (DelayedBucket)this.queue.insertWithOverflow(bucket);
            if (removed != null) {
                this.nonCompetitive.accept(removed);
                removed.nonCompetitive();
            }
        }

        @Override
        public List<B> build() {
            ArrayList result = new ArrayList(this.queue.size());
            for (int i = this.queue.size() - 1; i >= 0; --i) {
                result.add(((DelayedBucket)this.queue.pop()).reduced());
            }
            Collections.reverse(result);
            return result;
        }
    }

    private static class BufferingTopBucketBuilder<B extends InternalMultiBucketAggregation.InternalBucket>
    extends TopBucketBuilder<B> {
        private final int size;
        private final BucketOrder order;
        private List<DelayedBucket<B>> buffer;
        private PriorityQueueTopBucketBuilder<B> next;

        BufferingTopBucketBuilder(int size, BucketOrder order, Consumer<DelayedBucket<B>> nonCompetitive) {
            super(nonCompetitive);
            this.size = size;
            this.order = order;
            this.buffer = new ArrayList<DelayedBucket<B>>();
        }

        @Override
        public void add(DelayedBucket<B> bucket) {
            if (this.next != null) {
                assert (this.buffer == null);
                this.next.add(bucket);
                return;
            }
            this.buffer.add(bucket);
            if (this.buffer.size() < this.size) {
                return;
            }
            this.next = new PriorityQueueTopBucketBuilder(this.size, this.order, this.nonCompetitive);
            for (DelayedBucket<B> b : this.buffer) {
                ((PriorityQueueTopBucketBuilder)this.next).queue.add(b);
            }
            this.buffer = null;
        }

        @Override
        public List<B> build() {
            if (this.next != null) {
                assert (this.buffer == null);
                return this.next.build();
            }
            ArrayList<Object> result = new ArrayList<Object>(this.buffer.size());
            for (DelayedBucket<B> b : this.buffer) {
                result.add(b.reduced());
            }
            result.sort(this.order.comparator());
            return result;
        }
    }
}

