/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.storedscripts;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class DeleteStoredScriptRequest
extends AcknowledgedRequest<DeleteStoredScriptRequest> {
    private String id;

    public DeleteStoredScriptRequest(StreamInput in) throws IOException {
        super(in);
        if (in.getVersion().before(Version.V_6_0_0_alpha2)) {
            in.readString();
        }
        this.id = in.readString();
    }

    DeleteStoredScriptRequest() {
    }

    public DeleteStoredScriptRequest(String id) {
        this.id = id;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.id == null || this.id.isEmpty()) {
            validationException = ValidateActions.addValidationError("must specify id for stored script", validationException);
        } else if (this.id.contains("#")) {
            validationException = ValidateActions.addValidationError("id cannot contain '#' for stored script", validationException);
        }
        return validationException;
    }

    public String id() {
        return this.id;
    }

    public DeleteStoredScriptRequest id(String id) {
        this.id = id;
        return this;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().before(Version.V_6_0_0_alpha2)) {
            out.writeString("");
        }
        out.writeString(this.id);
    }

    @Override
    public String toString() {
        return "delete stored script {id [" + this.id + "]}";
    }
}

