/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.template.delete;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class DeleteComponentTemplateAction
extends ActionType<AcknowledgedResponse> {
    public static final DeleteComponentTemplateAction INSTANCE = new DeleteComponentTemplateAction();
    public static final String NAME = "cluster:admin/component_template/delete";

    private DeleteComponentTemplateAction() {
        super(NAME, AcknowledgedResponse::readFrom);
    }

    public static class Request
    extends MasterNodeRequest<Request> {
        private final String[] names;

        public Request(StreamInput in) throws IOException {
            super(in);
            this.names = in.getVersion().onOrAfter(Version.V_7_13_0) ? in.readStringArray() : new String[]{in.readString()};
        }

        public Request(String ... names) {
            this.names = Objects.requireNonNull(names, "component templates to delete must not be null");
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (!Arrays.stream(this.names).anyMatch(Strings::hasLength)) {
                validationException = ValidateActions.addValidationError("no component template names specified", validationException);
            }
            return validationException;
        }

        public String[] names() {
            return this.names;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            if (out.getVersion().onOrAfter(Version.V_7_13_0)) {
                out.writeStringArray(this.names);
            } else {
                out.writeString(this.names[0]);
            }
        }
    }
}

