/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.time;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.time.DateUtilsRounding;
import org.joda.time.DateTimeZone;

public class DateUtils {
    public static final long MAX_MILLIS_BEFORE_9999 = 253402300799999L;
    public static final long MAX_MILLIS_BEFORE_MINUS_9999 = -377705116800000L;
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(DateUtils.class);
    static final Map<String, String> DEPRECATED_SHORT_TIMEZONES;
    public static final Set<String> DEPRECATED_SHORT_TZ_IDS;
    public static final Map<String, String> DEPRECATED_LONG_TIMEZONES;
    public static final Instant MAX_NANOSECOND_INSTANT;
    static final long MAX_NANOSECOND_IN_MILLIS;
    public static final long MAX_NANOSECOND;

    public static DateTimeZone zoneIdToDateTimeZone(ZoneId zoneId) {
        if (zoneId == null) {
            return null;
        }
        if (zoneId instanceof ZoneOffset) {
            return DateTimeZone.forOffsetMillis((int)(((ZoneOffset)zoneId).getTotalSeconds() * 1000));
        }
        return DateTimeZone.forID((String)zoneId.getId());
    }

    public static ZoneId dateTimeZoneToZoneId(DateTimeZone timeZone) {
        if (timeZone == null) {
            return null;
        }
        if (DateTimeZone.UTC.equals((Object)timeZone)) {
            return ZoneOffset.UTC;
        }
        return DateUtils.of(timeZone.getID());
    }

    public static ZoneId of(String zoneId) {
        String deprecatedId = DEPRECATED_SHORT_TIMEZONES.get(zoneId);
        if (deprecatedId != null) {
            deprecationLogger.warn(DeprecationCategory.PARSING, "timezone", "Use of short timezone id " + zoneId + " is deprecated. Use " + deprecatedId + " instead", new Object[0]);
            return ZoneId.of(deprecatedId);
        }
        return ZoneId.of(zoneId).normalized();
    }

    public static long toLong(Instant instant) {
        if (instant.isBefore(Instant.EPOCH)) {
            throw new IllegalArgumentException("date[" + instant + "] is before the epoch in 1970 and cannot be stored in nanosecond resolution");
        }
        if (instant.isAfter(MAX_NANOSECOND_INSTANT)) {
            throw new IllegalArgumentException("date[" + instant + "] is after 2262-04-11T23:47:16.854775807 and cannot be stored in nanosecond resolution");
        }
        return instant.getEpochSecond() * 1000000000L + (long)instant.getNano();
    }

    public static Instant clampToNanosRange(Instant instant) {
        if (instant.isBefore(Instant.EPOCH)) {
            return Instant.EPOCH;
        }
        if (instant.isAfter(MAX_NANOSECOND_INSTANT)) {
            return MAX_NANOSECOND_INSTANT;
        }
        return instant;
    }

    public static Instant toInstant(long nanoSecondsSinceEpoch) {
        if (nanoSecondsSinceEpoch < 0L) {
            throw new IllegalArgumentException("nanoseconds [" + nanoSecondsSinceEpoch + "] are before the epoch in 1970 and cannot be processed in nanosecond resolution");
        }
        if (nanoSecondsSinceEpoch == 0L) {
            return Instant.EPOCH;
        }
        long seconds = nanoSecondsSinceEpoch / 1000000000L;
        long nanos = nanoSecondsSinceEpoch % 1000000000L;
        return Instant.ofEpochSecond(seconds, nanos);
    }

    public static long toNanoSeconds(long milliSecondsSinceEpoch) {
        if (milliSecondsSinceEpoch < 0L) {
            throw new IllegalArgumentException("milliSeconds [" + milliSecondsSinceEpoch + "] are before the epoch in 1970 and cannot be converted to nanoseconds");
        }
        if (milliSecondsSinceEpoch > MAX_NANOSECOND_IN_MILLIS) {
            throw new IllegalArgumentException("milliSeconds [" + milliSecondsSinceEpoch + "] are after 2262-04-11T23:47:16.854775807 and cannot be converted to nanoseconds");
        }
        return milliSecondsSinceEpoch * 1000000L;
    }

    public static long toMilliSeconds(long nanoSecondsSinceEpoch) {
        if (nanoSecondsSinceEpoch < 0L) {
            throw new IllegalArgumentException("nanoseconds are [" + nanoSecondsSinceEpoch + "] are before the epoch in 1970 and cannot be converted to milliseconds");
        }
        if (nanoSecondsSinceEpoch == 0L) {
            return 0L;
        }
        return nanoSecondsSinceEpoch / 1000000L;
    }

    public static long roundFloor(long utcMillis, long unitMillis) {
        if (utcMillis >= 0L) {
            return utcMillis - utcMillis % unitMillis;
        }
        return ++utcMillis - utcMillis % unitMillis - unitMillis;
    }

    public static long roundQuarterOfYear(long utcMillis) {
        int year = DateUtilsRounding.getYear(utcMillis);
        int month = DateUtilsRounding.getMonthOfYear(utcMillis, year);
        int firstMonthOfQuarter = (month - 1) / 3 * 3 + 1;
        return DateUtils.of(year, firstMonthOfQuarter);
    }

    public static long roundMonthOfYear(long utcMillis) {
        int year = DateUtilsRounding.getYear(utcMillis);
        int month = DateUtilsRounding.getMonthOfYear(utcMillis, year);
        return DateUtils.of(year, month);
    }

    public static long roundYear(long utcMillis) {
        int year = DateUtilsRounding.getYear(utcMillis);
        return DateUtilsRounding.utcMillisAtStartOfYear(year);
    }

    public static long roundWeekOfWeekYear(long utcMillis) {
        return DateUtils.roundFloor(utcMillis + 259200000L, 604800000L) - 259200000L;
    }

    private static long of(int year, int month) {
        long millis = DateUtilsRounding.utcMillisAtStartOfYear(year);
        return millis += DateUtilsRounding.getTotalMillisByYearMonth(year, month);
    }

    public static ZonedDateTime nowWithMillisResolution() {
        return DateUtils.nowWithMillisResolution(Clock.systemUTC());
    }

    public static ZonedDateTime nowWithMillisResolution(Clock clock) {
        Clock millisResolutionClock = Clock.tick(clock, Duration.ofMillis(1L));
        return ZonedDateTime.now(millisResolutionClock);
    }

    static {
        HashMap<String, String> tzs = new HashMap<String, String>();
        tzs.put("EST", "-05:00");
        tzs.put("HST", "-10:00");
        tzs.put("MST", "-07:00");
        tzs.put("ROC", "Asia/Taipei");
        tzs.put("Eire", "Europe/London");
        DEPRECATED_SHORT_TIMEZONES = Collections.unmodifiableMap(tzs);
        DEPRECATED_SHORT_TZ_IDS = tzs.keySet();
        tzs = new HashMap();
        tzs.put("Africa/Asmera", "Africa/Nairobi");
        tzs.put("Africa/Timbuktu", "Africa/Abidjan");
        tzs.put("America/Argentina/ComodRivadavia", "America/Argentina/Catamarca");
        tzs.put("America/Atka", "America/Adak");
        tzs.put("America/Buenos_Aires", "America/Argentina/Buenos_Aires");
        tzs.put("America/Catamarca", "America/Argentina/Catamarca");
        tzs.put("America/Coral_Harbour", "America/Atikokan");
        tzs.put("America/Cordoba", "America/Argentina/Cordoba");
        tzs.put("America/Ensenada", "America/Tijuana");
        tzs.put("America/Fort_Wayne", "America/Indiana/Indianapolis");
        tzs.put("America/Indianapolis", "America/Indiana/Indianapolis");
        tzs.put("America/Jujuy", "America/Argentina/Jujuy");
        tzs.put("America/Knox_IN", "America/Indiana/Knox");
        tzs.put("America/Louisville", "America/Kentucky/Louisville");
        tzs.put("America/Mendoza", "America/Argentina/Mendoza");
        tzs.put("America/Montreal", "America/Toronto");
        tzs.put("America/Porto_Acre", "America/Rio_Branco");
        tzs.put("America/Rosario", "America/Argentina/Cordoba");
        tzs.put("America/Santa_Isabel", "America/Tijuana");
        tzs.put("America/Shiprock", "America/Denver");
        tzs.put("America/Virgin", "America/Port_of_Spain");
        tzs.put("Antarctica/South_Pole", "Pacific/Auckland");
        tzs.put("Asia/Ashkhabad", "Asia/Ashgabat");
        tzs.put("Asia/Calcutta", "Asia/Kolkata");
        tzs.put("Asia/Chongqing", "Asia/Shanghai");
        tzs.put("Asia/Chungking", "Asia/Shanghai");
        tzs.put("Asia/Dacca", "Asia/Dhaka");
        tzs.put("Asia/Harbin", "Asia/Shanghai");
        tzs.put("Asia/Kashgar", "Asia/Urumqi");
        tzs.put("Asia/Katmandu", "Asia/Kathmandu");
        tzs.put("Asia/Macao", "Asia/Macau");
        tzs.put("Asia/Rangoon", "Asia/Yangon");
        tzs.put("Asia/Saigon", "Asia/Ho_Chi_Minh");
        tzs.put("Asia/Tel_Aviv", "Asia/Jerusalem");
        tzs.put("Asia/Thimbu", "Asia/Thimphu");
        tzs.put("Asia/Ujung_Pandang", "Asia/Makassar");
        tzs.put("Asia/Ulan_Bator", "Asia/Ulaanbaatar");
        tzs.put("Atlantic/Faeroe", "Atlantic/Faroe");
        tzs.put("Atlantic/Jan_Mayen", "Europe/Oslo");
        tzs.put("Australia/ACT", "Australia/Sydney");
        tzs.put("Australia/Canberra", "Australia/Sydney");
        tzs.put("Australia/LHI", "Australia/Lord_Howe");
        tzs.put("Australia/NSW", "Australia/Sydney");
        tzs.put("Australia/North", "Australia/Darwin");
        tzs.put("Australia/Queensland", "Australia/Brisbane");
        tzs.put("Australia/South", "Australia/Adelaide");
        tzs.put("Australia/Tasmania", "Australia/Hobart");
        tzs.put("Australia/Victoria", "Australia/Melbourne");
        tzs.put("Australia/West", "Australia/Perth");
        tzs.put("Australia/Yancowinna", "Australia/Broken_Hill");
        tzs.put("Brazil/Acre", "America/Rio_Branco");
        tzs.put("Brazil/DeNoronha", "America/Noronha");
        tzs.put("Brazil/East", "America/Sao_Paulo");
        tzs.put("Brazil/West", "America/Manaus");
        tzs.put("Canada/Atlantic", "America/Halifax");
        tzs.put("Canada/Central", "America/Winnipeg");
        tzs.put("Canada/East-Saskatchewan", "America/Regina");
        tzs.put("Canada/Eastern", "America/Toronto");
        tzs.put("Canada/Mountain", "America/Edmonton");
        tzs.put("Canada/Newfoundland", "America/St_Johns");
        tzs.put("Canada/Pacific", "America/Vancouver");
        tzs.put("Canada/Yukon", "America/Whitehorse");
        tzs.put("Chile/Continental", "America/Santiago");
        tzs.put("Chile/EasterIsland", "Pacific/Easter");
        tzs.put("Cuba", "America/Havana");
        tzs.put("Egypt", "Africa/Cairo");
        tzs.put("Eire", "Europe/Dublin");
        tzs.put("Europe/Belfast", "Europe/London");
        tzs.put("Europe/Tiraspol", "Europe/Chisinau");
        tzs.put("GB", "Europe/London");
        tzs.put("GB-Eire", "Europe/London");
        tzs.put("Greenwich", "Etc/GMT");
        tzs.put("Hongkong", "Asia/Hong_Kong");
        tzs.put("Iceland", "Atlantic/Reykjavik");
        tzs.put("Iran", "Asia/Tehran");
        tzs.put("Israel", "Asia/Jerusalem");
        tzs.put("Jamaica", "America/Jamaica");
        tzs.put("Japan", "Asia/Tokyo");
        tzs.put("Kwajalein", "Pacific/Kwajalein");
        tzs.put("Libya", "Africa/Tripoli");
        tzs.put("Mexico/BajaNorte", "America/Tijuana");
        tzs.put("Mexico/BajaSur", "America/Mazatlan");
        tzs.put("Mexico/General", "America/Mexico_City");
        tzs.put("NZ", "Pacific/Auckland");
        tzs.put("NZ-CHAT", "Pacific/Chatham");
        tzs.put("Navajo", "America/Denver");
        tzs.put("PRC", "Asia/Shanghai");
        tzs.put("Pacific/Johnston", "Pacific/Honolulu");
        tzs.put("Pacific/Ponape", "Pacific/Pohnpei");
        tzs.put("Pacific/Samoa", "Pacific/Pago_Pago");
        tzs.put("Pacific/Truk", "Pacific/Chuuk");
        tzs.put("Pacific/Yap", "Pacific/Chuuk");
        tzs.put("Poland", "Europe/Warsaw");
        tzs.put("Portugal", "Europe/Lisbon");
        tzs.put("ROC", "Asia/Taipei");
        tzs.put("ROK", "Asia/Seoul");
        tzs.put("Singapore", "Asia/Singapore");
        tzs.put("Turkey", "Europe/Istanbul");
        tzs.put("UCT", "Etc/UCT");
        tzs.put("US/Alaska", "America/Anchorage");
        tzs.put("US/Aleutian", "America/Adak");
        tzs.put("US/Arizona", "America/Phoenix");
        tzs.put("US/Central", "America/Chicago");
        tzs.put("US/East-Indiana", "America/Indiana/Indianapolis");
        tzs.put("US/Eastern", "America/New_York");
        tzs.put("US/Hawaii", "Pacific/Honolulu");
        tzs.put("US/Indiana-Starke", "America/Indiana/Knox");
        tzs.put("US/Michigan", "America/Detroit");
        tzs.put("US/Mountain", "America/Denver");
        tzs.put("US/Pacific", "America/Los_Angeles");
        tzs.put("US/Samoa", "Pacific/Pago_Pago");
        tzs.put("Universal", "Etc/UTC");
        tzs.put("W-SU", "Europe/Moscow");
        tzs.put("Zulu", "Etc/UTC");
        DEPRECATED_LONG_TIMEZONES = Collections.unmodifiableMap(tzs);
        MAX_NANOSECOND_INSTANT = Instant.parse("2262-04-11T23:47:16.854775807Z");
        MAX_NANOSECOND_IN_MILLIS = MAX_NANOSECOND_INSTANT.toEpochMilli();
        MAX_NANOSECOND = DateUtils.toLong(MAX_NANOSECOND_INSTANT);
    }
}

